/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Block {
    private static final Logger LOG = Logger.getInstance(Block.class);
    @NotNull
    private final String[] mySource;
    private final int myStart;
    private final int myEnd;

    public Block(@NotNull String source, int start, int end) {
        if (source == null) {
            Block.$$$reportNull$$$0(0);
        }
        this(Block.tokenize(source), start, end);
    }

    public Block(@NotNull String[] source, int start, int end) {
        if (source == null) {
            Block.$$$reportNull$$$0(1);
        }
        this.mySource = source;
        this.myStart = DiffUtil.bound(start, 0, source.length);
        this.myEnd = DiffUtil.bound(end, this.myStart, source.length);
    }

    @NotNull
    public static String[] tokenize(@NotNull String text) {
        if (text == null) {
            Block.$$$reportNull$$$0(2);
        }
        String[] stringArray = LineTokenizer.tokenize((CharSequence)text, (boolean)false, (boolean)false);
        if (stringArray == null) {
            Block.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String prevContent) {
        if (prevContent == null) {
            Block.$$$reportNull$$$0(4);
        }
        Block block = this.createPreviousBlock(Block.tokenize(prevContent));
        if (block == null) {
            Block.$$$reportNull$$$0(5);
        }
        return block;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String[] prevContent) {
        Block block;
        block8: {
            if (prevContent == null) {
                Block.$$$reportNull$$$0(6);
            }
            try {
                FairDiffIterable iterable = ByLine.compare(Arrays.asList(prevContent), Arrays.asList(this.mySource), ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
                boolean greedy = this.myStart != this.myEnd;
                int start = this.myStart;
                int end = this.myEnd;
                int shift = 0;
                for (Range range2 : iterable.iterateChanges()) {
                    int changeStart = range2.start2 + shift;
                    int changeEnd = range2.end2 + shift;
                    int changeShift = range2.end1 - range2.start1 - (range2.end2 - range2.start2);
                    DiffUtil.UpdatedLineRange updatedRange = DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, changeShift, greedy);
                    start = updatedRange.startLine;
                    end = updatedRange.endLine;
                    shift += changeShift;
                }
                if (start < 0 || end > prevContent.length || end < start) {
                    LOG.error("Invalid block range: [" + start + ", " + end + "); length - " + prevContent.length);
                }
                for (Range range2 : iterable.iterateUnchanged()) {
                    int count = range2.end1 - range2.start1;
                    for (int i = 0; i < count; ++i) {
                        int prevIndex = range2.start1 + i;
                        int sourceIndex = range2.start2 + i;
                        if (!prevContent[prevIndex].equals(this.mySource[sourceIndex])) continue;
                        prevContent[prevIndex] = this.mySource[sourceIndex];
                    }
                }
                block = new Block(prevContent, start, end);
                if (block != null) break block8;
            }
            catch (DiffTooBigException e) {
                Block block2 = new Block(prevContent, 0, 0);
                if (block2 == null) {
                    Block.$$$reportNull$$$0(8);
                }
                return block2;
            }
            Block.$$$reportNull$$$0(7);
        }
        return block;
    }

    @NotNull
    public String getBlockContent() {
        String string = StringUtil.join(this.getLines(), (String)"\n");
        if (string == null) {
            Block.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public List<String> getLines() {
        List<String> list2 = Arrays.asList(this.mySource).subList(this.myStart, this.myEnd);
        if (list2 == null) {
            Block.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySource) ^ this.myStart ^ this.myEnd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return Arrays.equals(this.mySource, other.mySource) && this.myStart == other.myStart && this.myEnd == other.myEnd;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        this.appendLines(result2, 0, this.myStart);
        result2.append("<-----------------------------\n");
        this.appendLines(result2, this.myStart, this.myEnd);
        result2.append("----------------------------->\n");
        this.appendLines(result2, this.myEnd, this.mySource.length);
        return result2.toString();
    }

    private void appendLines(@NotNull StringBuilder result2, int from, int to) {
        if (result2 == null) {
            Block.$$$reportNull$$$0(11);
        }
        for (int i = from; i < to; ++i) {
            result2.append(this.mySource[i]);
            result2.append("\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/Block";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevContent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/Block";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviousBlock";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPreviousBlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

