/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntFunction;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelSupport {
    public static final String PLACEHOLDER = "     ";
    private static final Key<FoldingCache> CACHE_KEY = Key.create((String)"Diff.FoldingUtil.Cache");
    protected final int myCount;
    @NotNull
    protected final EditorEx[] myEditors;
    @NotNull
    protected final List<FoldedBlock[]> myFoldings;
    private boolean myDuringSynchronize;
    private final boolean[] myShouldUpdateLineNumbers;

    public FoldingModelSupport(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
        if (editors == null) {
            FoldingModelSupport.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            FoldingModelSupport.$$$reportNull$$$0(1);
        }
        this.myFoldings = new ArrayList<FoldedBlock[]>();
        this.myEditors = editors;
        this.myCount = this.myEditors.length;
        this.myShouldUpdateLineNumbers = new boolean[this.myCount];
        MyDocumentListener documentListener = new MyDocumentListener();
        List documents = ContainerUtil.map((Object[])this.myEditors, EditorEx::getDocument);
        TextDiffViewerUtil.installDocumentListeners(documentListener, documents, disposable);
        for (int i = 0; i < this.myCount; ++i) {
            if (this.myCount <= 1) continue;
            this.myEditors[i].getFoldingModel().addListener(new MyFoldingListener(i), disposable);
        }
    }

    public int getCount() {
        return this.myCount;
    }

    protected void install(@Nullable Iterator<int[]> changedLines, @Nullable UserDataHolder context, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (FoldedBlock folding : this.getFoldedBlocks()) {
            folding.destroyHighlighter();
        }
        this.runBatchOperation(() -> {
            if (settings == null) {
                FoldingModelSupport.$$$reportNull$$$0(15);
            }
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                folding.destroyFolding();
            }
            this.myFoldings.clear();
            if (changedLines != null && settings.range != -1) {
                FoldingBuilder builder = new FoldingBuilder(context, settings);
                builder.build(changedLines);
            }
        });
        this.updateLineNumbers(true);
    }

    @Nullable
    public static FoldRegion addFolding(@NotNull EditorEx editor, int start, int end, boolean expanded) {
        if (editor == null) {
            FoldingModelSupport.$$$reportNull$$$0(3);
        }
        DocumentEx document = editor.getDocument();
        int startOffset = document.getLineStartOffset(start);
        int endOffset = document.getLineEndOffset(end - 1);
        FoldRegion value = editor.getFoldingModel().addFoldRegion(startOffset, endOffset, PLACEHOLDER);
        if (value != null) {
            value.setExpanded(expanded);
            value.putUserData(FoldRegion.MUTE_INNER_HIGHLIGHTERS, (Object)Boolean.TRUE);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FoldingModelSupport.$$$reportNull$$$0(4);
        }
        Runnable lastRunnable = runnable2;
        for (EditorEx editor : this.myEditors) {
            Runnable finalRunnable = lastRunnable;
            lastRunnable = () -> {
                if (DiffUtil.isFocusedComponent(editor.getComponent())) {
                    editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret(finalRunnable);
                } else {
                    editor.getFoldingModel().runBatchFoldingOperation(finalRunnable);
                }
            };
        }
        this.myDuringSynchronize = true;
        try {
            lastRunnable.run();
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void destroy() {
        for (FoldedBlock folding : this.getFoldedBlocks()) {
            folding.destroyHighlighter();
        }
        this.runBatchOperation(() -> {
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                folding.destroyFolding();
            }
            this.myFoldings.clear();
        });
    }

    @NotNull
    public TIntFunction getLineConvertor(int index) {
        TIntFunction tIntFunction = value -> {
            this.updateLineNumbers(false);
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                int line = folding.getLine(index);
                if (line == -1) continue;
                if (line > value) break;
                FoldRegion region = folding.getRegion(index);
                if (line != value || region == null || region.isExpanded()) continue;
                return -1;
            }
            return value;
        };
        if (tIntFunction == null) {
            FoldingModelSupport.$$$reportNull$$$0(5);
        }
        return tIntFunction;
    }

    private void updateLineNumbers(boolean force) {
        for (int i = 0; i < this.myCount; ++i) {
            if (!this.myShouldUpdateLineNumbers[i] && !force) continue;
            this.myShouldUpdateLineNumbers[i] = false;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                folding.updateLineNumber(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAll(boolean expanded) {
        if (this.myDuringSynchronize) {
            return;
        }
        this.myDuringSynchronize = true;
        try {
            int i = 0;
            while (i < this.myCount) {
                int index = i++;
                FoldingModelEx model = this.myEditors[index].getFoldingModel();
                model.runBatchFoldingOperation(() -> {
                    for (FoldedBlock folding : this.getFoldedBlocks()) {
                        FoldRegion region = folding.getRegion(index);
                        if (region == null) continue;
                        region.setExpanded(expanded);
                    }
                });
            }
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void updateContext(@NotNull UserDataHolder context, @NotNull Settings settings) {
        if (context == null) {
            FoldingModelSupport.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(7);
        }
        if (this.myFoldings.isEmpty()) {
            return;
        }
        context.putUserData(CACHE_KEY, (Object)this.getFoldingCache(settings));
    }

    @NotNull
    private FoldingCache getFoldingCache(@NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(8);
        }
        FoldingCache foldingCache = (FoldingCache)ReadAction.compute(() -> {
            if (settings == null) {
                FoldingModelSupport.$$$reportNull$$$0(14);
            }
            List[] result2 = new List[this.myCount];
            for (int i = 0; i < this.myCount; ++i) {
                result2[i] = this.getFoldedRanges(i, settings);
            }
            return new FoldingCache(result2, settings.defaultExpanded);
        });
        if (foldingCache == null) {
            FoldingModelSupport.$$$reportNull$$$0(9);
        }
        return foldingCache;
    }

    @NotNull
    private List<FoldedRangeState> getFoldedRanges(int index, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<FoldedRangeState> ranges = new ArrayList<FoldedRangeState>();
        DocumentEx document = this.myEditors[index].getDocument();
        for (FoldedBlock[] blocks : this.myFoldings) {
            LineRange expanded = null;
            LineRange collapsed = null;
            for (FoldedBlock folding : blocks) {
                int line2;
                int line1;
                FoldRegion region = folding.getRegion(index);
                if (region == null || !region.isValid()) continue;
                if (region.isExpanded()) {
                    if (expanded != null) continue;
                    line1 = document.getLineNumber(region.getStartOffset());
                    line2 = document.getLineNumber(region.getEndOffset()) + 1;
                    expanded = new LineRange(line1, line2);
                    continue;
                }
                line1 = document.getLineNumber(region.getStartOffset());
                line2 = document.getLineNumber(region.getEndOffset()) + 1;
                collapsed = new LineRange(line1, line2);
                break;
            }
            if (expanded == null && collapsed == null) continue;
            ranges.add(new FoldedRangeState(expanded, collapsed));
        }
        ArrayList<FoldedRangeState> arrayList = ranges;
        if (arrayList == null) {
            FoldingModelSupport.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private Iterable<FoldedBlock> getFoldedBlocks() {
        Iterable<FoldedBlock> iterable = () -> new Iterator<FoldedBlock>(){
            private int myGroupIndex = 0;
            private int myBlockIndex = 0;

            @Override
            public boolean hasNext() {
                return this.myGroupIndex < FoldingModelSupport.this.myFoldings.size();
            }

            @Override
            public FoldedBlock next() {
                FoldedBlock[] group = FoldingModelSupport.this.myFoldings.get(this.myGroupIndex);
                FoldedBlock folding = group[this.myBlockIndex];
                if (group.length > this.myBlockIndex + 1) {
                    ++this.myBlockIndex;
                } else {
                    ++this.myGroupIndex;
                    this.myBlockIndex = 0;
                }
                return folding;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            FoldingModelSupport.$$$reportNull$$$0(12);
        }
        return iterable;
    }

    private static int getRangeShift(int range2, int number) {
        switch (number) {
            case 0: {
                return range2;
            }
            case 1: {
                return range2 * 2;
            }
            case 2: {
                return range2 * 4;
            }
        }
        return -1;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    protected static <T, V> Iterator<V> map(@Nullable List<T> list2, final @NotNull Function<T, V> mapping) {
        if (mapping == null) {
            FoldingModelSupport.$$$reportNull$$$0(13);
        }
        if (list2 == null) {
            return null;
        }
        final Iterator<T> it = list2.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public V next() {
                return mapping.fun(it.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/FoldingModelSupport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConvertor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingCache";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedRanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFolding";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runBatchOperation";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingCache";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFoldedRanges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFoldingCache$5";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$install$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings {
        public final int range;
        public final boolean defaultExpanded;

        public Settings(int range2, boolean defaultExpanded) {
            this.range = range2;
            this.defaultExpanded = defaultExpanded;
        }
    }

    protected class FoldedBlock {
        @NotNull
        private final FoldRegion[] myRegions;
        @NotNull
        private final int[] myLines;
        @NotNull
        private final List<RangeHighlighter> myHighlighters;

        public FoldedBlock(FoldRegion[] regions) {
            if (regions == null) {
                FoldedBlock.$$$reportNull$$$0(0);
            }
            this.myHighlighters = new ArrayList<RangeHighlighter>(FoldingModelSupport.this.myCount);
            assert (regions.length == FoldingModelSupport.this.myCount);
            this.myRegions = regions;
            this.myLines = new int[FoldingModelSupport.this.myCount];
        }

        public void installHighlighter(@NotNull FoldedBlock[] block) {
            if (block == null) {
                FoldedBlock.$$$reportNull$$$0(1);
            }
            assert (this.myHighlighters.isEmpty());
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                if (region == null || !region.isValid()) continue;
                this.myHighlighters.addAll(DiffDrawUtil.createLineSeparatorHighlighter(FoldingModelSupport.this.myEditors[i], region.getStartOffset(), region.getEndOffset(), this.getHighlighterCondition(block, i)));
            }
        }

        public void destroyFolding() {
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                if (region == null) continue;
                FoldingModelSupport.this.myEditors[i].getFoldingModel().removeFoldRegion(region);
            }
        }

        public void destroyHighlighter() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            this.myHighlighters.clear();
        }

        public void updateLineNumber(int index) {
            FoldRegion region = this.myRegions[index];
            this.myLines[index] = region == null || !region.isValid() ? -1 : FoldingModelSupport.this.myEditors[index].getDocument().getLineNumber(region.getStartOffset());
        }

        @Nullable
        public FoldRegion getRegion(int index) {
            return this.myRegions[index];
        }

        public int getLine(int index) {
            return this.myLines[index];
        }

        @NotNull
        private BooleanGetter getHighlighterCondition(@NotNull FoldedBlock[] block, int index) {
            if (block == null) {
                FoldedBlock.$$$reportNull$$$0(2);
            }
            BooleanGetter booleanGetter = () -> {
                if (block == null) {
                    FoldedBlock.$$$reportNull$$$0(4);
                }
                if (!FoldingModelSupport.this.myEditors[index].getFoldingModel().isFoldingEnabled()) {
                    return false;
                }
                for (FoldedBlock folding : block) {
                    boolean visible;
                    FoldRegion region = folding.getRegion(index);
                    boolean bl = visible = region != null && region.isValid() && !region.isExpanded();
                    if (folding == this) {
                        return visible;
                    }
                    if (!visible) continue;
                    return false;
                }
                return false;
            };
            if (booleanGetter == null) {
                FoldedBlock.$$$reportNull$$$0(3);
            }
            return booleanGetter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regions";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlighterCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "installHighlighter";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getHighlighterCondition";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getHighlighterCondition$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FoldedRangeState {
        @Nullable
        public final LineRange expanded;
        @Nullable
        public final LineRange collapsed;

        public FoldedRangeState(@Nullable LineRange expanded, @Nullable LineRange collapsed) {
            assert (expanded != null || collapsed != null);
            this.expanded = expanded;
            this.collapsed = collapsed;
        }

        @NotNull
        public LineRange getLineRange() {
            LineRange lineRange = this.expanded != null ? this.expanded : this.collapsed;
            if (lineRange == null) {
                FoldedRangeState.$$$reportNull$$$0(0);
            }
            return lineRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedRangeState", "getLineRange"));
        }
    }

    private static class FoldingCache {
        public final boolean expandByDefault;
        @NotNull
        public final List<FoldedRangeState>[] ranges;

        public FoldingCache(@NotNull List<FoldedRangeState>[] ranges, boolean expandByDefault) {
            if (ranges == null) {
                FoldingCache.$$$reportNull$$$0(0);
            }
            this.ranges = ranges;
            this.expandByDefault = expandByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingCache", "<init>"));
        }
    }

    private class ExpandSuggester {
        @Nullable
        private final FoldingCache myCache;
        private final int[] myIndex;
        private final boolean myDefault;

        public ExpandSuggester(FoldingCache cache, boolean defaultValue) {
            this.myIndex = new int[FoldingModelSupport.this.myCount];
            this.myCache = cache;
            this.myDefault = defaultValue;
        }

        public boolean isExpanded(int[] starts, int[] ends) {
            if (this.myCache == null || this.myCache.ranges.length != FoldingModelSupport.this.myCount) {
                return this.myDefault;
            }
            if (this.myDefault != this.myCache.expandByDefault) {
                return this.myDefault;
            }
            Boolean state = null;
            for (int index = 0; index < FoldingModelSupport.this.myCount; ++index) {
                Boolean sideState = this.getCachedExpanded(starts[index], ends[index], index);
                if (sideState == null) continue;
                if (state == null) {
                    state = sideState;
                    continue;
                }
                if (state == sideState) continue;
                return this.myDefault;
            }
            return state == null ? this.myDefault : state;
        }

        @Nullable
        private Boolean getCachedExpanded(int start, int end, int index) {
            if (start == end) {
                return null;
            }
            List<FoldedRangeState> ranges = this.myCache.ranges[index];
            while (this.myIndex[index] < ranges.size()) {
                FoldedRangeState range2 = ranges.get(this.myIndex[index]);
                LineRange lineRange = range2.getLineRange();
                if (lineRange.end > start) {
                    if (lineRange.contains(start, end)) {
                        if (range2.collapsed != null && range2.collapsed.contains(start, end)) {
                            return false;
                        }
                        if (range2.expanded != null && range2.expanded.contains(start, end)) {
                            return true;
                        }
                        assert (false) : "Invalid LineRange" + range2.expanded + ", " + range2.collapsed + ", " + new LineRange(start, end);
                    }
                    if (lineRange.start >= start) {
                        return null;
                    }
                }
                int n = index;
                this.myIndex[n] = this.myIndex[n] + 1;
            }
            return null;
        }
    }

    protected class MyPaintable
    implements DiffDividerDrawUtil.DividerSeparatorPaintable {
        private final int myLeft;
        private final int myRight;

        public MyPaintable(int left, int right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerSeparatorPaintable.Handler handler2) {
            if (handler2 == null) {
                MyPaintable.$$$reportNull$$$0(0);
            }
            block0: for (FoldedBlock[] block : FoldingModelSupport.this.myFoldings) {
                for (FoldedBlock folding : block) {
                    int line2;
                    FoldRegion region1 = folding.getRegion(this.myLeft);
                    FoldRegion region2 = folding.getRegion(this.myRight);
                    if (region1 == null || !region1.isValid() || region1.isExpanded() || region2 == null || !region2.isValid() || region2.isExpanded()) continue;
                    int line1 = FoldingModelSupport.this.myEditors[this.myLeft].getDocument().getLineNumber(region1.getStartOffset());
                    if (handler2.process(line1, line2 = FoldingModelSupport.this.myEditors[this.myRight].getDocument().getLineNumber(region2.getStartOffset()))) continue block0;
                    return;
                }
            }
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                MyPaintable.$$$reportNull$$$0(1);
            }
            if (divider == null) {
                MyPaintable.$$$reportNull$$$0(2);
            }
            DiffDividerDrawUtil.paintSeparators(gg, divider.getWidth(), FoldingModelSupport.this.myEditors[this.myLeft], FoldingModelSupport.this.myEditors[this.myRight], this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFoldingListener
    implements FoldingListener {
        private final int myIndex;
        @NotNull
        Set<FoldRegion> myModifiedRegions = new HashSet<FoldRegion>();

        public MyFoldingListener(int index) {
            this.myIndex = index;
        }

        @Override
        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            if (region == null) {
                MyFoldingListener.$$$reportNull$$$0(0);
            }
            if (FoldingModelSupport.this.myDuringSynchronize) {
                return;
            }
            this.myModifiedRegions.add(region);
        }

        @Override
        public void onFoldProcessingEnd() {
            if (this.myModifiedRegions.isEmpty()) {
                return;
            }
            FoldingModelSupport.this.myDuringSynchronize = true;
            try {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    if (i == this.myIndex) continue;
                    int pairedIndex = i;
                    FoldingModelSupport.this.myEditors[pairedIndex].getFoldingModel().runBatchFoldingOperation(() -> {
                        for (FoldedBlock folding : FoldingModelSupport.this.getFoldedBlocks()) {
                            FoldRegion pairedRegion;
                            FoldRegion region = folding.getRegion(this.myIndex);
                            if (region == null || !region.isValid() || !this.myModifiedRegions.contains(region) || (pairedRegion = folding.getRegion(pairedIndex)) == null || !pairedRegion.isValid()) continue;
                            pairedRegion.setExpanded(region.isExpanded());
                        }
                    });
                }
                this.myModifiedRegions.clear();
            }
            finally {
                FoldingModelSupport.this.myDuringSynchronize = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$MyFoldingListener", "onFoldRegionStateChange"));
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(DocumentEvent e) {
            if (StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1 || StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') != -1) {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    if (FoldingModelSupport.this.myEditors[i].getDocument() != e.getDocument()) continue;
                    ((FoldingModelSupport)FoldingModelSupport.this).myShouldUpdateLineNumbers[i] = true;
                }
            }
        }
    }

    private class FoldingBuilder {
        @NotNull
        private final Settings mySettings;
        @NotNull
        private final ExpandSuggester myExpandSuggester;
        @NotNull
        private final int[] myLineCount;

        public FoldingBuilder(@NotNull UserDataHolder context, Settings settings) {
            if (settings == null) {
                FoldingBuilder.$$$reportNull$$$0(0);
            }
            FoldingCache cache = context != null ? (FoldingCache)context.getUserData(CACHE_KEY) : null;
            this.myExpandSuggester = new ExpandSuggester(cache, settings.defaultExpanded);
            this.mySettings = settings;
            this.myLineCount = new int[FoldingModelSupport.this.myCount];
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                this.myLineCount[i] = DiffUtil.getLineCount(FoldingModelSupport.this.myEditors[i].getDocument());
            }
        }

        private void build(@NotNull Iterator<int[]> changedLines) {
            int i;
            if (changedLines == null) {
                FoldingBuilder.$$$reportNull$$$0(1);
            }
            int[] starts = new int[FoldingModelSupport.this.myCount];
            int[] ends = new int[FoldingModelSupport.this.myCount];
            int[] last = new int[FoldingModelSupport.this.myCount];
            for (i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                last[i] = Integer.MIN_VALUE;
            }
            while (changedLines.hasNext()) {
                int[] offsets = changedLines.next();
                for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                    starts[i2] = last[i2];
                    ends[i2] = offsets[i2 * 2];
                    last[i2] = offsets[i2 * 2 + 1];
                }
                this.addRange(starts, ends);
            }
            for (i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                starts[i] = last[i];
                ends[i] = Integer.MAX_VALUE;
            }
            this.addRange(starts, ends);
        }

        private void addRange(int[] starts, int[] ends) {
            int shift;
            ArrayList result2 = new ArrayList(3);
            int[] rangeStarts = new int[FoldingModelSupport.this.myCount];
            int[] rangeEnds = new int[FoldingModelSupport.this.myCount];
            int number = 0;
            while ((shift = FoldingModelSupport.getRangeShift(this.mySettings.range, number)) != -1) {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    rangeStarts[i] = DiffUtil.bound(starts[i] + shift, 0, this.myLineCount[i]);
                    rangeEnds[i] = DiffUtil.bound(ends[i] - shift, 0, this.myLineCount[i]);
                }
                ContainerUtil.addAllNotNull(result2, (Object[])new FoldedBlock[]{this.createRange(rangeStarts, rangeEnds, this.myExpandSuggester.isExpanded(rangeStarts, rangeEnds))});
                ++number;
            }
            if (result2.size() > 0) {
                FoldedBlock[] block;
                for (FoldedBlock folding : block = (FoldedBlock[])ArrayUtil.toObjectArray(result2, FoldedBlock.class)) {
                    folding.installHighlighter(block);
                }
                FoldingModelSupport.this.myFoldings.add(block);
            }
        }

        @Nullable
        private FoldedBlock createRange(int[] starts, int[] ends, boolean expanded) {
            boolean hasFolding = false;
            FoldRegion[] regions = new FoldRegion[FoldingModelSupport.this.myCount];
            boolean hasExpanded = false;
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                if (ends[i] - starts[i] < 2) continue;
                regions[i] = FoldingModelSupport.addFolding(FoldingModelSupport.this.myEditors[i], starts[i], ends[i], expanded);
                hasFolding |= regions[i] != null;
                hasExpanded |= regions[i] != null && regions[i].isExpanded();
            }
            if (hasExpanded && !expanded) {
                for (FoldRegion region : regions) {
                    if (region == null) continue;
                    region.setExpanded(true);
                }
            }
            return hasFolding ? new FoldedBlock(regions) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changedLines";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "build";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

