/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.StringSetSpinAllocator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class BaseExecuteBeforeRunDialog<T extends BeforeRunTask>
extends DialogWrapper {
    private final Project myProject;
    private DefaultMutableTreeNode myRoot;

    public BaseExecuteBeforeRunDialog(Project project) {
        super(project, true);
        this.myProject = project;
    }

    protected void init() {
        super.init();
        this.setTitle(ExecutionBundle.message((String)"execute.before.run.debug.dialog.title", (Object[])new Object[]{this.getTargetDisplayString()}));
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myRoot = this.buildNodes();
        final Tree tree = new Tree((TreeNode)this.myRoot);
        final MyTreeCellRenderer cellRenderer = new MyTreeCellRenderer();
        tree.setCellRenderer((TreeCellRenderer)cellRenderer);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setLineStyleAngled();
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    Rectangle rowBounds = tree.getRowBounds(row);
                    cellRenderer.setBounds(rowBounds);
                    Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                    checkBounds.setLocation(rowBounds.getLocation());
                    if (checkBounds.contains(e.getPoint())) {
                        BaseExecuteBeforeRunDialog.toggleNode((JTree)tree, (DefaultMutableTreeNode)tree.getPathForRow(row).getLastPathComponent());
                        e.consume();
                        tree.setSelectionRow(row);
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath treePath = tree.getLeadSelectionPath();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    BaseExecuteBeforeRunDialog.toggleNode((JTree)tree, node);
                    e.consume();
                }
            }
        });
        BaseExecuteBeforeRunDialog.expacndChecked(tree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        panel2.add((Component)scrollPane, "Center");
        return panel2;
    }

    private static void expacndChecked(Tree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        Enumeration<? extends TreeNode> factories = root.children();
        ArrayList<TreeNode[]> toExpand = new ArrayList<TreeNode[]>();
        block0: while (factories.hasMoreElements()) {
            DefaultMutableTreeNode factoryNode = (DefaultMutableTreeNode)factories.nextElement();
            Enumeration<TreeNode> enumeration = factoryNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                ConfigurationDescriptor config = (ConfigurationDescriptor)node.getUserObject();
                if (!config.isChecked()) continue;
                toExpand.add(factoryNode.getPath());
                continue block0;
            }
        }
        for (Object[] objectArray : toExpand) {
            tree.expandPath(new TreePath(objectArray));
        }
    }

    private static void toggleNode(JTree tree, DefaultMutableTreeNode node) {
        Descriptor descriptor;
        descriptor.setChecked(!(descriptor = (Descriptor)node.getUserObject()).isChecked());
        tree.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultMutableTreeNode buildNodes() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new Descriptor());
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (ConfigurationType type : runManager.getConfigurationFactories()) {
            Icon icon = type.getIcon();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(new ConfigurationTypeDescriptor(type, icon, this.isConfigurationAssigned(type)));
            root.add(typeNode);
            Set addedNames = StringSetSpinAllocator.alloc();
            try {
                List configurations = runManager.getConfigurationsList(type);
                for (RunConfiguration configuration : configurations) {
                    String configurationName = configuration.getName();
                    if (addedNames.contains(configurationName)) continue;
                    addedNames.add(configurationName);
                    typeNode.add(new DefaultMutableTreeNode(new ConfigurationDescriptor(configuration, this.isConfigurationAssigned(configuration))));
                }
            }
            finally {
                StringSetSpinAllocator.dispose((Set)addedNames);
            }
        }
        return root;
    }

    private boolean isConfigurationAssigned(ConfigurationType type) {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (ConfigurationFactory factory : type.getConfigurationFactories()) {
            RunnerAndConfigurationSettingsImpl settings = ((RunManagerImpl)runManager).getConfigurationTemplate(factory);
            if (!this.isConfigurationAssigned(settings.getConfiguration())) continue;
            return true;
        }
        return false;
    }

    private boolean isConfigurationAssigned(RunConfiguration configuration) {
        for (BeforeRunTask task : RunManagerEx.getInstanceEx(this.myProject).getBeforeRunTasks(configuration, this.getTaskID())) {
            if (!this.isRunning(task)) continue;
            return true;
        }
        return false;
    }

    protected void doOKAction() {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        Enumeration<TreeNode> nodes = this.myRoot.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Descriptor descriptor = (Descriptor)node.getUserObject();
            boolean isChecked = descriptor.isChecked();
            if (descriptor instanceof ConfigurationTypeDescriptor) {
                ConfigurationTypeDescriptor typeDesc = (ConfigurationTypeDescriptor)descriptor;
                for (ConfigurationFactory factory : typeDesc.getConfigurationType().getConfigurationFactories()) {
                    RunnerAndConfigurationSettingsImpl settings = runManager.getConfigurationTemplate(factory);
                    this.update(settings.getConfiguration(), isChecked, runManager);
                }
                continue;
            }
            if (!(descriptor instanceof ConfigurationDescriptor)) continue;
            ConfigurationDescriptor configDesc = (ConfigurationDescriptor)descriptor;
            this.update(configDesc.getConfiguration(), isChecked, runManager);
        }
        RunManagerImpl.getInstanceImpl(this.myProject).fireBeforeRunTasksUpdated();
        this.close(0);
    }

    protected abstract String getTargetDisplayString();

    protected abstract Key<T> getTaskID();

    protected abstract boolean isRunning(T var1);

    private void update(RunConfiguration config, boolean enabled, RunManagerImpl runManager) {
        List<BeforeRunTask<?>> tasks = runManager.getBeforeRunTasks(config);
        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myProject, this.getTaskID());
        if (provider == null) {
            return;
        }
        BeforeRunTask task = provider.createTask(config);
        this.update(task);
        task.setEnabled(true);
        if (enabled) {
            if (!tasks.contains(task)) {
                tasks = new ArrayList(tasks);
                tasks.add(task);
            }
        } else if (tasks.contains(task)) {
            tasks = new ArrayList(tasks);
            tasks.remove(task);
        }
        runManager.setBeforeRunTasks(config, (List<? extends BeforeRunTask<?>>)tasks, false);
    }

    protected abstract void update(T var1);

    protected abstract void clear(T var1);

    private static final class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final JLabel myLabel;
        public final JCheckBox myCheckbox = new JCheckBox();

        public MyTreeCellRenderer() {
            super(new BorderLayout());
            this.myLabel = new JLabel();
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myLabel, "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Descriptor descriptor = (Descriptor)node.getUserObject();
            this.myCheckbox.setSelected(descriptor.isChecked());
            this.myCheckbox.setBackground(UIUtil.getTreeTextBackground());
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground());
            Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
            this.setForeground(foreground);
            this.myCheckbox.setForeground(foreground);
            this.myLabel.setForeground(foreground);
            this.myCheckbox.setEnabled(true);
            if (descriptor instanceof ConfigurationTypeDescriptor) {
                ConfigurationTypeDescriptor configurationTypeDescriptor = (ConfigurationTypeDescriptor)descriptor;
                this.myLabel.setFont(tree.getFont());
                this.myLabel.setText(configurationTypeDescriptor.getConfigurationType().getDisplayName());
                this.myLabel.setIcon(configurationTypeDescriptor.getIcon());
            } else if (descriptor instanceof ConfigurationDescriptor) {
                ConfigurationDescriptor configurationTypeDescriptor = (ConfigurationDescriptor)descriptor;
                this.myLabel.setFont(tree.getFont());
                this.myLabel.setText(configurationTypeDescriptor.getName());
                this.myLabel.setIcon(null);
                if (((ConfigurationTypeDescriptor)((DefaultMutableTreeNode)node.getParent()).getUserObject()).isChecked()) {
                    Color foregrnd = tree.getForeground();
                    Color backgrnd = tree.getBackground();
                    if (foregrnd == null) {
                        foregrnd = Color.black;
                    }
                    if (backgrnd == null) {
                        backgrnd = Color.white;
                    }
                    int red = (foregrnd.getRed() + backgrnd.getRed()) / 2;
                    int green = (foregrnd.getGreen() + backgrnd.getGreen()) / 2;
                    int blue = (foregrnd.getBlue() + backgrnd.getBlue()) / 2;
                    Color halftone = new Color(red, green, blue);
                    this.setForeground(halftone);
                    this.myCheckbox.setForeground(halftone);
                    this.myLabel.setForeground(halftone);
                    this.myCheckbox.setEnabled(false);
                }
            }
            return this;
        }
    }

    private static final class ConfigurationDescriptor
    extends Descriptor {
        private final RunConfiguration myConfiguration;

        public ConfigurationDescriptor(RunConfiguration configuration, boolean isChecked) {
            this.myConfiguration = configuration;
            this.setChecked(isChecked);
        }

        public ConfigurationType getConfigurationFactory() {
            return this.myConfiguration.getType();
        }

        public String getName() {
            return this.myConfiguration.getName();
        }

        public RunConfiguration getConfiguration() {
            return this.myConfiguration;
        }
    }

    private static final class ConfigurationTypeDescriptor
    extends Descriptor {
        private final ConfigurationType myConfigurationType;
        private final Icon myIcon;

        public ConfigurationTypeDescriptor(ConfigurationType type, Icon icon, boolean isChecked) {
            this.myConfigurationType = type;
            this.myIcon = icon;
            this.setChecked(isChecked);
        }

        public ConfigurationType getConfigurationType() {
            return this.myConfigurationType;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static class Descriptor {
        private boolean myChecked;

        private Descriptor() {
        }

        public final boolean isChecked() {
            return this.myChecked;
        }

        public final void setChecked(boolean checked) {
            this.myChecked = checked;
        }
    }
}

