/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistributionLegacy
extends WSLDistribution {
    public static final WSLDistributionLegacy LEGACY_WSL = new WSLDistributionLegacy();
    private static final String WSL_ROOT_CHUNK = "\\lxss\\rootfs";
    private static final AtomicNullableLazyValue<String> WSL_ROOT_IN_WINDOWS_PROVIDER = AtomicNullableLazyValue.createValue(() -> {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : localAppDataPath + WSL_ROOT_CHUNK;
    });

    private WSLDistributionLegacy() {
        super("UBUNTU_LEGACY", "ubuntu_bash", "bash.exe", "Ubuntu (Legacy)");
    }

    @Override
    @Nullable
    protected Path getExecutableRootPath() {
        String windir = System.getenv().get("windir");
        return StringUtil.isEmpty((String)windir) ? null : Paths.get(windir, "System32");
    }

    @Override
    @NotNull
    protected String getRunCommandLineParameter() {
        if ("-c" == null) {
            WSLDistributionLegacy.$$$reportNull$$$0(0);
        }
        return "-c";
    }

    @Override
    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        String wslRootInHost;
        if (windowsPath == null) {
            WSLDistributionLegacy.$$$reportNull$$$0(1);
        }
        if ((wslRootInHost = (String)WSL_ROOT_IN_WINDOWS_PROVIDER.getValue()) == null) {
            return null;
        }
        if (FileUtil.isAncestor((String)wslRootInHost, (String)windowsPath, (boolean)true)) {
            return FileUtil.toSystemIndependentName((String)windowsPath.substring(wslRootInHost.length()));
        }
        return super.getWslPath(windowsPath);
    }

    @Override
    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath;
        if (wslPath == null) {
            WSLDistributionLegacy.$$$reportNull$$$0(2);
        }
        if ((windowsPath = super.getWindowsPath(wslPath)) != null) {
            return windowsPath;
        }
        String wslRootInHost = (String)WSL_ROOT_IN_WINDOWS_PROVIDER.getValue();
        if (wslRootInHost == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(wslRootInHost + wslPath));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLDistributionLegacy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunCommandLineParameter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLDistributionLegacy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getWslPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

