/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetFinderImpl
extends FacetFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetFinderImpl");
    private final Map<FacetTypeId, AllFacetsOfTypeModificationTracker> myAllFacetTrackers = new HashMap<FacetTypeId, AllFacetsOfTypeModificationTracker>();
    private final Map<FacetTypeId, CachedValue<Map<VirtualFile, List<Facet>>>> myCachedMaps = new HashMap<FacetTypeId, CachedValue<Map<VirtualFile, List<Facet>>>>();
    private final Project myProject;
    private final CachedValuesManager myCachedValuesManager;
    private final ModuleManager myModuleManager;

    public FacetFinderImpl(Project project) {
        this.myProject = project;
        this.myCachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
    }

    public <F extends Facet> ModificationTracker getAllFacetsOfTypeModificationTracker(FacetTypeId<F> type) {
        AllFacetsOfTypeModificationTracker<F> tracker = this.myAllFacetTrackers.get(type);
        if (tracker == null) {
            tracker = new AllFacetsOfTypeModificationTracker<F>(this.myProject, type);
            Disposer.register((Disposable)this.myProject, tracker);
            this.myAllFacetTrackers.put(type, tracker);
        }
        return tracker;
    }

    private <F extends Facet> Map<VirtualFile, List<Facet>> getRootToFacetsMap(FacetTypeId<F> type) {
        Map value;
        CachedValue cachedValue = this.myCachedMaps.get(type);
        if (cachedValue == null) {
            cachedValue = this.myCachedValuesManager.createCachedValue(() -> {
                Map<VirtualFile, List<Facet>> map = this.computeRootToFacetsMap(type);
                return CachedValueProvider.Result.create(map, (Object[])new Object[]{this.getAllFacetsOfTypeModificationTracker(type)});
            }, false);
            this.myCachedMaps.put(type, (CachedValue<Map<VirtualFile, List<Facet>>>)cachedValue);
        }
        LOG.assertTrue((value = (Map)cachedValue.getValue()) != null);
        return value;
    }

    @NotNull
    private <F extends Facet> Map<VirtualFile, List<Facet>> computeRootToFacetsMap(FacetTypeId<F> type) {
        Module[] modules = this.myModuleManager.getModules();
        HashMap<VirtualFile, List<Facet>> map = new HashMap<VirtualFile, List<Facet>>();
        for (Module module : modules) {
            Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(type);
            for (Facet facet : facets) {
                for (VirtualFile root : ((FacetRootsProvider)facet).getFacetRoots()) {
                    SmartList list2 = map.get(root);
                    if (list2 == null) {
                        list2 = new SmartList();
                        map.put(root, (List<Facet>)list2);
                    }
                    list2.add((Facet)facet);
                }
            }
        }
        HashMap<VirtualFile, List<Facet>> hashMap = map;
        if (hashMap == null) {
            FacetFinderImpl.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @Nullable
    public <F extends Facet> F findFacet(VirtualFile file2, FacetTypeId<F> type) {
        Collection list2 = this.findFacets(file2, (FacetTypeId)type);
        return (F)(list2.size() > 0 ? (Facet)list2.get(0) : null);
    }

    @NotNull
    public <F extends Facet> List<F> findFacets(VirtualFile file2, FacetTypeId<F> type) {
        Map<VirtualFile, List<Facet>> map = this.getRootToFacetsMap(type);
        if (!map.isEmpty()) {
            while (file2 != null) {
                List<Facet> list2 = map.get(file2);
                if (list2 != null) {
                    List<Facet> list3 = list2;
                    if (list3 == null) {
                        FacetFinderImpl.$$$reportNull$$$0(1);
                    }
                    return list3;
                }
                file2 = file2.getParent();
            }
        }
        List list4 = Collections.emptyList();
        if (list4 == null) {
            FacetFinderImpl.$$$reportNull$$$0(2);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/facet/impl/FacetFinderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootToFacetsMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findFacets";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AllFacetsOfTypeModificationTracker<F extends Facet>
    extends SimpleModificationTracker
    implements Disposable,
    ProjectWideFacetListener<F> {
        public AllFacetsOfTypeModificationTracker(Project project, FacetTypeId<F> type) {
            ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener(type, (ProjectWideFacetListener)this, (Disposable)this);
        }

        public void facetAdded(F facet) {
            this.incModificationCount();
        }

        public void facetRemoved(F facet) {
            this.incModificationCount();
        }

        public void facetConfigurationChanged(F facet) {
            this.incModificationCount();
        }

        public void firstFacetAdded() {
        }

        public void beforeFacetRemoved(F facet) {
        }

        public void allFacetsRemoved() {
        }

        public void dispose() {
        }
    }
}

