/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.ValidateHistoryAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ExceptionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/history/integration/ValidateHistoryAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.lvcs.impl"})
public final class ValidateHistoryAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        presentation.setEnabledAndVisible(application.isInternal());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        new Task.Modal(e, e.getProject(), "Checking local history storage", true){
            final /* synthetic */ AnActionEvent $e;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                long t = System.currentTimeMillis();
                try {
                    LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.getInstanceImpl();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localHistoryImpl), (String)"LocalHistoryImpl.getInstanceImpl()");
                    LocalHistoryFacade localHistoryFacade = localHistoryImpl.getFacade();
                    if (localHistoryFacade != null) {
                        localHistoryFacade.accept(new ChangeVisitor(this, indicator, t){
                            private int count;
                            final /* synthetic */ actionPerformed.1 this$0;
                            final /* synthetic */ ProgressIndicator $indicator;
                            final /* synthetic */ long $t;

                            public void end(@NotNull ChangeSet c) {
                                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                                this.$indicator.checkCanceled();
                                actionPerformed.run.1 v0 = this;
                                ++v0.count;
                                if (v0.count % 10 == 0) {
                                    this.$indicator.setText("" + this.count + " records checked");
                                }
                            }

                            public void finished() {
                                String message = "Local history storage seems to be OK (checked " + this.count + " records in " + (System.currentTimeMillis() - this.$t) + " ms)";
                                ApplicationManager.getApplication().invokeLater(new Runnable(this, message){
                                    final /* synthetic */ actionPerformed.run.1 this$0;
                                    final /* synthetic */ String $message;

                                    public final void run() {
                                        Messages.showInfoMessage((Project)this.this$0.this$0.$e.getProject(), (String)this.$message, (String)"Local History Validation");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$message = string;
                                    }
                                });
                            }
                            {
                                this.this$0 = $outer;
                                this.$indicator = $captured_local_variable$1;
                                this.$t = $captured_local_variable$2;
                            }
                        });
                    }
                }
                catch (ProcessCanceledException ex) {
                    throw (Throwable)ex;
                }
                catch (Exception ex) {
                    Messages.showErrorDialog((Project)this.$e.getProject(), (String)ExceptionUtil.getThrowableText((Throwable)ex), (String)"Local History Validation Error");
                }
            }
            {
                this.$e = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }.queue();
    }
}

