/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class IdePopupManager
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.IdePopupManager");
    private final List<IdePopupEventDispatcher> myDispatchStack = ContainerUtil.createLockFreeCopyOnWriteList();

    boolean isPopupActive() {
        for (IdePopupEventDispatcher each : this.myDispatchStack) {
            if (each.getComponent() != null && each.getComponent().isShowing()) continue;
            this.myDispatchStack.remove(each);
        }
        return this.myDispatchStack.size() > 0;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (e == null) {
            IdePopupManager.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(this.isPopupActive());
        if (e.getID() == 208 || e.getID() == 206) {
            IdeFrameEx ultimateParentWindowForEvent;
            if (!this.isPopupActive()) {
                return false;
            }
            boolean shouldCloseAllPopup = false;
            Window focused = ((WindowEvent)e).getOppositeWindow();
            if (focused == null) {
                focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            }
            Component ultimateParentForFocusedComponent = UIUtil.findUltimateParent((Component)focused);
            Window sourceWindow = ((WindowEvent)e).getWindow();
            Component ultimateParentForEventWindow = UIUtil.findUltimateParent((Component)sourceWindow);
            if (ultimateParentForEventWindow == null || ultimateParentForFocusedComponent == null) {
                shouldCloseAllPopup = true;
            }
            if (!shouldCloseAllPopup && ultimateParentForEventWindow instanceof IdeFrameEx && (ultimateParentWindowForEvent = (IdeFrameEx)((Object)ultimateParentForEventWindow)).isInFullScreen() && !ultimateParentForFocusedComponent.equals(ultimateParentForEventWindow)) {
                shouldCloseAllPopup = true;
            }
            if (shouldCloseAllPopup) {
                this.closeAllPopups();
            }
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent) {
            for (int i = this.myDispatchStack.size() - 1; i >= 0 && i < this.myDispatchStack.size(); --i) {
                boolean dispatched = this.myDispatchStack.get(i).dispatch(e);
                if (!dispatched) continue;
                return true;
            }
        }
        return false;
    }

    public void push(IdePopupEventDispatcher dispatcher) {
        if (!this.myDispatchStack.contains(dispatcher)) {
            this.myDispatchStack.add(dispatcher);
        }
    }

    public void remove(IdePopupEventDispatcher dispatcher) {
        this.myDispatchStack.remove(dispatcher);
    }

    public boolean closeAllPopups(boolean forceRestoreFocus) {
        return this.closeAllPopups(forceRestoreFocus, null);
    }

    private boolean closeAllPopups(boolean forceRestoreFocus, Window window) {
        if (this.myDispatchStack.size() == 0) {
            return false;
        }
        boolean closed = true;
        for (IdePopupEventDispatcher each : this.myDispatchStack) {
            if (window != null && !(window instanceof Frame) && window == UIUtil.getWindow((Component)each.getComponent())) continue;
            if (forceRestoreFocus) {
                each.setRestoreFocusSilentely();
            }
            closed &= each.close();
        }
        return closed;
    }

    public boolean closeAllPopups() {
        return this.closeAllPopups(true);
    }

    public boolean requestDefaultFocus(boolean forced) {
        if (!this.isPopupActive()) {
            return false;
        }
        return this.myDispatchStack.get(this.myDispatchStack.size() - 1).requestFocus();
    }

    public boolean isPopupWindow(Window w) {
        return this.myDispatchStack.stream().flatMap(IdePopupEventDispatcher::getPopupStream).map(JBPopup::getContent).filter(Objects::nonNull).anyMatch(jbPopupContent -> SwingUtilities.getWindowAncestor(jbPopupContent) == w);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdePopupManager", "dispatch"));
    }
}

