/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.internal.statistic.collectors.legacy.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizeIDEWizardDialog
extends DialogWrapper
implements ActionListener {
    private static final String BUTTONS = "BUTTONS";
    private static final String NO_BUTTONS = "NO_BUTTONS";
    private final JButton mySkipButton;
    private final JButton myBackButton;
    private final JButton myNextButton;
    private final JBCardLayout myCardLayout;
    private final List<AbstractCustomizeWizardStep> mySteps;
    private int myIndex;
    private final JBLabel myNavigationLabel;
    private final JBLabel myHeaderLabel;
    private final JBLabel myFooterLabel;
    private final CardLayout myButtonWrapperLayout;
    private final JPanel myButtonWrapper;
    private JPanel myContentPanel;

    public CustomizeIDEWizardDialog(@NotNull CustomizeIDEWizardStepsProvider stepsProvider) {
        if (stepsProvider == null) {
            CustomizeIDEWizardDialog.$$$reportNull$$$0(0);
        }
        super(null, true, true);
        this.mySkipButton = new JButton("Skip Remaining and Set Defaults");
        this.myBackButton = new JButton("Back");
        this.myNextButton = new JButton("Next");
        this.myCardLayout = new JBCardLayout();
        this.mySteps = new ArrayList<AbstractCustomizeWizardStep>();
        this.myIndex = 0;
        this.myNavigationLabel = new JBLabel();
        this.myHeaderLabel = new JBLabel();
        this.myFooterLabel = new JBLabel();
        this.myButtonWrapperLayout = new CardLayout();
        this.myButtonWrapper = new JPanel(this.myButtonWrapperLayout);
        this.setTitle("Customize " + ApplicationNamesInfo.getInstance().getFullProductName());
        this.getPeer().setAppIcons();
        stepsProvider.initSteps(this, this.mySteps);
        CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
        if (configProvider != null) {
            this.myIndex = configProvider.initSteps(this.mySteps);
        }
        if (this.mySteps.isEmpty()) {
            throw new IllegalArgumentException(stepsProvider + " provided no steps");
        }
        this.mySkipButton.addActionListener(this);
        this.myBackButton.addActionListener(this);
        this.myNextButton.addActionListener(this);
        AbstractCustomizeWizardStep.applyHeaderFooterStyle(this.myNavigationLabel);
        AbstractCustomizeWizardStep.applyHeaderFooterStyle(this.myHeaderLabel);
        AbstractCustomizeWizardStep.applyHeaderFooterStyle(this.myFooterLabel);
        this.init();
        this.initCurrentStep(true);
        this.setSize(400, 300);
        System.setProperty("StartupWizardMode", "true");
    }

    protected void dispose() {
        System.clearProperty("StartupWizardMode");
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel result2 = new JPanel(new BorderLayout(5, 5));
        this.myContentPanel = new JPanel((LayoutManager)this.myCardLayout);
        for (AbstractCustomizeWizardStep step : this.mySteps) {
            this.myContentPanel.add((Component)step, step.getTitle());
        }
        JPanel topPanel = new JPanel(new BorderLayout(5, 5));
        topPanel.add((Component)this.myNavigationLabel, "North");
        topPanel.add((Component)this.myHeaderLabel, "Center");
        result2.add((Component)topPanel, "North");
        result2.add((Component)this.myContentPanel, "Center");
        result2.add((Component)this.myFooterLabel, "South");
        result2.setPreferredSize((Dimension)JBUI.size((int)700, (int)600));
        result2.setBorder(AbstractCustomizeWizardStep.createSmallEmptyBorder());
        return result2;
    }

    protected JComponent createSouthPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 5;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        buttonPanel.add((Component)this.mySkipButton, gbc);
        ++gbc.gridx;
        buttonPanel.add((Component)this.myBackButton, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)this.myNextButton, gbc);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.myButtonWrapper.add((Component)buttonPanel, BUTTONS);
        this.myButtonWrapper.add((Component)new JLabel(), NO_BUTTONS);
        this.myButtonWrapperLayout.show(this.myButtonWrapper, BUTTONS);
        return this.myButtonWrapper;
    }

    void setButtonsVisible(boolean visible) {
        this.myButtonWrapperLayout.show(this.myButtonWrapper, visible ? BUTTONS : NO_BUTTONS);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        if (e == null) {
            CustomizeIDEWizardDialog.$$$reportNull$$$0(1);
        }
        if (e.getSource() == this.mySkipButton) {
            this.doOKAction();
            return;
        }
        if (e.getSource() == this.myBackButton) {
            --this.myIndex;
            this.initCurrentStep(false);
            return;
        }
        if (e.getSource() == this.myNextButton) {
            if (this.myIndex >= this.mySteps.size() - 1) {
                this.doOKAction();
                return;
            }
            ++this.myIndex;
            this.initCurrentStep(true);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return null;
    }

    public void doCancelAction() {
        this.doOKAction();
    }

    protected void doOKAction() {
        for (AbstractCustomizeWizardStep step : this.mySteps) {
            if (step.beforeOkAction()) continue;
            int index = this.mySteps.indexOf(step);
            if (this.myIndex != index) {
                this.myIndex = index;
                this.initCurrentStep(true);
            }
            return;
        }
        IdeInitialConfigButtonUsages.setSkipRemainingPressedScreen(this.mySteps.get(this.myIndex).getClass().getName());
        super.doOKAction();
    }

    private void initCurrentStep(boolean forward) {
        AbstractCustomizeWizardStep myCurrentStep = this.mySteps.get(this.myIndex);
        myCurrentStep.beforeShown(forward);
        this.myCardLayout.swipe((Container)this.myContentPanel, myCurrentStep.getTitle(), JBCardLayout.SwipeDirection.AUTO, () -> {
            Component component = myCurrentStep.getDefaultFocusedComponent();
            if (component != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
            }
        });
        this.myBackButton.setVisible(this.myIndex > 0);
        if (this.myIndex > 0) {
            this.myBackButton.setText("Back to " + this.mySteps.get(this.myIndex - 1).getTitle());
        }
        this.myNextButton.setText(this.myIndex < this.mySteps.size() - 1 ? "Next: " + this.mySteps.get(this.myIndex + 1).getTitle() : "Start using " + ApplicationNamesInfo.getInstance().getFullProductName());
        this.myHeaderLabel.setText(CustomizeIDEWizardDialog.ensureHTML(myCurrentStep.getHTMLHeader()));
        this.myFooterLabel.setText(CustomizeIDEWizardDialog.ensureHTML(myCurrentStep.getHTMLFooter()));
        StringBuilder navHTML = new StringBuilder("<html><body>");
        String arrow = this.myNavigationLabel.getFont().canDisplay(8594) ? "&#8594;" : "&gt;";
        for (int i = 0; i < this.mySteps.size(); ++i) {
            if (i > 0) {
                navHTML.append("&nbsp;").append(arrow).append("&nbsp;");
            }
            if (i == this.myIndex) {
                navHTML.append("<b>");
            }
            navHTML.append(this.mySteps.get(i).getTitle());
            if (i != this.myIndex) continue;
            navHTML.append("</b>");
        }
        this.myNavigationLabel.setText(navHTML.toString());
    }

    @Contract(value="!null->!null")
    private static String ensureHTML(@Nullable String s) {
        return s == null ? null : (s.startsWith("<html>") ? s : "<html>" + StringUtil.escapeXml((String)s) + "</html>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/customize/CustomizeIDEWizardDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

