/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeUtil {
    @NotNull
    public static FavoritesTreeNodeDescriptor[] getSelectedNodeDescriptors(DnDAwareTree tree) {
        TreePath[] path = tree.getSelectionPaths();
        if (path == null) {
            if (FavoritesTreeNodeDescriptor.EMPTY_ARRAY == null) {
                FavoritesTreeUtil.$$$reportNull$$$0(0);
            }
            return FavoritesTreeNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<FavoritesTreeNodeDescriptor> result2 = new ArrayList<FavoritesTreeNodeDescriptor>();
        for (TreePath treePath : path) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor)) continue;
            FavoritesTreeNodeDescriptor treeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
            result2.add(treeNodeDescriptor);
        }
        FavoritesTreeNodeDescriptor[] favoritesTreeNodeDescriptorArray = result2.toArray(FavoritesTreeNodeDescriptor.EMPTY_ARRAY);
        if (favoritesTreeNodeDescriptorArray == null) {
            FavoritesTreeUtil.$$$reportNull$$$0(1);
        }
        return favoritesTreeNodeDescriptorArray;
    }

    public static List<AbstractTreeNode> getLogicalPathToSelected(Tree tree) {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        TreePath selectionPath = tree.getSelectionPath();
        return FavoritesTreeUtil.getLogicalPathTo(result2, selectionPath);
    }

    public static List<Integer> getLogicalIndexPathTo(TreePath selectionPath) {
        Object uo;
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        Object component = selectionPath.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoritesTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode.getIndex());
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    public static List<AbstractTreeNode> getLogicalPathTo(List<AbstractTreeNode> result2, TreePath selectionPath) {
        Object uo;
        Object component = selectionPath.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoritesTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode);
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static FavoritesListNode extractParentList(FavoritesTreeNodeDescriptor descriptor) {
        AbstractTreeNode node;
        for (AbstractTreeNode current = node = descriptor.getElement(); current != null; current = current.getParent()) {
            if (!(current instanceof FavoritesListNode)) continue;
            return (FavoritesListNode)current;
        }
        return null;
    }

    static FavoritesListProvider getProvider(@NotNull FavoritesManager manager, @NotNull FavoritesTreeNodeDescriptor descriptor) {
        AbstractTreeNode treeNode;
        if (manager == null) {
            FavoritesTreeUtil.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            FavoritesTreeUtil.$$$reportNull$$$0(3);
        }
        for (treeNode = descriptor.getElement(); treeNode != null && !(treeNode instanceof FavoritesListNode); treeNode = treeNode.getParent()) {
        }
        if (treeNode != null) {
            String name = (String)((FavoritesListNode)treeNode).getValue();
            return manager.getListProvider(name);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodeDescriptors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

