/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.ConversionService;
import com.intellij.ide.impl.convert.ProjectFileVersion;
import com.intellij.ide.impl.convert.ProjectFileVersionState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFileVersion")
public class ProjectFileVersionImpl
extends ProjectFileVersion
implements ProjectComponent,
PersistentStateComponent<ProjectFileVersionState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.convert.ProjectFileVersionImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFileVersion";
    private final Project myProject;
    private final ProjectFileVersionState myState = new ProjectFileVersionState();

    public ProjectFileVersionImpl(Project project) {
        this.myProject = project;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            ProjectFileVersionImpl.$$$reportNull$$$0(0);
        }
        return COMPONENT_NAME;
    }

    public void disposeComponent() {
        String path;
        if (this.myProject.isDefault() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String string = path = ProjectKt.isDirectoryBased(this.myProject) ? this.myProject.getBasePath() : this.myProject.getProjectFilePath();
        if (path == null) {
            LOG.info("Cannot save conversion result: filePath == null");
        } else {
            ConversionService.getInstance().saveConversionResult(FileUtil.toSystemDependentName((String)path));
        }
    }

    public ProjectFileVersionState getState() {
        if (this.myState != null && !this.myState.getPerformedConversionIds().isEmpty()) {
            return this.myState;
        }
        return null;
    }

    public void loadState(@NotNull ProjectFileVersionState state) {
        if (state == null) {
            ProjectFileVersionImpl.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/convert/ProjectFileVersionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/convert/ProjectFileVersionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

