/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.FieldAccessor;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.IconsLoadTime");
    private static final boolean IS_INTERNAL_MODE = Boolean.valueOf(System.getProperty("idea.is.internal"));
    private static final int STATS_LIMIT = 10000;
    private static final int FIXED_SCOPE = 100;
    private static final List<Integer> statsSVG = IS_INTERNAL_MODE ? Collections.synchronizedList(new LinkedList()) : null;
    private static final List<Integer> statsPNG;

    public void actionPerformed(AnActionEvent e) {
        IconsLoadTime.log(false);
    }

    public static void log(boolean measureStartupLoad) {
        IconsLoadTime.log(measureStartupLoad, ImageLoader.ImageDesc.Type.PNG);
        IconsLoadTime.log(measureStartupLoad, ImageLoader.ImageDesc.Type.SVG);
    }

    private static void log(boolean measureStartupLoad, ImageLoader.ImageDesc.Type type) {
        StatData data = IconsLoadTime.getStatData(measureStartupLoad, type);
        if (data != null) {
            LOG.info(data.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StatData getStatData(boolean measureStartupLoad, ImageLoader.ImageDesc.Type type) {
        List<Integer> stats = IconsLoadTime.getStats(type);
        if (stats == null || stats.isEmpty()) {
            return null;
        }
        List<Integer> list2 = stats;
        synchronized (list2) {
            int size = stats.size();
            int sum = stats.stream().mapToInt(Integer::intValue).sum();
            int average = sum / size;
            int median = size % 2 == 0 ? stats.get(size / 2 - 1) + stats.get(size / 2) : stats.get(size / 2);
            return new StatData(type, measureStartupLoad, sum, average, median, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image measure(ImageLoader.LoadFunction func, ImageLoader.ImageDesc.Type type) throws IOException {
        List<Integer> stats = IconsLoadTime.getStats(type);
        boolean measure = stats.size() < 10000;
        long t = measure ? System.nanoTime() : 0L;
        Image img = func.load(null, null);
        if (measure) {
            int size;
            List<Integer> list2 = stats;
            synchronized (list2) {
                stats.add((int)(System.nanoTime() - t));
                size = stats.size();
            }
            if (size == 100) {
                IconsLoadTime.log(false, type);
            }
        }
        return img;
    }

    private static List<Integer> getStats(ImageLoader.ImageDesc.Type type) {
        return type == ImageLoader.ImageDesc.Type.SVG ? statsSVG : statsPNG;
    }

    static {
        List<Object> list2 = statsPNG = IS_INTERNAL_MODE ? Collections.synchronizedList(new LinkedList()) : null;
        if (IS_INTERNAL_MODE) {
            new FieldAccessor(ImageLoader.class, "measureLoad").set(null, (func, type) -> IconsLoadTime.measure(Objects.requireNonNull(func), Objects.requireNonNull(type)));
        }
    }

    public static class StartupLoadTime
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                StartupLoadTime.$$$reportNull$$$0(0);
            }
            if (IS_INTERNAL_MODE) {
                IconsLoadTime.log(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/IconsLoadTime$StartupLoadTime", "runActivity"));
        }
    }

    public static class StatData {
        public final ImageLoader.ImageDesc.Type type;
        public final boolean startup;
        public final int count;
        public final float totalTime;
        public final float averageTime;
        public final float medianTime;

        private StatData(ImageLoader.ImageDesc.Type type, boolean startup, int totalTime, int averageTime, int medianTime, int count) {
            this.type = type;
            this.startup = startup;
            this.count = count;
            this.totalTime = (float)totalTime / 1000000.0f;
            this.averageTime = (float)averageTime / 1000000.0f;
            this.medianTime = (float)medianTime / 1000000.0f;
        }

        public String toString() {
            return this.type + " load time: " + (this.startup ? "ide_startup=" : "total=") + String.format("%.02fms", Float.valueOf(this.totalTime)) + ", average=" + String.format("%.02fms", Float.valueOf(this.averageTime)) + ", median=" + String.format("%.02fms", Float.valueOf(this.medianTime)) + "; number of icons: " + this.count;
        }
    }
}

