/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.util.containers.hash.HashMap;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "intellij.platform.ide.impl"})
public final class LogEventJsonDeserializer
implements JsonDeserializer<LogEventAction> {
    @NotNull
    public LogEventAction deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject obj = json.getAsJsonObject();
        JsonElement jsonElement = obj.get("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj.get(\"id\")");
        String string = jsonElement.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.get(\"id\").asString");
        LogEventAction action = new LogEventAction(string);
        if (obj.has("data")) {
            JsonObject dataObj = obj.getAsJsonObject("data");
            Object object = context.deserialize((JsonElement)dataObj, new TypeToken<HashMap<String, Object>>(){}.getType());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"context.deserialize<Hash\u2026<String, Any>>() {}.type)");
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String key = (String)entry2.getKey();
                entry2 = entry;
                Object value = entry2.getValue();
                if (value instanceof Double && ((Number)value).doubleValue() % 1.0 == 0.0) {
                    int intValue = (int)Math.round(((Number)value).doubleValue());
                    String string2 = key;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                    action.addData(string2, intValue);
                    continue;
                }
                String string3 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"key");
                Object v = value;
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"value");
                action.addData(string3, v);
            }
        }
        return action;
    }
}

