/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventJsonDeserializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0001R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventSerializer;", "", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "fromString", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "line", "", "toString", "session", "intellij.platform.ide.impl"})
public final class LogEventSerializer {
    private static final Gson gson;
    public static final LogEventSerializer INSTANCE;

    @NotNull
    public final String toString(@NotNull Object session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        String string = gson.toJson(session2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(session)");
        return string;
    }

    @NotNull
    public final LogEvent fromString(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Object object = gson.fromJson(line, LogEvent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(line, LogEvent::class.java)");
        return (LogEvent)object;
    }

    private LogEventSerializer() {
    }

    static {
        LogEventSerializer logEventSerializer;
        INSTANCE = logEventSerializer = new LogEventSerializer();
        gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LogEventAction.class), (Object)new LogEventJsonDeserializer()).create();
    }
}

