/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.AppUIUtil;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class StatisticsNotificationManager {
    public static final String GROUP_DISPLAY_ID = "IDE Usage Statistics";

    private StatisticsNotificationManager() {
    }

    public static void showNotification(@NotNull StatisticsService statisticsService) {
        if (statisticsService == null) {
            StatisticsNotificationManager.$$$reportNull$$$0(0);
        }
        MyNotificationListener listener2 = new MyNotificationListener(statisticsService, UsageStatisticsPersistenceComponent.getInstance());
        Notifications.Bus.notify((Notification)statisticsService.createNotification(GROUP_DISPLAY_ID, listener2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statisticsService", "com/intellij/internal/statistic/updater/StatisticsNotificationManager", "showNotification"));
    }

    private static class MyNotificationListener
    implements NotificationListener {
        private final StatisticsService myStatisticsService;
        private final UsageStatisticsPersistenceComponent mySettings;

        public MyNotificationListener(@NotNull StatisticsService statisticsService, @NotNull UsageStatisticsPersistenceComponent settings) {
            if (statisticsService == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                MyNotificationListener.$$$reportNull$$$0(1);
            }
            this.myStatisticsService = statisticsService;
            this.mySettings = settings;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                MyNotificationListener.$$$reportNull$$$0(3);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if ("allow".equals(description)) {
                    this.mySettings.setAllowed(true);
                    this.mySettings.setShowNotification(false);
                    notification.expire();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> this.myStatisticsService.send());
                } else if ("decline".equals(description)) {
                    this.mySettings.setAllowed(false);
                    this.mySettings.setShowNotification(false);
                    notification.expire();
                } else if ("settings".equals(description)) {
                    Collection<Consent> result2 = AppUIUtil.confirmConsentOptions((Collection)ConsentOptions.getInstance().getConsents().first);
                    if (result2 != null) {
                        ConsentOptions.getInstance().setConsents(result2);
                    }
                    notification.expire();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statisticsService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/updater/StatisticsNotificationManager$MyNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

