/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.components.JBMenu;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.ui.plaf.gtk.GtkMenuUI;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.synth.SynthMenuUI;
import org.jetbrains.annotations.NotNull;

public final class ActionMenu
extends JBMenu {
    private final String myPlace;
    private DataContext myContext;
    private final ActionRef<ActionGroup> myGroup;
    private final PresentationFactory myPresentationFactory;
    private final Presentation myPresentation;
    private boolean myMnemonicEnabled;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private StubItem myStubItem;
    private final boolean myTopLevel;
    private Disposable myDisposable;
    private JPopupMenu mySpecialMenu;

    public ActionMenu(DataContext context, @NotNull String place, ActionGroup group, PresentationFactory presentationFactory, boolean enableMnemonics, boolean topLevel) {
        if (place == null) {
            ActionMenu.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myPlace = place;
        this.myGroup = ActionRef.fromAction(group);
        this.myPresentationFactory = presentationFactory;
        this.myPresentation = this.myPresentationFactory.getPresentation((AnAction)group);
        this.myMnemonicEnabled = enableMnemonics;
        this.myTopLevel = topLevel;
        this.updateUI();
        this.init();
        if (SystemInfo.isMacSystemMenu) {
            this.installSynchronizer();
        }
        if (UIUtil.isUnderIntelliJLaF()) {
            this.setOpaque(true);
        }
        this.getPopupMenu();
    }

    public void updateContext(DataContext context) {
        this.myContext = context;
    }

    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
            this.myGroup.getAction().addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
        }
    }

    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            this.myGroup.getAction().removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.mySpecialMenu == null) {
            this.mySpecialMenu = new JBPopupMenu();
            this.mySpecialMenu.setInvoker((Component)((Object)this));
            this.popupListener = this.createWinListener(this.mySpecialMenu);
            ReflectionUtil.setField(JMenu.class, (Object)((Object)this), JPopupMenu.class, (String)"popupMenu", (Object)this.mySpecialMenu);
        }
        return super.getPopupMenu();
    }

    public void updateUI() {
        boolean isAmbiance;
        boolean bl = isAmbiance = UIUtil.isUnderGTKLookAndFeel() && "Ambiance".equalsIgnoreCase(UIUtil.getGtkThemeName());
        if (this.myTopLevel && !isAmbiance && UIUtil.GTK_AMBIANCE_TEXT_COLOR.equals(this.getForeground())) {
            this.setForeground(null);
        }
        if (UIUtil.isStandardMenuLAF()) {
            super.updateUI();
        } else {
            this.setUI(IdeaMenuUI.createUI((JComponent)((Object)this)));
            this.setFont(UIUtil.getMenuFont());
            JPopupMenu popupMenu = this.getPopupMenu();
            if (popupMenu != null) {
                popupMenu.updateUI();
            }
        }
        if (this.myTopLevel && isAmbiance) {
            this.setForeground(UIUtil.GTK_AMBIANCE_TEXT_COLOR);
        }
        if (this.myTopLevel && UIUtil.isUnderGTKLookAndFeel()) {
            Insets insets = this.getInsets();
            Insets newInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
            if (insets.top + insets.bottom < JBUI.scale((int)6)) {
                newInsets.top = newInsets.bottom = JBUI.scale((int)3);
            }
            if (insets.left + insets.right < JBUI.scale((int)12)) {
                newInsets.left = newInsets.right = JBUI.scale((int)6);
            }
            if (!newInsets.equals(insets)) {
                this.setBorder(BorderFactory.createEmptyBorder(newInsets.top, newInsets.left, newInsets.bottom, newInsets.right));
            }
        }
    }

    public void setUI(MenuItemUI ui) {
        MenuItemUI newUi = !this.myTopLevel && UIUtil.isUnderGTKLookAndFeel() && ui instanceof SynthMenuUI ? new GtkMenuUI((SynthMenuUI)ui) : ui;
        super.setUI(newUi);
    }

    private void init() {
        boolean macSystemMenu = SystemInfo.isMacSystemMenu && this.myPlace.equals("MainMenu");
        this.myStubItem = macSystemMenu ? null : new StubItem();
        this.addStubItem();
        this.addMenuListener(new MenuListenerImpl());
        this.setBorderPainted(false);
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setText(this.myPresentation.getText());
        this.updateIcon();
        this.setMnemonicEnabled(this.myMnemonicEnabled);
    }

    private void addStubItem() {
        if (this.myStubItem != null) {
            this.add(this.myStubItem);
        }
    }

    public void setMnemonicEnabled(boolean enable) {
        this.myMnemonicEnabled = enable;
        this.setMnemonic(this.myPresentation.getMnemonic());
        this.setDisplayedMnemonicIndex(this.myPresentation.getDisplayedMnemonicIndex());
    }

    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.myMnemonicEnabled ? index : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.myMnemonicEnabled ? mnemonic : 0);
    }

    private void updateIcon() {
        UISettings settings = UISettings.getInstanceOrNull();
        if (settings != null && settings.getShowIconsInMenus()) {
            Presentation presentation = this.myPresentation;
            Icon icon = presentation.getIcon();
            if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace)) {
                icon = IconLoader.get1xIcon((Icon)icon);
            }
            this.setIcon(icon);
            if (presentation.getDisabledIcon() != null) {
                this.setDisabledIcon(presentation.getDisabledIcon());
            } else {
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            }
        }
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    public static void showDescriptionInStatusBar(boolean isIncluded, Component component, String description) {
        StatusBar statusBar;
        IdeFrame frame = (IdeFrame)(component instanceof IdeFrame ? component : SwingUtilities.getAncestorOfClass(IdeFrame.class, component));
        if (frame != null && (statusBar = frame.getStatusBar()) != null) {
            statusBar.setInfo(isIncluded ? description : null);
        }
    }

    private void clearItems() {
        if (SystemInfo.isMacSystemMenu && this.myPlace.equals("MainMenu")) {
            for (Component menuComponent : this.getMenuComponents()) {
                if (menuComponent instanceof ActionMenu) {
                    ((ActionMenu)((Object)menuComponent)).clearItems();
                    ((ActionMenu)((Object)menuComponent)).uninstallSynchronizer();
                    continue;
                }
                if (!(menuComponent instanceof ActionMenuItem) || SystemInfo.isMac) continue;
                ((ActionMenuItem)((Object)menuComponent)).setAccelerator(KeyStroke.getKeyStroke(61451, 0));
            }
        }
        this.removeAll();
        this.validate();
    }

    private void fillMenu() {
        boolean mayContextBeInvalid;
        DataContext context;
        if (this.myContext != null) {
            context = this.myContext;
            mayContextBeInvalid = false;
        } else {
            DataContext contextFromFocus = DataManager.getInstance().getDataContext();
            context = contextFromFocus;
            if (PlatformDataKeys.CONTEXT_COMPONENT.getData(context) == null) {
                IdeFrame frame = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)((Object)this));
                context = DataManager.getInstance().getDataContext(IdeFocusManager.getGlobalInstance().getLastFocusedFor(frame));
            }
            mayContextBeInvalid = true;
        }
        Utils.fillMenu(this.myGroup.getAction(), (JComponent)((Object)this), this.myMnemonicEnabled, this.myPresentationFactory, context, this.myPlace, true, mayContextBeInvalid, LaterInvocator.isInModalContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/ActionMenu", "<init>"));
    }

    private static class UsabilityHelper
    implements IdeEventQueue.EventDispatcher,
    AWTEventListener,
    Disposable {
        private Component myComponent;
        private Point myLastMousePoint;
        private Point myUpperTargetPoint;
        private Point myLowerTargetPoint;
        private SingleAlarm myCallbackAlarm = new SingleAlarm(() -> {
            Disposer.dispose((Disposable)this.myCallbackAlarm);
            this.myCallbackAlarm = null;
            if (this.myEventToRedispatch != null) {
                IdeEventQueue.getInstance().dispatchEvent(this.myEventToRedispatch);
            }
        }, 50, ModalityState.any(), (Disposable)this);
        private MouseEvent myEventToRedispatch;
        private long myLastEventTime = 0L;
        private boolean myInBounds = false;
        private SingleAlarm myCheckAlarm = new SingleAlarm(() -> {
            if (this.myLastEventTime > 0L && System.currentTimeMillis() - this.myLastEventTime > 1500L && !this.myInBounds && this.myCallbackAlarm != null && !this.myCallbackAlarm.isDisposed()) {
                this.myCallbackAlarm.request();
            }
            this.myCheckAlarm.request();
        }, 100, ModalityState.any(), (Disposable)this);

        private UsabilityHelper(Component component) {
            this.myComponent = component;
            PointerInfo info = MouseInfo.getPointerInfo();
            Point point = this.myLastMousePoint = info != null ? info.getLocation() : null;
            if (this.myLastMousePoint != null) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 1L);
                IdeEventQueue.getInstance().addDispatcher(this, this);
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ComponentEvent componentEvent;
            Component component;
            JPopupMenu popup2;
            if (event instanceof ComponentEvent && (popup2 = (JPopupMenu)UIUtil.getParentOfType(JPopupMenu.class, (Component)(component = (componentEvent = (ComponentEvent)event).getComponent()))) != null && popup2.getInvoker() == this.myComponent && popup2.isShowing()) {
                Rectangle bounds = popup2.getBounds();
                if (bounds.isEmpty()) {
                    return;
                }
                bounds.setLocation(popup2.getLocationOnScreen());
                if (this.myLastMousePoint.x < bounds.x) {
                    this.myUpperTargetPoint = new Point(bounds.x, bounds.y);
                    this.myLowerTargetPoint = new Point(bounds.x, bounds.y + bounds.height);
                }
                if (this.myLastMousePoint.x > bounds.x + bounds.width) {
                    this.myUpperTargetPoint = new Point(bounds.x + bounds.width, bounds.y);
                    this.myLowerTargetPoint = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
                }
            }
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                UsabilityHelper.$$$reportNull$$$0(0);
            }
            if (e instanceof MouseEvent && this.myUpperTargetPoint != null && this.myLowerTargetPoint != null && this.myCallbackAlarm != null) {
                if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
                    return false;
                }
                Point point = ((MouseEvent)e).getLocationOnScreen();
                Rectangle bounds = this.myComponent.getBounds();
                bounds.setLocation(this.myComponent.getLocationOnScreen());
                this.myInBounds = bounds.contains(point);
                boolean isMouseMovingTowardsSubmenu = this.myInBounds || new Polygon(new int[]{this.myLastMousePoint.x, this.myUpperTargetPoint.x, this.myLowerTargetPoint.x}, new int[]{this.myLastMousePoint.y, this.myUpperTargetPoint.y, this.myLowerTargetPoint.y}, 3).contains(point);
                this.myEventToRedispatch = (MouseEvent)e;
                this.myLastEventTime = System.currentTimeMillis();
                if (!isMouseMovingTowardsSubmenu) {
                    this.myCallbackAlarm.request();
                } else {
                    this.myCallbackAlarm.cancel();
                }
                this.myLastMousePoint = point;
                return true;
            }
            return false;
        }

        public void dispose() {
            this.myComponent = null;
            this.myEventToRedispatch = null;
            this.myLowerTargetPoint = null;
            this.myUpperTargetPoint = null;
            this.myLastMousePoint = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionMenu$UsabilityHelper", "dispatch"));
        }
    }

    private class MenuItemSynchronizer
    implements PropertyChangeListener {
        private MenuItemSynchronizer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("visible".equals(name)) {
                ActionMenu.this.setVisible(ActionMenu.this.myPresentation.isVisible());
                if (SystemInfo.isMacSystemMenu && ActionMenu.this.myPlace.equals("MainMenu")) {
                    ActionMenu.this.validateTree();
                }
            } else if ("enabled".equals(name)) {
                ActionMenu.this.setEnabled(ActionMenu.this.myPresentation.isEnabled());
            } else if ("mnemonicKey".equals(name)) {
                ActionMenu.this.setMnemonic(ActionMenu.this.myPresentation.getMnemonic());
            } else if ("mnemonicIndex".equals(name)) {
                ActionMenu.this.setDisplayedMnemonicIndex(ActionMenu.this.myPresentation.getDisplayedMnemonicIndex());
            } else if ("text".equals(name)) {
                ActionMenu.this.setText(ActionMenu.this.myPresentation.getText());
            } else if ("icon".equals(name) || "disabledIcon".equals(name)) {
                ActionMenu.this.updateIcon();
            }
        }
    }

    private class MenuListenerImpl
    implements MenuListener {
        private MenuListenerImpl() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            ActionMenu.this.clearItems();
            ActionMenu.this.addStubItem();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            if (ActionMenu.this.myDisposable != null) {
                Disposer.dispose((Disposable)ActionMenu.this.myDisposable);
                ActionMenu.this.myDisposable = null;
            }
            ActionMenu.this.clearItems();
            ActionMenu.this.addStubItem();
        }

        @Override
        public void menuSelected(MenuEvent e) {
            UsabilityHelper helper = new UsabilityHelper((Component)((Object)ActionMenu.this));
            if (ActionMenu.this.myDisposable == null) {
                ActionMenu.this.myDisposable = Disposer.newDisposable();
            }
            Disposer.register((Disposable)ActionMenu.this.myDisposable, (Disposable)helper);
            ActionMenu.this.fillMenu();
        }
    }
}

