/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.Alarm;
import java.util.HashMap;

public class Rediffers {
    private final HashMap<EditorSource, Rediff> myRediffers = new HashMap();
    private final DiffPanelImpl myPanel;
    private final Alarm myAlarm = new Alarm();
    private final Runnable myUpdateRequest = new Runnable(){

        @Override
        public void run() {
            if (Rediffers.this.myDisposed) {
                return;
            }
            Rediffers.this.updateNow();
        }
    };
    private boolean myDisposed = false;

    public Rediffers(DiffPanelImpl panel2) {
        this.myPanel = panel2;
    }

    public void dispose() {
        for (Rediff rediff : this.myRediffers.values()) {
            rediff.stopListen();
        }
        this.myRediffers.clear();
        this.myAlarm.cancelAllRequests();
        this.myDisposed = true;
    }

    public void contentRemoved(EditorSource source) {
        Rediff rediff = this.myRediffers.remove(source);
        if (rediff != null) {
            rediff.stopListen();
        }
    }

    public void contentAdded(final EditorSource source) {
        EditorEx editor = source.getEditor();
        Rediff rediff = new Rediff(editor.getDocument());
        this.myRediffers.put(source, rediff);
        rediff.startListen();
        source.addDisposable(new Disposable(){

            public void dispose() {
                Rediffers.this.contentRemoved(source);
            }
        });
    }

    public void updateNow() {
        this.myPanel.rediff();
        this.myAlarm.cancelAllRequests();
    }

    private void requestRediff() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this.myUpdateRequest, 300);
    }

    private class Rediff
    implements DocumentListener,
    Disposable {
        private final Document myDocument;
        private boolean myLinstening = false;

        public Rediff(Document document) {
            this.myDocument = document;
        }

        public void documentChanged(DocumentEvent event) {
            if (event.getOldLength() != event.getNewLength()) {
                Rediffers.this.myPanel.invalidateDiff();
            }
            Rediffers.this.requestRediff();
        }

        public void stopListen() {
            if (this.myLinstening) {
                this.myDocument.removeDocumentListener((DocumentListener)this);
            }
            this.myLinstening = false;
        }

        public void startListen() {
            if (!this.myLinstening) {
                this.myDocument.addDocumentListener((DocumentListener)this);
            }
            this.myLinstening = true;
        }

        public void dispose() {
            this.stopListen();
        }
    }
}

