/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffAction;
import com.intellij.util.containers.JBIterable;

public class SynchronizeDiff
extends DirDiffAction {
    private final boolean mySelectedOnly;

    public SynchronizeDiff(DirDiffTableModel model, boolean selectedOnly) {
        super(model);
        this.mySelectedOnly = selectedOnly;
        ActionUtil.copyFrom((AnAction)this, (String)(selectedOnly ? "DirDiffMenu.SynchronizeDiff" : "DirDiffMenu.SynchronizeDiff.All"));
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (!e.getPresentation().isEnabled()) {
            return;
        }
        boolean enabled = e.getData(CommonDataKeys.EDITOR) == null;
        e.getPresentation().setEnabled(enabled &= !JBIterable.from(this.mySelectedOnly ? this.getModel().getSelectedElements() : this.getModel().getElements()).filter(d -> d.getOperation() == DirDiffOperation.COPY_FROM || d.getOperation() == DirDiffOperation.COPY_TO || d.getOperation() == DirDiffOperation.DELETE).filter(d -> d.getSource() == null || d.getSource().isOperationsEnabled()).filter(d -> d.getTarget() == null || d.getTarget().isOperationsEnabled()).isEmpty());
    }

    @Override
    protected void updateState(boolean state) {
        if (this.mySelectedOnly) {
            this.getModel().synchronizeSelected();
        } else {
            this.getModel().synchronizeAll();
        }
    }

    public boolean isSelected(AnActionEvent e) {
        return false;
    }

    @Override
    protected boolean isReloadNeeded() {
        return false;
    }
}

