/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisualLineFragmentsIterator
implements Iterator<Fragment> {
    private EditorView myView;
    private Document myDocument;
    private FoldRegion[] myRegions;
    private Fragment myFragment;
    private int myVisualLineStartOffset;
    private Runnable myQuickEvaluationListener;
    private int mySegmentStartOffset;
    private int mySegmentEndOffset;
    private int myCurrentFoldRegionIndex;
    private Iterator<LineLayout.VisualFragment> myFragmentIterator;
    private List<Inlay> myInlays;
    private int myCurrentInlayIndex;
    private float myCurrentX;
    private int myCurrentVisualColumn;
    private LineLayout.VisualFragment myDelegate;
    private FoldRegion myFoldRegion;
    private int myCurrentStartLogicalLine;
    private int myCurrentEndLogicalLine;
    private int myNextWrapOffset;

    @NotNull
    static Iterable<Fragment> create(@NotNull EditorView view, int offset, boolean beforeSoftWrap) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(0);
        }
        Iterable<Fragment> iterable = VisualLineFragmentsIterator.create(view, offset, beforeSoftWrap, false);
        if (iterable == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(1);
        }
        return iterable;
    }

    @NotNull
    static Iterable<Fragment> create(@NotNull EditorView view, int offset, boolean beforeSoftWrap, boolean align) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(2);
        }
        Iterable<Fragment> iterable = () -> {
            if (view == null) {
                VisualLineFragmentsIterator.$$$reportNull$$$0(11);
            }
            return new VisualLineFragmentsIterator(view, offset, beforeSoftWrap, align);
        };
        if (iterable == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @NotNull
    static Iterable<Fragment> create(@NotNull EditorView view, @NotNull VisualLinesIterator visualLinesIterator, @Nullable Runnable quickEvaluationListener, boolean align) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(4);
        }
        if (visualLinesIterator == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(5);
        }
        Iterable<Fragment> iterable = () -> {
            if (view == null) {
                VisualLineFragmentsIterator.$$$reportNull$$$0(9);
            }
            if (visualLinesIterator == null) {
                VisualLineFragmentsIterator.$$$reportNull$$$0(10);
            }
            return new VisualLineFragmentsIterator(view, visualLinesIterator, quickEvaluationListener, align);
        };
        if (iterable == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(6);
        }
        return iterable;
    }

    private VisualLineFragmentsIterator(EditorView view, int offset, boolean beforeSoftWrap, boolean align) {
        SoftWrap currentOrPrevWrap;
        this.myFragment = new Fragment();
        EditorImpl editor = view.getEditor();
        int visualLineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = softWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2;
        } else if (beforeSoftWrap) {
            --currentOrPrevWrapIndex;
        }
        SoftWrap softWrap = currentOrPrevWrap = currentOrPrevWrapIndex < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > visualLineStartOffset) {
            visualLineStartOffset = currentOrPrevWrap.getStart();
        }
        int nextFoldingIndex = editor.getFoldingModel().getLastCollapsedRegionBefore(visualLineStartOffset) + 1;
        this.init(view, align ? editor.offsetToVisualPosition((int)offset).line : -1, visualLineStartOffset, editor.getDocument().getLineNumber(visualLineStartOffset), currentOrPrevWrapIndex, nextFoldingIndex, null, align);
    }

    private VisualLineFragmentsIterator(@NotNull EditorView view, @NotNull VisualLinesIterator visualLinesIterator, @Nullable Runnable quickEvaluationListener, boolean align) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(7);
        }
        if (visualLinesIterator == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(8);
        }
        this.myFragment = new Fragment();
        assert (!visualLinesIterator.atEnd());
        this.init(view, visualLinesIterator.getVisualLine(), visualLinesIterator.getVisualLineStartOffset(), visualLinesIterator.getStartLogicalLine(), visualLinesIterator.getStartOrPrevWrapIndex(), visualLinesIterator.getStartFoldingIndex(), quickEvaluationListener, align);
    }

    private void init(EditorView view, int visualLine, int startOffset, int startLogicalLine, int currentOrPrevWrapIndex, int nextFoldingIndex, @Nullable Runnable quickEvaluationListener, boolean align) {
        this.myQuickEvaluationListener = quickEvaluationListener;
        this.myView = view;
        EditorImpl editor = view.getEditor();
        if (align && visualLine != -1 && editor.isRightAligned()) {
            this.myFragment = new RightAlignedFragment(view.getRightAlignmentLineStartX(visualLine) - (float)this.myView.getInsets().left);
        }
        this.myDocument = editor.getDocument();
        FoldingModelImpl foldingModel = editor.getFoldingModel();
        FoldRegion[] regions = foldingModel.fetchTopLevel();
        this.myRegions = regions == null ? FoldRegion.EMPTY_ARRAY : regions;
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        SoftWrap currentOrPrevWrap = currentOrPrevWrapIndex < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        SoftWrap followingWrap = currentOrPrevWrapIndex + 1 < 0 || currentOrPrevWrapIndex + 1 >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex + 1);
        this.myVisualLineStartOffset = this.mySegmentStartOffset = startOffset;
        this.myCurrentFoldRegionIndex = nextFoldingIndex;
        this.myCurrentEndLogicalLine = startLogicalLine;
        this.myCurrentX = this.myView.getInsets().left;
        if (this.mySegmentStartOffset == 0) {
            this.myCurrentX += this.myView.getPrefixTextWidthInPixels();
        } else if (currentOrPrevWrap != null && this.mySegmentStartOffset == currentOrPrevWrap.getStart()) {
            this.myCurrentX += (float)currentOrPrevWrap.getIndentInPixels();
            this.myCurrentVisualColumn = currentOrPrevWrap.getIndentInColumns();
        }
        this.myNextWrapOffset = followingWrap == null ? Integer.MAX_VALUE : followingWrap.getStart();
        this.setInlaysAndFragmentIterator();
    }

    private void setInlaysAndFragmentIterator() {
        this.mySegmentEndOffset = this.getCurrentFoldRegionStartOffset();
        assert (this.mySegmentEndOffset >= this.mySegmentStartOffset);
        if (this.mySegmentEndOffset > this.mySegmentStartOffset) {
            this.mySegmentEndOffset = Math.min(this.myNextWrapOffset, Math.min(this.mySegmentEndOffset, this.myDocument.getLineEndOffset(this.myCurrentEndLogicalLine)));
            boolean normalLineEnd = this.mySegmentEndOffset < this.getCurrentFoldRegionStartOffset() && this.mySegmentEndOffset < this.myNextWrapOffset;
            this.myInlays = this.myView.getEditor().getInlayModel().getInlineElementsInRange(this.mySegmentStartOffset, this.mySegmentEndOffset - (normalLineEnd ? 0 : 1));
            if (this.myInlays.isEmpty() || this.myInlays.get(0).getOffset() > this.mySegmentStartOffset) {
                this.setFragmentIterator();
            }
        }
    }

    private void setFragmentIterator() {
        int startOffset = this.myCurrentInlayIndex > 0 ? this.myInlays.get(this.myCurrentInlayIndex - 1).getOffset() : this.mySegmentStartOffset;
        int endOffset = this.myCurrentInlayIndex < this.myInlays.size() ? this.myInlays.get(this.myCurrentInlayIndex).getOffset() : this.mySegmentEndOffset;
        int lineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentEndLogicalLine);
        this.myFragmentIterator = this.myView.getTextLayoutCache().getLineLayout(this.myCurrentEndLogicalLine).getFragmentsInVisualOrder(this.myView, this.myCurrentEndLogicalLine, this.myCurrentX, this.myCurrentVisualColumn, startOffset - lineStartOffset, endOffset - lineStartOffset, this.myQuickEvaluationListener);
    }

    private int getCurrentFoldRegionStartOffset() {
        if (this.myCurrentFoldRegionIndex >= this.myRegions.length) {
            return Integer.MAX_VALUE;
        }
        int nextFoldingOffset = this.myRegions[this.myCurrentFoldRegionIndex].getStartOffset();
        return nextFoldingOffset < this.myNextWrapOffset ? nextFoldingOffset : Integer.MAX_VALUE;
    }

    private float getFoldRegionWidthInPixels(FoldRegion foldRegion) {
        return this.myView.getFoldRegionLayout(foldRegion).getWidth();
    }

    private int getFoldRegionWidthInColumns(FoldRegion foldRegion) {
        int maxVisualColumn = 0;
        for (LineLayout.VisualFragment fragment : this.myView.getFoldRegionLayout(foldRegion).getFragmentsInVisualOrder(0.0f)) {
            maxVisualColumn = fragment.getEndVisualColumn();
        }
        return maxVisualColumn;
    }

    private int[] getVisualColumnForXInsideFoldRegion(FoldRegion foldRegion, float x) {
        LineLayout layout = this.myView.getFoldRegionLayout(foldRegion);
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(0.0f)) {
            if (!(x <= fragment.getEndX())) continue;
            return fragment.xToVisualColumn(x);
        }
        return new int[]{this.getFoldRegionWidthInColumns(foldRegion), 1};
    }

    private float getXForVisualColumnInsideFoldRegion(FoldRegion foldRegion, int column) {
        LineLayout layout = this.myView.getFoldRegionLayout(foldRegion);
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(0.0f)) {
            if (column > fragment.getEndVisualColumn()) continue;
            return fragment.visualColumnToX(column);
        }
        return this.getFoldRegionWidthInPixels(foldRegion);
    }

    private float getXForOffsetInsideFoldRegion(FoldRegion foldRegion, int offset) {
        return offset < foldRegion.getEndOffset() ? 0.0f : this.getFoldRegionWidthInPixels(foldRegion);
    }

    @Override
    public boolean hasNext() {
        return this.mySegmentStartOffset == this.getCurrentFoldRegionStartOffset() || this.myFragmentIterator == null || this.myFragmentIterator.hasNext();
    }

    @Override
    public Fragment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.mySegmentStartOffset == this.getCurrentFoldRegionStartOffset()) {
            this.myDelegate = null;
            this.myFoldRegion = this.myRegions[this.myCurrentFoldRegionIndex];
            assert (this.myFoldRegion.isValid());
            this.mySegmentStartOffset = this.myFoldRegion.getEndOffset();
            this.myCurrentX += this.getFoldRegionWidthInPixels(this.myFoldRegion);
            this.myCurrentVisualColumn += this.getFoldRegionWidthInColumns(this.myFoldRegion);
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            this.myCurrentEndLogicalLine = this.myDocument.getLineNumber(this.mySegmentStartOffset);
            ++this.myCurrentFoldRegionIndex;
            this.myFragmentIterator = null;
            this.myCurrentInlayIndex = 0;
            this.setInlaysAndFragmentIterator();
        } else if (this.myFragmentIterator == null) {
            this.myDelegate = null;
            this.myFoldRegion = null;
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            Inlay inlay = this.myInlays.get(this.myCurrentInlayIndex);
            this.myCurrentX += (float)inlay.getWidthInPixels();
            ++this.myCurrentVisualColumn;
            ++this.myCurrentInlayIndex;
            if (this.myCurrentInlayIndex >= this.myInlays.size() || this.myInlays.get(this.myCurrentInlayIndex).getOffset() > inlay.getOffset()) {
                this.setFragmentIterator();
            }
        } else {
            this.myDelegate = this.myFragmentIterator.next();
            this.myFoldRegion = null;
            this.myCurrentX = this.myDelegate.getEndX();
            this.myCurrentVisualColumn = this.myDelegate.getEndVisualColumn();
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            if (!this.myFragmentIterator.hasNext()) {
                if (this.myCurrentInlayIndex < this.myInlays.size()) {
                    this.myFragmentIterator = null;
                } else {
                    this.mySegmentStartOffset = this.mySegmentEndOffset;
                }
            }
        }
        return this.myFragment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/VisualLineFragmentsIterator";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualLinesIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/VisualLineFragmentsIterator";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$1";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class RightAlignedFragment
    extends Fragment {
        private final float xOffset;

        RightAlignedFragment(float offset) {
            this.xOffset = offset;
        }

        @Override
        float offsetToX(int offset) {
            return super.offsetToX(offset) + this.xOffset;
        }

        @Override
        float offsetToX(float startX, int startOffset, int offset) {
            return super.offsetToX(startX - this.xOffset, startOffset, offset) + this.xOffset;
        }

        @Override
        float getEndX() {
            return super.getEndX() + this.xOffset;
        }

        @Override
        float getStartX() {
            return super.getStartX() + this.xOffset;
        }

        @Override
        float visualColumnToX(int column) {
            return super.visualColumnToX(column) + this.xOffset;
        }

        @Override
        int[] xToVisualColumn(float x) {
            return super.xToVisualColumn(x - this.xOffset);
        }
    }

    class Fragment {
        Fragment() {
        }

        int getVisualLineStartOffset() {
            return VisualLineFragmentsIterator.this.myVisualLineStartOffset;
        }

        boolean isCollapsedFoldRegion() {
            return VisualLineFragmentsIterator.this.myFoldRegion != null;
        }

        int getMinLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getMinOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getMinLogicalColumn();
        }

        int getMaxLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getMaxOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getMaxLogicalColumn();
        }

        int getStartLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getStartOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getStartLogicalColumn();
        }

        int getEndLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getEndOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getEndLogicalColumn();
        }

        int getStartVisualColumn() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getStartVisualColumn() : VisualLineFragmentsIterator.this.myCurrentVisualColumn - (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.getFoldRegionWidthInColumns(VisualLineFragmentsIterator.this.myFoldRegion) : 1);
        }

        int getEndVisualColumn() {
            return VisualLineFragmentsIterator.this.myCurrentVisualColumn;
        }

        int getStartLogicalLine() {
            return VisualLineFragmentsIterator.this.myCurrentStartLogicalLine;
        }

        int getEndLogicalLine() {
            return VisualLineFragmentsIterator.this.myCurrentEndLogicalLine;
        }

        float getStartX() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getStartX() : VisualLineFragmentsIterator.this.myCurrentX - (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.getFoldRegionWidthInPixels(VisualLineFragmentsIterator.this.myFoldRegion) : (float)this.getCurrentInlay().getWidthInPixels());
        }

        float getEndX() {
            return VisualLineFragmentsIterator.this.myCurrentX;
        }

        int logicalToVisualColumn(int column) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.logicalToVisualColumn(column) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myCurrentVisualColumn - VisualLineFragmentsIterator.this.getFoldRegionWidthInColumns(VisualLineFragmentsIterator.this.myFoldRegion) : this.getEndVisualColumn());
        }

        int visualToLogicalColumn(int column) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.visualToLogicalColumn(column) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? (column == VisualLineFragmentsIterator.this.myCurrentVisualColumn ? this.getEndLogicalColumn() : this.getStartLogicalColumn()) : this.getEndLogicalColumn());
        }

        int[] xToVisualColumn(float x) {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.xToVisualColumn(x);
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int[] column = VisualLineFragmentsIterator.this.getVisualColumnForXInsideFoldRegion(VisualLineFragmentsIterator.this.myFoldRegion, x - this.getStartX());
                column[0] = column[0] + this.getStartVisualColumn();
                return column;
            }
            boolean closerToStart = x < (this.getStartX() + this.getEndX()) / 2.0f;
            return new int[]{VisualLineFragmentsIterator.this.myCurrentVisualColumn - (closerToStart ? 1 : 0), closerToStart ? 0 : 1};
        }

        float visualColumnToX(int column) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.visualColumnToX(column) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? this.getStartX() + VisualLineFragmentsIterator.this.getXForVisualColumnInsideFoldRegion(VisualLineFragmentsIterator.this.myFoldRegion, column - VisualLineFragmentsIterator.this.myCurrentVisualColumn + VisualLineFragmentsIterator.this.getFoldRegionWidthInColumns(VisualLineFragmentsIterator.this.myFoldRegion)) : (column == VisualLineFragmentsIterator.this.myCurrentVisualColumn ? this.getEndX() : this.getStartX()));
        }

        int getVisualLength() {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.getLength();
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int length = 0;
                for (LineLayout.VisualFragment fragment : VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion).getFragmentsInVisualOrder(0.0f)) {
                    length += fragment.getLength();
                }
                return length;
            }
            return 0;
        }

        int visualColumnToOffset(int relativeVisualColumn) {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.visualColumnToOffset(relativeVisualColumn);
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int relativeOffset = 0;
                for (LineLayout.VisualFragment fragment : VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion).getFragmentsInVisualOrder(0.0f)) {
                    if (relativeVisualColumn >= fragment.getStartVisualColumn() && relativeVisualColumn <= fragment.getEndVisualColumn()) {
                        return relativeOffset + fragment.visualColumnToOffset(relativeVisualColumn - fragment.getStartVisualColumn());
                    }
                    relativeOffset += fragment.getLength();
                }
            }
            return 0;
        }

        int getStartOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getStartOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getStartOffset() : this.getCurrentInlay().getOffset());
        }

        int getEndOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getEndOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getEndOffset() : this.getCurrentInlay().getOffset());
        }

        int getMinOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getMinOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getStartOffset() : this.getCurrentInlay().getOffset());
        }

        int getMaxOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getMaxOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getEndOffset() : this.getCurrentInlay().getOffset());
        }

        float offsetToX(int offset) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.offsetToX(offset - VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine)) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? this.getStartX() + VisualLineFragmentsIterator.this.getXForOffsetInsideFoldRegion(VisualLineFragmentsIterator.this.myFoldRegion, offset) : this.getEndX());
        }

        float offsetToX(float startX, int startOffset, int offset) {
            assert (VisualLineFragmentsIterator.this.myDelegate != null);
            int lineStartOffset = VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine);
            return VisualLineFragmentsIterator.this.myDelegate.offsetToX(startX, startOffset - lineStartOffset, offset - lineStartOffset);
        }

        boolean isRtl() {
            return VisualLineFragmentsIterator.this.myDelegate != null && VisualLineFragmentsIterator.this.myDelegate.isRtl();
        }

        FoldRegion getCurrentFoldRegion() {
            return VisualLineFragmentsIterator.this.myFoldRegion;
        }

        Inlay getCurrentInlay() {
            if (VisualLineFragmentsIterator.this.myDelegate != null || VisualLineFragmentsIterator.this.myFoldRegion != null) {
                return null;
            }
            return (Inlay)VisualLineFragmentsIterator.this.myInlays.get(VisualLineFragmentsIterator.this.myCurrentInlayIndex - 1);
        }

        void draw(Graphics2D g, float x, float y, int startRelativeOffset, int endRelativeOffset) {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                VisualLineFragmentsIterator.this.myDelegate.draw(g, x, y, startRelativeOffset, endRelativeOffset);
            } else if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int relativeOffset = 0;
                for (LineLayout.VisualFragment fragment : VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion).getFragmentsInVisualOrder(x)) {
                    int relativeOffsetEnd = relativeOffset + fragment.getLength();
                    if (relativeOffset < endRelativeOffset && relativeOffsetEnd > startRelativeOffset) {
                        fragment.draw(g, fragment.getStartX(), y, Math.max(0, startRelativeOffset - relativeOffset), Math.min(relativeOffsetEnd, endRelativeOffset) - relativeOffset);
                    }
                    relativeOffset = relativeOffsetEnd;
                }
            }
        }
    }
}

