/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.impl.FileComparator;
import com.intellij.openapi.fileChooser.impl.FileTreeBuilder;
import com.intellij.openapi.fileChooser.impl.FileTreeStructure;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.fileChooser.tree.FileRenderer;
import com.intellij.openapi.fileChooser.tree.FileTreeModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemTreeImpl
implements FileSystemTree {
    private final Tree myTree;
    private final FileTreeStructure myTreeStructure;
    private final AbstractTreeBuilder myTreeBuilder;
    private final Project myProject;
    private final ArrayList<Runnable> myOkActions = new ArrayList(2);
    private final FileChooserDescriptor myDescriptor;
    private final FileTreeModel myFileTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;
    private final List<FileSystemTree.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MyExpansionListener myExpansionListener = new MyExpansionListener();
    private final Set<VirtualFile> myEverExpanded = new THashSet();

    public FileSystemTreeImpl(@Nullable Project project, FileChooserDescriptor descriptor) {
        this(project, descriptor, new Tree(), null, null, null);
        this.myTree.setRootVisible(descriptor.isTreeRootVisible());
        this.myTree.setShowsRootHandles(true);
    }

    public FileSystemTreeImpl(@Nullable Project project, FileChooserDescriptor descriptor, Tree tree, @Nullable TreeCellRenderer renderer, @Nullable Runnable onInitialized, @Nullable Convertor<TreePath, String> speedSearchConverter) {
        this.myProject = project;
        if (renderer == null && Registry.is((String)"file.chooser.async.tree.model")) {
            renderer = new FileRenderer().forTree();
            this.myFileTreeModel = new FileTreeModel(descriptor, new FileRefresher(false, 3L, (NotNullProducer<ModalityState>)((NotNullProducer)() -> ModalityState.stateForComponent((Component)tree))));
            this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myFileTreeModel));
            this.myTreeStructure = null;
        } else {
            this.myFileTreeModel = null;
            this.myAsyncTreeModel = null;
            this.myTreeStructure = new FileTreeStructure(project, descriptor);
        }
        this.myDescriptor = descriptor;
        this.myTree = tree;
        if (this.myAsyncTreeModel != null) {
            this.myTree.setModel((TreeModel)((Object)this.myAsyncTreeModel));
            this.myTreeBuilder = null;
        } else {
            DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
            this.myTree.setModel((TreeModel)treeModel);
            this.myTree.addTreeExpansionListener((TreeExpansionListener)this.myExpansionListener);
            this.myTreeBuilder = this.createTreeBuilder((JTree)this.myTree, treeModel, this.myTreeStructure, FileComparator.getInstance(), descriptor, () -> {
                this.myTree.expandPath(new TreePath(treeModel.getRoot()));
                if (onInitialized != null) {
                    onInitialized.run();
                }
            });
            Disposer.register((Disposable)this.myTreeBuilder, (Disposable)new Disposable(){

                public void dispose() {
                    FileSystemTreeImpl.this.myTree.removeTreeExpansionListener((TreeExpansionListener)FileSystemTreeImpl.this.myExpansionListener);
                }
            });
            if (project != null) {
                Disposer.register((Disposable)project, (Disposable)this.myTreeBuilder);
            }
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileSystemTreeImpl.this.processSelectionChange();
            }
        });
        if (speedSearchConverter != null) {
            new TreeSpeedSearch(this.myTree, speedSearchConverter);
        } else {
            new TreeSpeedSearch((JTree)this.myTree);
        }
        this.myTree.setLineStyleAngled();
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(descriptor.isChooseMultiple() ? 4 : 1);
        this.registerTreeActions();
        if (renderer == null) {
            renderer = new NodeRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    String comment;
                    super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof FileNodeDescriptor && (comment = ((FileNodeDescriptor)((Object)userObject)).getComment()) != null) {
                        this.append(comment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            };
        }
        this.myTree.setCellRenderer(renderer);
    }

    protected AbstractTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator2, FileChooserDescriptor descriptor, @Nullable Runnable onInitialized) {
        return new FileTreeBuilder(tree, treeModel, treeStructure, comparator2, descriptor, onInitialized);
    }

    private void registerTreeActions() {
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSystemTreeImpl.this.performEnterAction(true);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                FileSystemTreeImpl.this.performEnterAction(false);
                return true;
            }
        }.installOn((Component)this.myTree);
    }

    private void performEnterAction(boolean toggleNodeState) {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            if (this.isLeaf(path)) {
                this.fireOkAction();
            } else if (toggleNodeState) {
                if (this.myTree.isExpanded(path)) {
                    this.myTree.collapsePath(path);
                } else {
                    this.myTree.expandPath(path);
                }
            }
        }
    }

    public void addOkAction(Runnable action) {
        this.myOkActions.add(action);
    }

    private void fireOkAction() {
        for (Runnable action : this.myOkActions) {
            action.run();
        }
    }

    public void registerMouseListener(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)this.myTree, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public boolean areHiddensShown() {
        if (this.myAsyncTreeModel != null) {
            return this.myDescriptor.isShowHiddenFiles();
        }
        return this.myTreeStructure.areHiddensShown();
    }

    public void showHiddens(boolean showHidden) {
        if (this.myAsyncTreeModel != null) {
            this.myDescriptor.withShowHiddenFiles(showHidden);
            if (this.myFileTreeModel != null) {
                this.myFileTreeModel.invalidate();
            }
        } else {
            this.myTreeStructure.showHiddens(showHidden);
        }
        this.updateTree();
    }

    public void updateTree() {
        if (this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    public void dispose() {
        if (this.myTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myTreeBuilder);
        }
        if (this.myAsyncTreeModel != null) {
            Disposer.dispose((Disposable)this.myAsyncTreeModel);
        }
        this.myEverExpanded.clear();
    }

    public AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public void select(VirtualFile file2, @Nullable Runnable onDone) {
        this.select(new VirtualFile[]{file2}, onDone);
    }

    public void select(VirtualFile[] file2, @Nullable Runnable onDone) {
        block8: {
            block7: {
                if (this.myAsyncTreeModel == null) break block7;
                switch (file2.length) {
                    case 0: {
                        this.myTree.clearSelection();
                        if (onDone != null) {
                            onDone.run();
                            break;
                        }
                        break block8;
                    }
                    case 1: {
                        this.myAsyncTreeModel.getTreePath(file2[0]).done(path -> {
                            this.myTree.setSelectionPath(path);
                            this.myTree.scrollPathToVisible(path);
                            if (onDone != null) {
                                onDone.run();
                            }
                        });
                        break;
                    }
                    default: {
                        this.myTree.clearSelection();
                        if (onDone != null) {
                            onDone.run();
                            break;
                        }
                        break block8;
                    }
                }
                break block8;
            }
            Object[] elements = new Object[file2.length];
            for (int i = 0; i < file2.length; ++i) {
                VirtualFile eachFile = file2[i];
                elements[i] = FileSystemTreeImpl.getFileElementFor(eachFile);
            }
            this.myTreeBuilder.select(elements, onDone);
        }
    }

    public void expand(VirtualFile file2, @Nullable Runnable onDone) {
        if (this.myAsyncTreeModel != null) {
            this.myAsyncTreeModel.getTreePath(file2).done(path -> {
                this.myTree.expandPath(path);
                if (onDone != null) {
                    onDone.run();
                }
            });
        } else {
            this.myTreeBuilder.expand((Object)FileSystemTreeImpl.getFileElementFor(file2), onDone);
        }
    }

    @Nullable
    private static FileElement getFileElementFor(@NotNull VirtualFile file2) {
        VirtualFile selectFile;
        if (file2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(0);
        }
        if (file2.getFileSystem() instanceof JarFileSystem && file2.getParent() == null) {
            selectFile = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (selectFile == null) {
                return null;
            }
        } else {
            selectFile = file2;
        }
        return new FileElement(selectFile, selectFile.getName());
    }

    public Exception createNewFolder(final VirtualFile parentDirectory, final String newFolderName) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtualFile parent = parentDirectory;
                            for (String name : StringUtil.tokenize((String)newFolderName, (String)"\\/")) {
                                VirtualFile folder = parent.createChildDirectory((Object)this, name);
                                FileSystemTreeImpl.this.updateTree();
                                FileSystemTreeImpl.this.select(folder, null);
                                parent = folder;
                            }
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message((String)"file.chooser.create.new.folder.command.name", (Object[])new Object[0]), null);
        return failReason[0];
    }

    public Exception createNewFile(final VirtualFile parentDirectory, final String newFileName, final FileType fileType, final String initialContent) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String newFileNameWithExtension = newFileName.endsWith('.' + fileType.getDefaultExtension()) ? newFileName : newFileName + '.' + fileType.getDefaultExtension();
                            VirtualFile file2 = parentDirectory.createChildData((Object)this, newFileNameWithExtension);
                            VfsUtil.saveText((VirtualFile)file2, (String)(initialContent != null ? initialContent : ""));
                            FileSystemTreeImpl.this.updateTree();
                            FileSystemTreeImpl.this.select(file2, null);
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message((String)"file.chooser.create.new.file.command.name", (Object[])new Object[0]), null);
        return failReason[0];
    }

    public JTree getTree() {
        return this.myTree;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return FileSystemTreeImpl.getVirtualFile(path);
    }

    @Nullable
    public VirtualFile getNewFileParent() {
        VirtualFile selected = this.getSelectedFile();
        if (selected != null) {
            return selected;
        }
        List roots = this.myDescriptor.getRoots();
        return roots.size() == 1 ? (VirtualFile)roots.get(0) : null;
    }

    public <T> T getData(DataKey<T> key) {
        return (T)this.myDescriptor.getUserData(key);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                FileSystemTreeImpl.$$$reportNull$$$0(1);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList files2 = ContainerUtil.newArrayList();
        for (TreePath path : paths) {
            VirtualFile file2 = FileSystemTreeImpl.getVirtualFile(path);
            if (file2 == null || !file2.isValid()) continue;
            files2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)files2);
        if (virtualFileArray == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    private boolean isLeaf(TreePath path) {
        Object component = path.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            return node.isLeaf();
        }
        return this.myAsyncTreeModel != null && this.myAsyncTreeModel.isLeaf(component);
    }

    static VirtualFile getVirtualFile(TreePath path) {
        Object node;
        Object userObject;
        Object component = path.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)(node = (DefaultMutableTreeNode)component)).getUserObject()) instanceof FileNodeDescriptor) {
            FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)userObject);
            return descriptor.getElement().getFile();
        }
        if (component instanceof FileNode) {
            node = (FileNode)component;
            return ((FileNode)node).getFile();
        }
        return null;
    }

    public boolean selectionExists() {
        TreePath[] selectedPaths = this.myTree.getSelectionPaths();
        return selectedPaths != null && selectedPaths.length != 0;
    }

    public boolean isUnderRoots(@NotNull VirtualFile file2) {
        List roots;
        if (file2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(3);
        }
        if ((roots = this.myDescriptor.getRoots()).size() == 0) {
            return true;
        }
        for (VirtualFile root : roots) {
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void addListener(final FileSystemTree.Listener listener2, Disposable parent) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FileSystemTreeImpl.this.myListeners.remove(listener2);
            }
        });
    }

    private void fireSelection(List<VirtualFile> selection) {
        for (FileSystemTree.Listener each : this.myListeners) {
            each.selectionChanged(selection);
        }
    }

    private void processSelectionChange() {
        if (this.myListeners.size() == 0) {
            return;
        }
        ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                VirtualFile file2 = FileSystemTreeImpl.getVirtualFile(each);
                if (file2 == null) continue;
                selection.add(file2);
            }
        }
        this.fireSelection(selection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileElementFor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            FileNodeDescriptor nodeDescriptor;
            FileElement fileDescriptor;
            VirtualFile virtualFile;
            if (FileSystemTreeImpl.this.myTreeBuilder == null || !FileSystemTreeImpl.this.myTreeBuilder.isNodeBeingBuilt(event.getPath())) {
                return;
            }
            TreePath path = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof FileNodeDescriptor && (virtualFile = (fileDescriptor = (nodeDescriptor = (FileNodeDescriptor)((Object)node.getUserObject())).getElement()).getFile()) != null) {
                if (!FileSystemTreeImpl.this.myEverExpanded.contains(virtualFile)) {
                    if (virtualFile instanceof NewVirtualFile) {
                        ((NewVirtualFile)virtualFile).markDirty();
                    }
                    FileSystemTreeImpl.this.myEverExpanded.add(virtualFile);
                }
                boolean async = FileSystemTreeImpl.this.myTreeBuilder.isToBuildChildrenInBackground((Object)virtualFile);
                if (virtualFile instanceof NewVirtualFile) {
                    RefreshQueue.getInstance().refresh(async, false, null, ModalityState.stateForComponent((Component)FileSystemTreeImpl.this.myTree), new VirtualFile[]{virtualFile});
                } else {
                    virtualFile.refresh(async, false);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

