/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.ui.tree.Identifiable;
import com.intellij.ui.tree.MapBasedTree;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class FileTreeModel
extends AbstractTreeModel
implements Identifiable,
Searchable,
InvokerSupplier {
    private final Invoker invoker;
    private final State state;
    private volatile List<Root> roots;

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor, FileRefresher refresher) {
        if (descriptor == null) {
            FileTreeModel.$$$reportNull$$$0(0);
        }
        this(descriptor, refresher, true, false);
    }

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor, FileRefresher refresher, boolean sortDirectories, boolean sortArchives) {
        if (descriptor == null) {
            FileTreeModel.$$$reportNull$$$0(1);
        }
        this.invoker = new Invoker.BackgroundThread((Disposable)this);
        if (refresher != null) {
            Disposer.register((Disposable)this, (Disposable)refresher);
        }
        this.state = new State(descriptor, refresher, sortDirectories, sortArchives);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTreeModel.this.invoker.invokeLaterIfNeeded(() -> {
                    if (events == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    FileTreeModel.this.process(events);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/openapi/fileChooser/tree/FileTreeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$after$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void invalidate() {
        this.invoker.invokeLaterIfNeeded(() -> {
            if (this.roots != null) {
                for (Root root : this.roots) {
                    root.tree.invalidate();
                }
            }
            this.treeStructureChanged(this.state.path, null, null);
        });
    }

    @Override
    public Object getUniqueID(@NotNull TreePath path) {
        if (path == null) {
            FileTreeModel.$$$reportNull$$$0(2);
        }
        Object object = path.getLastPathComponent();
        TreePath parent = path.getParentPath();
        return parent != null && object instanceof Node ? this.getUniqueID(parent, (Node)object, new ArrayDeque<String>()) : (parent != null || object != this.state ? null : this.state.toString());
    }

    private Object getUniqueID(TreePath path, Node node, ArrayDeque<String> deque) {
        deque.addFirst(node.getName());
        Object object = path.getLastPathComponent();
        TreePath parent = path.getParentPath();
        return parent != null && object instanceof Node ? this.getUniqueID(parent, (Node)object, deque) : (parent != null || object != this.state ? null : deque.toArray());
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        if (object == null) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                FileTreeModel.$$$reportNull$$$0(3);
            }
            return promise2;
        }
        if (object instanceof String && object.equals(this.state.toString())) {
            Promise promise3 = Promises.resolvedPromise((Object)this.state.path);
            if (promise3 == null) {
                FileTreeModel.$$$reportNull$$$0(4);
            }
            return promise3;
        }
        AsyncPromise promise4 = new AsyncPromise();
        this.invoker.invokeLaterIfNeeded(() -> {
            if (object instanceof Object[]) {
                this.resolveID((AsyncPromise<TreePath>)promise4, (Object[])object);
            } else if (object instanceof VirtualFile) {
                this.resolveFile((AsyncPromise<TreePath>)promise4, (VirtualFile)object);
            } else if (object instanceof String) {
                VirtualFile file2 = FileTreeModel.findFile((String)object);
                if (file2 != null) {
                    this.resolveFile((AsyncPromise<TreePath>)promise4, file2);
                } else {
                    promise4.setError("file not found");
                }
            } else {
                promise4.setError("unsupported object");
            }
        });
        AsyncPromise asyncPromise = promise4;
        if (asyncPromise == null) {
            FileTreeModel.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    private void resolveID(AsyncPromise<TreePath> promise2, Object[] array) {
        if (array.length > 0) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            for (Root root : this.roots) {
                MapBasedTree.Entry<Node> child = root.tree.getRootEntry();
                if (child == null || !Objects.equals(((Node)child.getNode()).getName(), array[0])) continue;
                this.resolveID(promise2, array, 1, root, child);
                return;
            }
            promise2.setError("root entry not found");
        } else {
            promise2.setResult((Object)this.state.path);
        }
    }

    private void resolveID(AsyncPromise<TreePath> promise2, Object[] array, int index, Root root, MapBasedTree.Entry<Node> entry) {
        if (index < array.length) {
            if (entry.isLoadingRequired()) {
                root.updateChildren(this.state, entry);
            }
            for (int i = 0; i < entry.getChildCount(); ++i) {
                MapBasedTree.Entry<Node> child = entry.getChildEntry(i);
                if (child == null || !Objects.equals(child.getNode().getName(), array[index])) continue;
                this.resolveID(promise2, array, index + 1, root, child);
                return;
            }
            promise2.setError("entry not found");
        } else {
            promise2.setResult(entry);
        }
    }

    private void resolveFile(AsyncPromise<TreePath> promise2, VirtualFile file2) {
        if (this.roots == null) {
            this.roots = this.state.getRoots();
        }
        for (Root root : this.roots) {
            if (!this.resolveFile(promise2, file2, root, root.tree.getRootEntry())) continue;
            return;
        }
        promise2.setError("root entry not found");
    }

    private boolean resolveFile(AsyncPromise<TreePath> promise2, VirtualFile file2, Root root, MapBasedTree.Entry<Node> entry) {
        if (entry != null) {
            if (entry.getNode().getFile().equals(file2)) {
                promise2.setResult(entry);
                return true;
            }
            if (VfsUtilCore.isAncestor((VirtualFile)entry.getNode().getFile(), (VirtualFile)file2, (boolean)true)) {
                if (entry.isLoadingRequired()) {
                    root.updateChildren(this.state, entry);
                }
                for (int i = 0; i < entry.getChildCount(); ++i) {
                    if (!this.resolveFile(promise2, file2, root, entry.getChildEntry(i))) continue;
                    return true;
                }
                promise2.setError("entry not found");
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            FileTreeModel.$$$reportNull$$$0(6);
        }
        return invoker;
    }

    public final Object getRoot() {
        return this.state;
    }

    public final Object getChild(Object object, int index) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            if (0 <= index && index < this.roots.size()) {
                return this.roots.get(index);
            }
        } else if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChild(index);
        }
        return null;
    }

    public final int getChildCount(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            return this.roots.size();
        }
        if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChildCount();
        }
        return 0;
    }

    public final boolean isLeaf(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object != this.state && object instanceof Node && (entry = this.getEntry((Node)object, false)) != null) {
            return entry.isLeaf();
        }
        return false;
    }

    public final int getIndexOfChild(Object object, Object child) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            for (int i = 0; i < this.roots.size(); ++i) {
                if (child != this.roots.get(i)) continue;
                return i;
            }
        } else if (object instanceof Node && child instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getIndexOf((Node)child);
        }
        return -1;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private boolean hasEntry(VirtualFile file2) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry entry = root.tree.findEntry(file2);
                if (entry == null) continue;
                return true;
            }
        }
        return false;
    }

    private MapBasedTree.Entry<Node> getEntry(Node node, boolean loadChildren) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry<Node> entry = root.tree.getEntry(node);
                if (entry == null) continue;
                if (loadChildren && entry.isLoadingRequired()) {
                    root.updateChildren(this.state, entry);
                }
                return entry;
            }
        }
        return null;
    }

    private void process(List<? extends VFileEvent> events) {
        if (this.roots == null) {
            return;
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VFileEvent virtualFile : events) {
            VirtualFile file2;
            if (virtualFile instanceof VFilePropertyChangeEvent) {
                if (!this.hasEntry(virtualFile.getFile())) continue;
                files2.add(virtualFile.getFile());
                continue;
            }
            if (virtualFile instanceof VFileCreateEvent) {
                VFileCreateEvent create2 = (VFileCreateEvent)virtualFile;
                if (!this.hasEntry(create2.getParent())) continue;
                parents.add(create2.getParent());
                continue;
            }
            if (virtualFile instanceof VFileCopyEvent) {
                VFileCopyEvent copy = (VFileCopyEvent)virtualFile;
                if (!this.hasEntry(copy.getNewParent())) continue;
                parents.add(copy.getNewParent());
                continue;
            }
            if (virtualFile instanceof VFileMoveEvent) {
                VFileMoveEvent move = (VFileMoveEvent)virtualFile;
                if (this.hasEntry(move.getNewParent())) {
                    parents.add(move.getNewParent());
                }
                if (!this.hasEntry(move.getOldParent())) continue;
                parents.add(move.getOldParent());
                continue;
            }
            if (!(virtualFile instanceof VFileDeleteEvent) || !this.hasEntry(file2 = virtualFile.getFile())) continue;
            files2.add(file2);
            file2 = file2.getParent();
            parents.add((VirtualFile)(this.hasEntry(file2) ? file2 : null));
        }
        for (VirtualFile virtualFile : parents) {
            for (Root root : this.roots) {
                boolean contained;
                MapBasedTree.Entry entry = root.tree.findEntry(virtualFile);
                if (entry == null) continue;
                MapBasedTree.UpdateResult update = root.updateChildren(this.state, entry);
                boolean removed = !update.getRemoved().isEmpty();
                boolean inserted = !update.getInserted().isEmpty();
                boolean bl = contained = !update.getContained().isEmpty();
                if (!removed && !inserted && !contained) continue;
                if (!removed && inserted) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesInserted(update.getEvent(this, entry, update.getInserted()));
                    continue;
                }
                if (!inserted && removed) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesRemoved(update.getEvent(this, entry, update.getRemoved()));
                    continue;
                }
                this.treeStructureChanged(entry, null, null);
            }
        }
        for (VirtualFile virtualFile : files2) {
        }
    }

    private static VirtualFile findFile(String path) {
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/tree/FileTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/tree/FileTreeModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueID";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Root
    extends Node {
        private final MapBasedTree<VirtualFile, Node> tree;

        private Root(State state, VirtualFile file2) {
            super(state, file2);
            if (state.refresher != null && state.refresher.isRecursive()) {
                state.refresher.register(file2);
            }
            this.tree = new MapBasedTree<VirtualFile, Node>(false, node -> node.getFile(), state.path);
            this.tree.onInsert(node -> Root.markDirtyInternal(node.getFile()));
            this.tree.updateRoot((Pair<Node, Boolean>)Pair.create((Object)this, (Object)state.isLeaf(file2)));
        }

        private static void markDirtyInternal(VirtualFile file2) {
            Method method;
            if (file2 instanceof VirtualFileSystemEntry && (method = ReflectionUtil.getDeclaredMethod(VirtualFileSystemEntry.class, (String)"markDirtyInternal", (Class[])new Class[0])) != null) {
                try {
                    method.invoke((Object)file2, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private MapBasedTree.UpdateResult<Node> updateChildren(State state, MapBasedTree.Entry<Node> parent) {
            VirtualFile[] children2 = state.getChildren(parent.getNode().getFile());
            if (children2 == null) {
                return this.tree.update(parent, null);
            }
            if (children2.length == 0) {
                return this.tree.update(parent, Collections.emptyList());
            }
            return this.tree.update(parent, Arrays.stream(children2).filter(x$0 -> state.isVisible(x$0)).sorted((x$0, x$1) -> state.compare(x$0, x$1)).map(file2 -> {
                MapBasedTree.Entry<Node> entry = this.tree.findEntry((VirtualFile)file2);
                return entry != null && parent == entry.getParentPath() ? Pair.create((Object)entry.getNode(), (Object)entry.isLeaf()) : Pair.create((Object)new Node(state, (VirtualFile)file2), (Object)state.isLeaf(file2));
            }).collect(Collectors.toList()));
        }
    }

    private static class Node
    extends FileNode {
        private boolean invalid;

        private Node(State state, VirtualFile file2) {
            super(file2);
            if (state.refresher != null && !state.refresher.isRecursive()) {
                state.refresher.register(file2);
            }
            this.updateContent(state);
        }

        private boolean updateContent(State state) {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return this.updateName(state.descriptor.getTitle());
            }
            Icon icon = state.descriptor.getIcon(file2);
            String name = state.descriptor.getName(file2);
            String comment = state.descriptor.getComment(file2);
            if (name == null || comment == null) {
                name = file2.getName();
            }
            boolean updated = false;
            if (this.updateIcon(icon)) {
                updated = true;
            }
            if (this.updateName(name)) {
                updated = true;
            }
            if (this.updateComment(comment)) {
                updated = true;
            }
            if (this.updateValid(file2.isValid())) {
                updated = true;
            }
            if (this.updateHidden(FileElement.isFileHidden((VirtualFile)file2))) {
                updated = true;
            }
            if (this.updateSpecial(file2.is(VFileProperty.SPECIAL))) {
                updated = true;
            }
            if (this.updateSymlink(file2.is(VFileProperty.SYMLINK))) {
                updated = true;
            }
            if (this.updateWritable(file2.isWritable())) {
                updated = true;
            }
            return updated;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class State {
        private final TreePath path = new TreePath(this);
        private final FileChooserDescriptor descriptor;
        private final FileRefresher refresher;
        private final boolean sortDirectories;
        private final boolean sortArchives;
        private final List<VirtualFile> roots;

        private State(FileChooserDescriptor descriptor, FileRefresher refresher, boolean sortDirectories, boolean sortArchives) {
            this.descriptor = descriptor;
            this.refresher = refresher;
            this.sortDirectories = sortDirectories;
            this.sortArchives = sortArchives;
            this.roots = State.getRoots(descriptor);
        }

        private int compare(VirtualFile one, VirtualFile two) {
            if (one == null && two == null) {
                return 0;
            }
            if (one == null) {
                return -1;
            }
            if (two == null) {
                return 1;
            }
            if (this.sortDirectories) {
                boolean isArchive;
                boolean isDirectory = one.isDirectory();
                if (isDirectory != two.isDirectory()) {
                    return isDirectory ? -1 : 1;
                }
                if (!isDirectory && this.sortArchives && this.descriptor.isChooseJarContents() && (isArchive = FileElement.isArchive((VirtualFile)one)) != FileElement.isArchive((VirtualFile)two)) {
                    return isArchive ? -1 : 1;
                }
            }
            return StringUtil.naturalCompare((String)one.getName(), (String)two.getName());
        }

        private static boolean isValid(VirtualFile file2) {
            return file2 != null && file2.isValid();
        }

        private boolean isVisible(VirtualFile file2) {
            return State.isValid(file2) && this.descriptor.isFileVisible(file2, this.descriptor.isShowHiddenFiles());
        }

        private boolean isLeaf(VirtualFile file2) {
            if (file2 == null || file2.isDirectory()) {
                return false;
            }
            return !this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2);
        }

        private VirtualFile[] getChildren(VirtualFile file2) {
            if (file2.isDirectory()) {
                return file2.getChildren();
            }
            if (!this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2)) {
                return null;
            }
            String path = file2.getPath() + "!/";
            VirtualFile jar = JarFileSystem.getInstance().findFileByPath(path);
            return jar == null ? VirtualFile.EMPTY_ARRAY : jar.getChildren();
        }

        private List<Root> getRoots() {
            List<VirtualFile> files2 = this.roots;
            if (files2 == null) {
                files2 = State.getSystemRoots();
            }
            if (files2 == null || files2.isEmpty()) {
                return Collections.emptyList();
            }
            return files2.stream().map(file2 -> new Root(this, (VirtualFile)file2)).collect(Collectors.toList());
        }

        private static List<VirtualFile> getRoots(FileChooserDescriptor descriptor) {
            List<VirtualFile> list2 = descriptor.getRoots().stream().filter(State::isValid).collect(Collectors.toList());
            return list2.isEmpty() && descriptor.isShowFileSystemRoots() ? null : list2;
        }

        private static List<VirtualFile> getSystemRoots() {
            File[] roots = File.listRoots();
            return roots == null || roots.length == 0 ? Collections.emptyList() : Arrays.stream(roots).map(root -> FileTreeModel.findFile(root.getAbsolutePath())).filter(State::isValid).collect(Collectors.toList());
        }

        public String toString() {
            return this.descriptor.getTitle();
        }
    }
}

