/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SearchTextField;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements DataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;
    private final boolean myApplyButtonNeeded;
    private boolean myResetButtonNeeded;

    public SettingsDialog(Project project, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        if (configurable == null) {
            SettingsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, project);
    }

    public SettingsDialog(@NotNull Component parent, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        if (parent == null) {
            SettingsDialog.$$$reportNull$$$0(1);
        }
        if (configurable == null) {
            SettingsDialog.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, null);
    }

    public SettingsDialog(@NotNull Project project, @NotNull ConfigurableGroup[] groups, Configurable configurable, String filter2) {
        if (project == null) {
            SettingsDialog.$$$reportNull$$$0(3);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(4);
        }
        super(project, true);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project, groups, configurable, filter2, this::treeViewFactory);
        this.myApplyButtonNeeded = true;
        this.init(null, project);
    }

    protected SettingsTreeView treeViewFactory(SettingsFilter filter2, ConfigurableGroup[] groups) {
        return new SettingsTreeView(filter2, groups);
    }

    public void show() {
        TransactionGuard.getInstance().submitTransactionAndWait(() -> super.show());
    }

    private void init(Configurable configurable, @Nullable Project project) {
        String name = configurable == null ? null : configurable.getDisplayName();
        String title = CommonBundle.settingsTitle();
        if (project != null && project.isDefault()) {
            title = "Default " + title;
        }
        this.setTitle(name == null ? title : name.replace('\n', ' '));
        ShortcutSet set2 = SettingsDialog.getFindActionShortcutSet();
        if (set2 != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(set2, (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.init();
    }

    public Object getData(@NonNls String dataId) {
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider = (DataProvider)this.myEditor;
            return provider.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            SettingsDialog.$$$reportNull$$$0(5);
        }
        return dialogStyle;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    protected void tryAddOptionsListener(OptionsEditorColleague colleague) {
        if (this.myEditor instanceof SettingsEditor) {
            ((SettingsEditor)this.myEditor).addOptionsListener(colleague);
        }
    }

    @NotNull
    protected Action[] createActions() {
        String topic;
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply2 = this.myEditor.getApplyAction();
        if (apply2 != null && this.myApplyButtonNeeded) {
            actions.add(apply2);
        }
        if ((reset = this.myEditor.getResetAction()) != null && this.myResetButtonNeeded) {
            actions.add(reset);
        }
        if ((topic = this.getHelpTopic()) != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SettingsDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    protected String getHelpTopic() {
        return this.myEditor.getHelpTopic();
    }

    protected void doHelpAction() {
        String topic = this.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    public void doOKAction() {
        if (this.myEditor.apply()) {
            ApplicationManager.getApplication().saveAll(true);
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel()) {
            return;
        }
        super.doCancelAction(source);
    }

    static ShortcutSet getFindActionShortcutSet() {
        AnAction action = ActionManager.getInstance().getAction("Find");
        return action == null ? null : action.getShortcutSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

