/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class CallCommand
extends AbstractCommand {
    public static final String PREFIX = "%call";

    public CallCommand(String text, int line) {
        super(text, line, true);
    }

    @Override
    protected ActionCallback _execute(PlaybackContext context) {
        ActionCallback cmdResult = new ActionCallback();
        String cmd = this.getText().substring(PREFIX.length()).trim();
        int open2 = cmd.indexOf("(");
        if (open2 == -1) {
            context.error("( expected", this.getLine());
            return ActionCallback.DONE;
        }
        int close2 = cmd.lastIndexOf(")");
        if (close2 == -1) {
            context.error(") expected", this.getLine());
            return ActionCallback.DONE;
        }
        String methodName = cmd.substring(0, open2);
        String[] args = cmd.substring(open2 + 1, close2).split(",");
        boolean noArgs = args.length == 1 && args[0].length() == 0;
        Class[] types = noArgs ? new Class[1] : new Class[args.length + 1];
        types[0] = PlaybackContext.class;
        for (int i = 1; i < types.length; ++i) {
            types[i] = String.class;
        }
        try {
            Pair<Method, Class> methodClass = CallCommand.findMethod(context, methodName, types);
            if (methodClass == null) {
                context.error("No method \"" + methodName + "\" found in facade classes: " + context.getCallClasses(), this.getLine());
                return ActionCallback.REJECTED;
            }
            Method m = (Method)methodClass.getFirst();
            if (!m.getReturnType().isAssignableFrom(AsyncResult.class)) {
                context.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object", this.getLine());
                return ActionCallback.REJECTED;
            }
            Object[] actualArgs = noArgs ? new Object[1] : new Object[args.length + 1];
            actualArgs[0] = context;
            System.arraycopy(args, 0, actualArgs, 1, actualArgs.length - 1);
            AsyncResult result2 = (AsyncResult)m.invoke(null, actualArgs);
            if (result2 == null) {
                context.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object, but was null", this.getLine());
                return ActionCallback.REJECTED;
            }
            result2.doWhenDone(s -> {
                if (s != null) {
                    context.message((String)s, this.getLine());
                }
                cmdResult.setDone();
            }).doWhenRejected(s -> {
                context.error((String)s, this.getLine());
                cmdResult.setRejected();
            });
        }
        catch (InvocationTargetException ignored) {
            context.error("InvocationTargetException while executing command: " + cmd, this.getLine());
        }
        catch (IllegalAccessException ignored) {
            context.error("IllegalAccessException while executing command: " + cmd, this.getLine());
        }
        return cmdResult;
    }

    private static Pair<Method, Class> findMethod(PlaybackContext context, String methodName, Class[] types) {
        Set<Class> classes = context.getCallClasses();
        for (Class eachClass : classes) {
            try {
                Method method = eachClass.getMethod(methodName, types);
                return Pair.create((Object)method, (Object)eachClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }
}

