/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotateLocalFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateLocalFileAction.class);

    private static boolean isEnabled(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 == null || file2.isDirectory() || file2.getFileType().isBinary()) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file2);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
    }

    private static boolean isSuspended(AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsContextFactory.SERVICE.getInstance().createContextOn(e).getSelectedFile());
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file2).isLocked();
    }

    private static boolean isAnnotated(AnActionEvent e) {
        List<Editor> editors = AnnotateLocalFileAction.getEditors(e.getDataContext());
        return ContainerUtil.exists(editors, editor -> editor.getGutter().isAnnotationsShown());
    }

    private static void perform(AnActionEvent e, boolean selected) {
        if (!selected) {
            List<Editor> editors = AnnotateLocalFileAction.getEditors(e.getDataContext());
            for (Editor editor : editors) {
                editor.getGutter().closeAllAnnotations();
            }
        } else {
            Project project = (Project)ObjectUtils.assertNotNull((Object)e.getProject());
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                FileEditor[] fileEditors;
                VirtualFile selectedFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
                for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(selectedFile, false)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                }
            }
            LOG.assertTrue(editor != null);
            AnnotateLocalFileAction.doAnnotate(editor, project);
        }
    }

    private static void doAnnotate(final @NotNull Editor editor, final @NotNull Project project) {
        VirtualFile file2;
        if (editor == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(1);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return;
        }
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        VcsAnnotateUtil.getBackgroundableLock(project, file2).lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(file2));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                VcsAnnotateUtil.getBackgroundableLock(project, file2).unlock();
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project, file2, (FileAnnotation)fileAnnotationRef.get(), vcs);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull DataContext context) {
        Editor editor;
        if (context == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(2);
        }
        if ((editor = (Editor)context.getData(CommonDataKeys.EDITOR)) != null) {
            List<Editor> list2 = Collections.singletonList(editor);
            if (list2 == null) {
                AnnotateLocalFileAction.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || file2 == null) {
            List<Editor> list3 = Collections.emptyList();
            if (list3 == null) {
                AnnotateLocalFileAction.$$$reportNull$$$0(4);
            }
            return list3;
        }
        List<Editor> list4 = VcsAnnotateUtil.getEditors(project, file2);
        if (list4 == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(5);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateLocalFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(AnActionEvent e) {
            return AnnotateLocalFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateLocalFileAction.isAnnotated(e);
        }

        @Override
        public void perform(AnActionEvent e, boolean selected) {
            AnnotateLocalFileAction.perform(e, selected);
        }
    }
}

