/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.ColorMode;
import com.intellij.openapi.vcs.actions.ShowAnnotationColorsAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotationFieldGutter
implements ActiveAnnotationGutter {
    @NotNull
    protected final FileAnnotation myAnnotation;
    @NotNull
    private final TextAnnotationPresentation myPresentation;
    @Nullable
    private final Couple<Map<VcsRevisionNumber, Color>> myColorScheme;

    AnnotationFieldGutter(@NotNull FileAnnotation annotation, @NotNull TextAnnotationPresentation presentation, @Nullable Couple<Map<VcsRevisionNumber, Color>> colorScheme) {
        if (annotation == null) {
            AnnotationFieldGutter.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            AnnotationFieldGutter.$$$reportNull$$$0(1);
        }
        this.myAnnotation = annotation;
        this.myPresentation = presentation;
        this.myColorScheme = colorScheme;
    }

    public boolean isGutterAction() {
        return false;
    }

    @Nullable
    public String getToolTip(int line, Editor editor) {
        return null;
    }

    public void doAction(int line) {
    }

    public Cursor getCursor(int line) {
        return Cursor.getDefaultCursor();
    }

    public EditorFontType getStyle(int line, Editor editor) {
        return this.myPresentation.getFontType(line);
    }

    @Nullable
    public ColorKey getColor(int line, Editor editor) {
        return this.myPresentation.getColor(line);
    }

    public List<AnAction> getPopupActions(int line, Editor editor) {
        return this.myPresentation.getActions(line);
    }

    public void gutterClosed() {
        this.myPresentation.gutterClosed();
    }

    @Nullable
    public Color getBgColor(int line, Editor editor) {
        Map colorMap;
        if (this.myColorScheme == null) {
            return null;
        }
        ColorMode type = ShowAnnotationColorsAction.getType();
        Map map = colorMap = type == ColorMode.AUTHOR ? (Map)this.myColorScheme.second : (Map)this.myColorScheme.first;
        if (colorMap == null || type == ColorMode.NONE) {
            return null;
        }
        VcsRevisionNumber number = this.myAnnotation.getLineRevisionNumber(line);
        if (number == null) {
            return null;
        }
        return (Color)colorMap.get(number);
    }

    public boolean isShowByDefault() {
        return true;
    }

    public boolean isAvailable() {
        return VcsUtil.isAspectAvailableByDefault((String)this.getID(), (boolean)this.isShowByDefault());
    }

    @Nullable
    public String getID() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "annotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "presentation";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotationFieldGutter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

