/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private final VcsGuess myGuess;
    private final DirtBuilder myDirtBuilder;
    @Nullable
    private DirtBuilder myDirtInProgress;
    private boolean myReady;
    private final Object LOCK = new Object();

    public VcsDirtyScopeManagerImpl(Project project, ChangeListManager changeListManager, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)vcsManager;
        this.myGuess = new VcsGuess(this.myProject);
        this.myDirtBuilder = new DirtBuilder(this.myGuess);
        ((ChangeListManagerImpl)this.myChangeListManager).setDirtyScopeManager(this);
    }

    public void projectOpened() {
        this.myVcsManager.addInitializationRequest(VcsInitObject.DIRTY_SCOPE_MANAGER, () -> {
            boolean ready = false;
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                    ready = true;
                    this.myReady = true;
                }
            }
            if (ready) {
                VcsDirtyScopeVfsListener.install(this.myProject);
                this.markEverythingDirty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEverythingDirty() {
        if (!this.myProject.isOpen() || this.myProject.isDisposed() || this.myVcsManager.getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myReady) {
                this.myDirtBuilder.everythingDirty();
            }
        }
        this.myChangeListManager.scheduleUpdate();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("VcsDirtyScopeManager" == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(0);
        }
        return "VcsDirtyScopeManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
            this.myDirtBuilder.reset();
            this.myDirtInProgress = null;
        }
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> groupByVcs(@Nullable Collection<FilePath> from) {
        if (from == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(1);
            }
            return multiMap;
        }
        MultiMap map = MultiMap.createSet();
        for (FilePath path : from) {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(path);
            if (vcs == null) continue;
            map.putValue((Object)vcs, (Object)path);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filePathsDirty(@Nullable Collection<FilePath> filesDirty, @Nullable Collection<FilePath> dirsRecursivelyDirty) {
        try {
            boolean hasSomethingDirty;
            MultiMap<AbstractVcs, FilePath> filesConverted = this.groupByVcs(filesDirty);
            MultiMap<AbstractVcs, FilePath> dirsConverted = this.groupByVcs(dirsRecursivelyDirty);
            if (filesConverted.isEmpty() && dirsConverted.isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("dirty files: " + VcsDirtyScopeManagerImpl.toString(filesConverted) + "; dirty dirs: " + VcsDirtyScopeManagerImpl.toString(dirsConverted) + "; " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.myReady) {
                    return;
                }
                VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, filesConverted, false);
                VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, dirsConverted, true);
                hasSomethingDirty = !this.myDirtBuilder.isEmpty();
            }
            if (hasSomethingDirty) {
                this.myChangeListManager.scheduleUpdate();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static void markDirty(@NotNull DirtBuilder dirtBuilder, @NotNull MultiMap<AbstractVcs, FilePath> filesOrDirs, boolean recursively) {
        if (dirtBuilder == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(3);
        }
        if (filesOrDirs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(4);
        }
        for (AbstractVcs vcs : filesOrDirs.keySet()) {
            for (FilePath path : filesOrDirs.get((Object)vcs)) {
                if (recursively) {
                    dirtBuilder.addDirtyDirRecursively(vcs, path);
                    continue;
                }
                dirtBuilder.addDirtyFile(vcs, path);
            }
        }
    }

    public void filesDirty(@Nullable Collection<VirtualFile> filesDirty, @Nullable Collection<VirtualFile> dirsRecursivelyDirty) {
        this.filePathsDirty(VcsDirtyScopeManagerImpl.toFilePaths(filesDirty), VcsDirtyScopeManagerImpl.toFilePaths(dirsRecursivelyDirty));
    }

    @NotNull
    private static Collection<FilePath> toFilePaths(@Nullable Collection<VirtualFile> files2) {
        if (files2 == null) {
            List<FilePath> list2 = Collections.emptyList();
            if (list2 == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List list3 = ContainerUtil.map(files2, virtualFile -> VcsUtil.getFilePath((VirtualFile)virtualFile));
        if (list3 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(6);
        }
        return list3;
    }

    public void fileDirty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(7);
        }
        this.fileDirty(VcsUtil.getFilePath((VirtualFile)file2));
    }

    public void fileDirty(@NotNull FilePath file2) {
        if (file2 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(8);
        }
        this.filePathsDirty(Collections.singleton(file2), null);
    }

    public void dirDirtyRecursively(VirtualFile dir, boolean scheduleUpdate) {
        this.dirDirtyRecursively(dir);
    }

    public void dirDirtyRecursively(VirtualFile dir) {
        this.dirDirtyRecursively(VcsUtil.getFilePath((VirtualFile)dir));
    }

    public void dirDirtyRecursively(FilePath path) {
        this.filePathsDirty(null, Collections.singleton(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsInvalidated retrieveScopes() {
        DirtBuilder dirtBuilder;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return null;
            }
            this.myDirtInProgress = dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            this.myDirtBuilder.reset();
        }
        return this.calculateInvalidated(dirtBuilder);
    }

    @NotNull
    private VcsInvalidated calculateInvalidated(@NotNull DirtBuilder dirt) {
        if (dirt == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(9);
        }
        MultiMap<AbstractVcs, FilePath> files2 = dirt.getFilesForVcs();
        MultiMap<AbstractVcs, FilePath> dirs = dirt.getDirsForVcs();
        if (dirt.isEverythingDirty()) {
            dirs.putAllValues(this.getEverythingDirtyRoots());
        }
        Set keys = ContainerUtil.union((Set)files2.keySet(), (Set)dirs.keySet());
        HashMap scopes = ContainerUtil.newHashMap();
        for (AbstractVcs key : keys) {
            VcsDirtyScopeImpl scope = new VcsDirtyScopeImpl(key, this.myProject);
            scopes.put(key, scope);
            scope.addDirtyData(dirs.get((Object)key), files2.get((Object)key));
        }
        VcsInvalidated vcsInvalidated = new VcsInvalidated(new ArrayList(scopes.values()), dirt.isEverythingDirty());
        if (vcsInvalidated == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(10);
        }
        return vcsInvalidated;
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> getEverythingDirtyRoots() {
        MultiMap dirtyRoots = MultiMap.createSet();
        dirtyRoots.putAllValues(this.groupByVcs(VcsDirtyScopeManagerImpl.toFilePaths(DefaultVcsRootPolicy.getInstance(this.myProject).getDirtyRoots())));
        List<VcsDirectoryMapping> mappings = this.myVcsManager.getDirectoryMappings();
        for (VcsDirectoryMapping mapping : mappings) {
            AbstractVcs vcs;
            if (mapping.isDefaultMapping() || mapping.getVcs() == null || (vcs = this.myVcsManager.findVcsByName(mapping.getVcs())) == null) continue;
            dirtyRoots.putValue((Object)vcs, (Object)VcsUtil.getFilePath((String)mapping.getDirectory(), (boolean)true));
        }
        MultiMap multiMap = dirtyRoots;
        if (multiMap == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changesProcessed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtInProgress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<FilePath> files2) {
        DirtBuilder dirtBuilderInProgress;
        DirtBuilder dirtBuilder;
        if (files2 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(12);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                List<FilePath> list2 = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var4_2
                if (list2 == null) {
                    VcsDirtyScopeManagerImpl.$$$reportNull$$$0(13);
                }
                return list2;
            }
            dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            dirtBuilderInProgress = this.myDirtInProgress != null ? new DirtBuilder(this.myDirtInProgress) : new DirtBuilder(this.myGuess);
        }
        VcsInvalidated invalidated = this.calculateInvalidated(dirtBuilder);
        VcsInvalidated inProgress = this.calculateInvalidated(dirtBuilderInProgress);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (FilePath fp : files2) {
            if (!invalidated.isFileDirty(fp) && !inProgress.isFileDirty(fp)) continue;
            result2.add(fp);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static String toString(@NotNull MultiMap<AbstractVcs, FilePath> filesByVcs) {
        if (filesByVcs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(15);
        }
        String string = StringUtil.join((Collection)filesByVcs.keySet(), vcs -> {
            if (filesByVcs == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(17);
            }
            return vcs.getName() + ": " + StringUtil.join((Collection)filesByVcs.get(vcs), path -> path.getPath(), (String)"\n");
        }, (String)"\n");
        if (string == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private static Class findFirstInterestingCallerClass() {
        for (int i = 1; i <= 5; ++i) {
            Class clazz = ReflectionUtil.findCallerClass((int)i);
            if (clazz != null && clazz.getName().contains(VcsDirtyScopeManagerImpl.class.getName())) continue;
            return clazz;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesOrDirs";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirt";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesByVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByVcs";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toFilePaths";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateInvalidated";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEverythingDirtyRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "whatFilesDirty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markDirty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileDirty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateInvalidated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "whatFilesDirty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toString$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

