/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupportKt;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingPolicy;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0011\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0019\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0010H\u0086\u0002J\u0014\u0010$\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0016\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "", "project", "Lcom/intellij/openapi/project/Project;", "source", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "changeSupport", "Ljava/beans/PropertyChangeSupport;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "getGrouping", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "groupingConfig", "", "", "kotlin.jvm.PlatformType", "", "groupingFactories", "Lcom/intellij/openapi/util/KeyedExtensionFactory;", "groupingKeys", "", "getGroupingKeys", "()Ljava/util/Set;", "isDirectory", "()Z", "isNone", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "get", "groupingKey", "isAvailable", "removePropertyChangeListener", "set", "state", "setGroupingKeysOrSkip", "Companion", "intellij.platform.vcs.impl"})
public final class ChangesGroupingSupport {
    private final PropertyChangeSupport changeSupport;
    private final KeyedExtensionFactory<ChangesGroupingPolicyFactory, String> groupingFactories;
    private final Map<String, Boolean> groupingConfig;
    @JvmField
    @NotNull
    public static final DataKey<ChangesGroupingSupport> KEY;
    @NotNull
    public static final String PROP_GROUPING_KEYS = "ChangesGroupingKeys";
    @NotNull
    public static final String DIRECTORY_GROUPING = "directory";
    @NotNull
    public static final String MODULE_GROUPING = "module";
    @NotNull
    public static final String NONE_GROUPING = "none";
    public static final Companion Companion;

    @NotNull
    public final Set<String> getGroupingKeys() {
        Map<String, Boolean> $receiver$iv = this.groupingConfig;
        LinkedHashMap<String, Boolean> result$iv = new LinkedHashMap<String, Boolean>();
        Map<String, Boolean> map = $receiver$iv;
        for (Map.Entry<String, Boolean> entry$iv : map.entrySet()) {
            boolean it = entry$iv.getValue();
            if (!it) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    public final boolean get(@NotNull String groupingKey) {
        Intrinsics.checkParameterIsNotNull((Object)groupingKey, (String)"groupingKey");
        if (!this.isAvailable(groupingKey)) {
            throw (Throwable)new IllegalArgumentException("Unknown grouping " + groupingKey);
        }
        Boolean bl = this.groupingConfig.get(groupingKey);
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        return bl;
    }

    public final void set(@NotNull String groupingKey, boolean state) {
        Intrinsics.checkParameterIsNotNull((Object)groupingKey, (String)"groupingKey");
        if (!this.isAvailable(groupingKey)) {
            throw (Throwable)new IllegalArgumentException("Unknown grouping " + groupingKey);
        }
        if (Intrinsics.areEqual((Object)this.groupingConfig.get(groupingKey), (Object)state) ^ true) {
            Set<String> oldGroupingKeys = this.getGroupingKeys();
            Map<String, Boolean> map = this.groupingConfig;
            Boolean bl = state;
            map.put(groupingKey, bl);
            this.changeSupport.firePropertyChange(PROP_GROUPING_KEYS, oldGroupingKeys, this.getGroupingKeys());
        }
    }

    @NotNull
    public final ChangesGroupingPolicyFactory getGrouping() {
        return new ChangesGroupingPolicyFactory(this){
            final /* synthetic */ ChangesGroupingSupport this$0;

            @NotNull
            public ChangesGroupingPolicy createGroupingPolicy(@NotNull DefaultTreeModel model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                ChangesGroupingPolicy result2 = new NoneChangesGroupingPolicy.Factory().createGroupingPolicy(model);
                Iterator<T> $receiver$iv = ChangesGroupingSupport.access$getGroupingConfig$p(this.this$0);
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                Object object = $receiver$iv;
                for (Map.Entry<K, V> entry$iv : object.entrySet()) {
                    boolean it = (Boolean)entry$iv.getValue();
                    if (!it) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $receiver$iv = ((Map)result$iv).keySet();
                Iterator<T> iterator = $receiver$iv;
                object = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        String it = (String)b;
                        Comparable comparable = (Integer)ChangesGroupingSupportKt.access$getPREDEFINED_PRIORITIES$p().get(it);
                        it = (String)a;
                        Comparable comparable2 = comparable;
                        Integer n = (Integer)ChangesGroupingSupportKt.access$getPREDEFINED_PRIORITIES$p().get(it);
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                $receiver$iv = CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)object);
                iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    ChangesGroupingPolicy changesGroupingPolicy;
                    T element$iv = iterator.next();
                    String it = (String)element$iv;
                    Object object2 = ChangesGroupingSupport.access$getGroupingFactories$p(this.this$0).getByKey((Object)it);
                    if (object2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ChangesGroupingPolicy $receiver = changesGroupingPolicy = ((ChangesGroupingPolicyFactory)object2).createGroupingPolicy(model);
                    $receiver.setNextGroupingPolicy(result2);
                    ChangesGroupingPolicy changesGroupingPolicy2 = changesGroupingPolicy;
                    Intrinsics.checkExpressionValueIsNotNull((Object)changesGroupingPolicy2, (String)"groupingFactories.getByK\u2026tGroupingPolicy(result) }");
                }
                return result2;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public final boolean isNone() {
        return this.getGroupingKeys().isEmpty();
    }

    public final boolean isDirectory() {
        return this.get(DIRECTORY_GROUPING);
    }

    public final void setGroupingKeysOrSkip(@NotNull Set<String> groupingKeys) {
        Intrinsics.checkParameterIsNotNull(groupingKeys, (String)"groupingKeys");
        Iterable $receiver$iv = this.groupingConfig.entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            it.setValue(groupingKeys.contains(it.getKey()));
        }
    }

    public final boolean isAvailable(@NotNull String groupingKey) {
        Intrinsics.checkParameterIsNotNull((Object)groupingKey, (String)"groupingKey");
        return this.groupingFactories.getByKey((Object)groupingKey) != null;
    }

    public final void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.changeSupport.addPropertyChangeListener(listener2);
    }

    public final void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.changeSupport.removePropertyChangeListener(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public ChangesGroupingSupport(@NotNull Project project, @NotNull Object source) {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.changeSupport = new PropertyChangeSupport(source);
        this.groupingFactories = Companion.collectFactories(project);
        Set set2 = this.groupingFactories.getAllKeys();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"groupingFactories.allKeys");
        Iterable iterable = set2;
        ChangesGroupingSupport changesGroupingSupport = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var5_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it;
            String string = (String)element$iv$iv;
            map = destination$iv$iv;
            void var15_12 = it;
            it = (String)element$iv$iv;
            Boolean bl = false;
            map.put(var15_12, bl);
        }
        map = destination$iv$iv;
        changesGroupingSupport.groupingConfig = MapsKt.toMutableMap((Map)map);
    }

    static {
        Companion = new Companion(null);
        KEY = DataKey.create((String)"ChangesTree.GroupingSupport");
    }

    @NotNull
    public static final /* synthetic */ Map access$getGroupingConfig$p(ChangesGroupingSupport $this) {
        return $this.groupingConfig;
    }

    @NotNull
    public static final /* synthetic */ KeyedExtensionFactory access$getGroupingFactories$p(ChangesGroupingSupport $this) {
        return $this.groupingFactories;
    }

    @JvmStatic
    @NotNull
    public static final KeyedExtensionFactory<ChangesGroupingPolicyFactory, String> collectFactories(@NotNull Project project) {
        return Companion.collectFactories(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion;", "", "()V", "DIRECTORY_GROUPING", "", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "kotlin.jvm.PlatformType", "MODULE_GROUPING", "NONE_GROUPING", "PROP_GROUPING_KEYS", "collectFactories", "Lcom/intellij/openapi/util/KeyedExtensionFactory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KeyedExtensionFactory<ChangesGroupingPolicyFactory, String> collectFactories(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KeyedExtensionFactory)new KeyedExtensionFactory<ChangesGroupingPolicyFactory, String>(project, ChangesGroupingPolicyFactory.class, ChangesGroupingPolicyFactory.EP_NAME, project.getPicoContainer()){
                final /* synthetic */ Project $project;

                @NotNull
                public String getKey(@NotNull String key) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    return key;
                }
                {
                    this.$project = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

