/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.vcs.commit.CommitMessageInspectionsPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CommitDialogSettingsPanel
implements ConfigurableUi<VcsConfiguration>,
Disposable {
    @NotNull
    private final Project myProject;
    private JBCheckBox myShowUnversionedFiles;
    private JPanel myMainPanel;
    private CommitMessageInspectionsPanel myInspectionsPanel;
    private JBCheckBox myClearInitialCommitMessage;
    private JBCheckBox myForceNonEmptyCommitMessage;
    private JBCheckBox myMoveUncommittedToAnotherChangeList;
    private ComboBox<VcsShowConfirmationOption.Value> myMoveToFailedCommitChangeList;
    private final EnumComboBoxModel<VcsShowConfirmationOption.Value> myMoveToFailedCommitChangeListModel;

    public CommitDialogSettingsPanel(@NotNull Project project) {
        if (project == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myMoveToFailedCommitChangeListModel = new EnumComboBoxModel(VcsShowConfirmationOption.Value.class);
        this.myMoveToFailedCommitChangeList.setRenderer((ListCellRenderer)new ListCellRendererWrapper<VcsShowConfirmationOption.Value>(){

            public void customize(JList list2, VcsShowConfirmationOption.Value value, int index, boolean selected, boolean hasFocus) {
                this.setText(CommitDialogSettingsPanel.getConfirmationOptionText(value));
            }
        });
        this.myMoveToFailedCommitChangeList.setModel(this.myMoveToFailedCommitChangeListModel);
    }

    public void reset(@NotNull VcsConfiguration settings) {
        if (settings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myShowUnversionedFiles.setSelected(settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT);
        this.myClearInitialCommitMessage.setSelected(settings.CLEAR_INITIAL_COMMIT_MESSAGE);
        this.myForceNonEmptyCommitMessage.setSelected(settings.FORCE_NON_EMPTY_COMMENT);
        this.myMoveUncommittedToAnotherChangeList.setSelected(settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT);
        this.myMoveToFailedCommitChangeListModel.setSelectedItem((Enum)settings.MOVE_TO_FAILED_COMMIT_CHANGELIST);
        this.myInspectionsPanel.reset();
    }

    public boolean isModified(@NotNull VcsConfiguration settings) {
        if (settings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(2);
        }
        return settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT != this.myShowUnversionedFiles.isSelected() || settings.CLEAR_INITIAL_COMMIT_MESSAGE != this.myClearInitialCommitMessage.isSelected() || settings.FORCE_NON_EMPTY_COMMENT != this.myForceNonEmptyCommitMessage.isSelected() || settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT != this.myMoveUncommittedToAnotherChangeList.isSelected() || settings.MOVE_TO_FAILED_COMMIT_CHANGELIST != this.myMoveToFailedCommitChangeListModel.getSelectedItem() || this.myInspectionsPanel.isModified();
    }

    public void apply(@NotNull VcsConfiguration settings) throws ConfigurationException {
        if (settings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(3);
        }
        settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT = this.myShowUnversionedFiles.isSelected();
        settings.CLEAR_INITIAL_COMMIT_MESSAGE = this.myClearInitialCommitMessage.isSelected();
        settings.FORCE_NON_EMPTY_COMMENT = this.myForceNonEmptyCommitMessage.isSelected();
        settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT = this.myMoveUncommittedToAnotherChangeList.isSelected();
        settings.MOVE_TO_FAILED_COMMIT_CHANGELIST = (VcsShowConfirmationOption.Value)this.myMoveToFailedCommitChangeListModel.getSelectedItem();
        this.myInspectionsPanel.apply();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myInspectionsPanel = new CommitMessageInspectionsPanel(this.myProject);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myInspectionsPanel);
    }

    @NotNull
    private static String getConfirmationOptionText(@NotNull VcsShowConfirmationOption.Value value) {
        if (value == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(5);
        }
        switch (value) {
            case SHOW_CONFIRMATION: {
                if ("Ask" == null) {
                    CommitDialogSettingsPanel.$$$reportNull$$$0(6);
                }
                return "Ask";
            }
            case DO_NOTHING_SILENTLY: {
                if ("No" == null) {
                    CommitDialogSettingsPanel.$$$reportNull$$$0(7);
                }
                return "No";
            }
            case DO_ACTION_SILENTLY: {
                if ("Yes" == null) {
                    CommitDialogSettingsPanel.$$$reportNull$$$0(8);
                }
                return "Yes";
            }
        }
        throw new IllegalArgumentException("Unknown confirmation option " + value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmationOptionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfirmationOptionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myShowUnversionedFiles = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Show unversioned files");
        jPanel.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Commit message inspections", (int)0, (int)0, null, null));
        CommitMessageInspectionsPanel commitMessageInspectionsPanel = this.myInspectionsPanel;
        jPanel2.add((Component)((Object)commitMessageInspectionsPanel), new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myClearInitialCommitMessage = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Clear initial commit message");
        jBCheckBox3.setMnemonic('I');
        jBCheckBox3.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForceNonEmptyCommitMessage = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.force.non.empty.messages"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMoveUncommittedToAnotherChangeList = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.changelist.move.offer"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 2));
        jPanel.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/VcsBundle").getString("create.changelist.on.failed.commit"));
        Component component = jPanel3.add((Component)jBLabel);
        this.myMoveToFailedCommitChangeList = comboBox = new ComboBox();
        Component component2 = jPanel3.add((Component)comboBox);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

