/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.BlockGroupsProcessor;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineTracker;
import com.intellij.openapi.vcs.ex.MergingBlockProcessor;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u0000 -2\u00020\u0001:\u0002,-B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u0017J&\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ>\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0010H\u0002J.\u0010&\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0010J\u001c\u0010'\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010)\u001a\u00020\u0010J\u001a\u0010*\u001a\u00020\u0012*\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J\u001a\u0010+\u001a\u00020\u0012*\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002R0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker;", "", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "originalChanges", "", "Lcom/intellij/diff/util/Range;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;Ljava/util/List;)V", "<set-?>", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "blocks", "getBlocks", "()Ljava/util/List;", "setBlocks", "(Ljava/util/List;)V", "isDirty", "", "destroy", "", "partiallyApplyBlocks", "side", "Lcom/intellij/diff/util/Side;", "condition", "Lkotlin/Function1;", "rangeChanged", "startLine", "", "beforeLength", "afterLength", "refreshBlock", "block", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "fastRefresh", "refreshDirty", "setRanges", "ranges", "dirty", "onRangesAdded", "onRangesRemoved", "BlockChangeData", "Companion", "intellij.platform.diff.impl"})
final class LineTracker {
    @NotNull
    private List<DocumentTracker.Block> blocks;
    private boolean isDirty;
    private final DocumentTracker.Handler handler;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<DocumentTracker.Block> getBlocks() {
        return this.blocks;
    }

    private final void setBlocks(List<DocumentTracker.Block> list2) {
        this.blocks = list2;
    }

    public final void destroy() {
        this.onRangesRemoved(this.handler, this.blocks);
        this.blocks = CollectionsKt.emptyList();
    }

    public final void refreshDirty(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean fastRefresh) {
        Intrinsics.checkParameterIsNotNull((Object)text1, (String)"text1");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text2");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets2, (String)"lineOffsets2");
        if (!this.isDirty) {
            return;
        }
        ArrayList removedBlocks = new ArrayList();
        ArrayList addedBlocks = new ArrayList();
        ArrayList newBlocks = new ArrayList();
        new BlockGroupsProcessor(text1, lineOffsets1).processMergeableGroups(this.blocks, (Function1<? super List<DocumentTracker.Block>, Unit>)((Function1)new Function1<List<? extends DocumentTracker.Block>, Unit>(this, text1, text2, lineOffsets1, lineOffsets2, fastRefresh, removedBlocks, addedBlocks, newBlocks){
            final /* synthetic */ LineTracker this$0;
            final /* synthetic */ CharSequence $text1;
            final /* synthetic */ CharSequence $text2;
            final /* synthetic */ LineOffsets $lineOffsets1;
            final /* synthetic */ LineOffsets $lineOffsets2;
            final /* synthetic */ boolean $fastRefresh;
            final /* synthetic */ ArrayList $removedBlocks;
            final /* synthetic */ ArrayList $addedBlocks;
            final /* synthetic */ ArrayList $newBlocks;

            public final void invoke(@NotNull List<DocumentTracker.Block> group) {
                boolean bl;
                block5: {
                    Intrinsics.checkParameterIsNotNull(group, (String)"group");
                    Iterable $receiver$iv = group;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                            if (!it.isDirty$intellij_platform_diff_impl()) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    new MergingBlockProcessor(LineTracker.access$getHandler$p(this.this$0)).processMergedBlocks(group, (Function2<? super List<DocumentTracker.Block>, ? super DocumentTracker.Block, Unit>)((Function2)new Function2<List<? extends DocumentTracker.Block>, DocumentTracker.Block, Unit>(this){
                        final /* synthetic */ refreshDirty.1 this$0;

                        public final void invoke(@NotNull List<DocumentTracker.Block> original, @NotNull DocumentTracker.Block mergedBlock) {
                            Intrinsics.checkParameterIsNotNull(original, (String)"original");
                            Intrinsics.checkParameterIsNotNull((Object)mergedBlock, (String)"mergedBlock");
                            List freshBlocks = LineTracker.access$refreshBlock(this.this$0.this$0, mergedBlock, this.this$0.$text1, this.this$0.$text2, this.this$0.$lineOffsets1, this.this$0.$lineOffsets2, this.this$0.$fastRefresh);
                            this.this$0.$removedBlocks.addAll((Collection)original);
                            this.this$0.$addedBlocks.addAll(freshBlocks);
                            LineTracker.access$getHandler$p(this.this$0.this$0).onRangeRefreshed(mergedBlock, freshBlocks);
                            this.this$0.$newBlocks.addAll(freshBlocks);
                        }
                        {
                            this.this$0 = var1_1;
                            super(2);
                        }
                    }));
                } else {
                    this.$newBlocks.addAll((Collection)group);
                }
            }
            {
                this.this$0 = lineTracker;
                this.$text1 = charSequence;
                this.$text2 = charSequence2;
                this.$lineOffsets1 = lineOffsets;
                this.$lineOffsets2 = lineOffsets2;
                this.$fastRefresh = bl;
                this.$removedBlocks = arrayList;
                this.$addedBlocks = arrayList2;
                this.$newBlocks = arrayList3;
                super(1);
            }
        }));
        this.onRangesRemoved(this.handler, removedBlocks);
        this.onRangesAdded(this.handler, addedBlocks);
        this.blocks = newBlocks;
        this.isDirty = false;
        this.handler.afterRefresh();
    }

    /*
     * WARNING - void declaration
     */
    public final void rangeChanged(@NotNull Side side, int startLine, int beforeLength, int afterLength) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        BlockChangeData data = LineTracker.Companion.handleRangeChange(this.blocks, side, startLine, beforeLength, afterLength);
        this.handler.onRangesChanged(data.getAffectedBlocks(), data.getNewAffectedBlock());
        int n = 0;
        int n2 = ((Collection)data.getAfterBlocks()).size();
        while (n < n2) {
            void i;
            this.handler.onRangeShifted(data.getAfterBlocks().get((int)i), data.getNewAfterBlocks().get((int)i));
            ++i;
        }
        this.onRangesRemoved(this.handler, data.getAffectedBlocks());
        this.onRangesRemoved(this.handler, data.getAfterBlocks());
        this.handler.onRangeAdded(data.getNewAffectedBlock());
        this.onRangesAdded(this.handler, data.getNewAfterBlocks());
        List list2 = ContainerUtil.concat((List[])new List[]{data.getBeforeBlocks(), CollectionsKt.listOf((Object)data.getNewAffectedBlock()), data.getNewAfterBlocks()});
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.concat(dat\u2026ck), data.newAfterBlocks)");
        this.blocks = list2;
        this.isDirty = true;
        this.handler.afterRangeChange();
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentTracker.Block> refreshBlock(DocumentTracker.Block block, CharSequence text1, CharSequence text2, LineOffsets lineOffsets1, LineOffsets lineOffsets2, boolean fastRefresh) {
        void $receiver$iv$iv;
        Iterable<Range> $receiver$iv;
        boolean isTooBig;
        FairDiffIterable iterable;
        if (block.getRange().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (block.isTooBig$intellij_platform_diff_impl() && fastRefresh) {
            iterable = RangesBuilder.fastCompareLines(block.getRange(), text1, text2, lineOffsets1, lineOffsets2);
            isTooBig = true;
        } else {
            FairDiffIterable realIterable = RangesBuilder.tryCompareLines(block.getRange(), text1, text2, lineOffsets1, lineOffsets2);
            if (realIterable != null) {
                iterable = realIterable;
                isTooBig = false;
            } else {
                iterable = RangesBuilder.fastCompareLines(block.getRange(), text1, text2, lineOffsets1, lineOffsets2);
                isTooBig = true;
            }
        }
        Iterable<Range> iterable2 = iterable.iterateChanges();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, (String)"iterable.iterateChanges()");
        Iterable<Range> iterable3 = $receiver$iv = iterable2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            DocumentTracker.Block block2 = new DocumentTracker.Block(LineTracker.Companion.shiftRange((Range)v1, block.getRange().start1, block.getRange().start2), false, isTooBig);
            collection.add(block2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<DocumentTracker.Block> partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super DocumentTracker.Block, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        List<DocumentTracker.Block> oldBlocks = this.blocks;
        List newBlocks = new ArrayList();
        List appliedBlocks = new ArrayList();
        Companion.processAppliedRanges(this.blocks, condition, side, (Function3<? super DocumentTracker.Block, ? super Integer, ? super Boolean, Unit>)((Function3)new Function3<DocumentTracker.Block, Integer, Boolean, Unit>(this, appliedBlocks, side, newBlocks){
            final /* synthetic */ LineTracker this$0;
            final /* synthetic */ List $appliedBlocks;
            final /* synthetic */ Side $side;
            final /* synthetic */ List $newBlocks;

            public final void invoke(@NotNull DocumentTracker.Block block, int shift, boolean isApplied) {
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                if (isApplied) {
                    Collection collection = this.$appliedBlocks;
                    collection.add(block);
                } else {
                    DocumentTracker.Block newBlock = com.intellij.openapi.vcs.ex.LineTracker$Companion.access$shift(LineTracker.Companion, block, this.$side, shift);
                    LineTracker.access$getHandler$p(this.this$0).onRangeShifted(block, newBlock);
                    this.$newBlocks.add(newBlock);
                }
            }
            {
                this.this$0 = lineTracker;
                this.$appliedBlocks = list2;
                this.$side = side;
                this.$newBlocks = list3;
                super(3);
            }
        }));
        this.onRangesRemoved(this.handler, oldBlocks);
        this.onRangesAdded(this.handler, newBlocks);
        this.blocks = newBlocks;
        this.handler.afterExplicitChange();
        return appliedBlocks;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRanges(@NotNull List<? extends Range> ranges, boolean dirty) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
        List<DocumentTracker.Block> oldBlocks = this.blocks;
        Iterable iterable = $receiver$iv = (Iterable)ranges;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, dirty, false);
            collection.add(block);
        }
        List newBlocks = (List)destination$iv$iv;
        this.onRangesRemoved(this.handler, oldBlocks);
        this.onRangesAdded(this.handler, newBlocks);
        this.blocks = newBlocks;
        if (dirty) {
            this.isDirty = true;
        }
        this.handler.afterExplicitChange();
    }

    private final void onRangesRemoved(@NotNull DocumentTracker.Handler $receiver, List<DocumentTracker.Block> blocks) {
        Iterable $receiver$iv = blocks;
        for (Object element$iv : $receiver$iv) {
            DocumentTracker.Block p1 = (DocumentTracker.Block)element$iv;
            $receiver.onRangeRemoved(p1);
        }
    }

    private final void onRangesAdded(@NotNull DocumentTracker.Handler $receiver, List<DocumentTracker.Block> blocks) {
        Iterable $receiver$iv = blocks;
        for (Object element$iv : $receiver$iv) {
            DocumentTracker.Block p1 = (DocumentTracker.Block)element$iv;
            $receiver.onRangeAdded(p1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public LineTracker(@NotNull DocumentTracker.Handler handler2, @NotNull List<? extends Range> originalChanges) {
        Collection<DocumentTracker.Block> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        Intrinsics.checkParameterIsNotNull(originalChanges, (String)"originalChanges");
        this.handler = handler2;
        Iterable iterable = originalChanges;
        LineTracker lineTracker = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            collection = destination$iv$iv;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, false, false);
            collection.add(block);
        }
        collection = (List)destination$iv$iv;
        lineTracker.blocks = collection;
    }

    @NotNull
    public static final /* synthetic */ DocumentTracker.Handler access$getHandler$p(LineTracker $this) {
        return $this.handler;
    }

    @NotNull
    public static final /* synthetic */ List access$refreshBlock(LineTracker $this, @NotNull DocumentTracker.Block block, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean fastRefresh) {
        return $this.refreshBlock(block, text1, text2, lineOffsets1, lineOffsets2, fastRefresh);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003JS\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker$BlockChangeData;", "", "beforeBlocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "affectedBlocks", "afterBlocks", "newAffectedBlock", "newAfterBlocks", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "getAffectedBlocks", "()Ljava/util/List;", "getAfterBlocks", "getBeforeBlocks", "getNewAffectedBlock", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getNewAfterBlocks", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    private static final class BlockChangeData {
        @NotNull
        private final List<DocumentTracker.Block> beforeBlocks;
        @NotNull
        private final List<DocumentTracker.Block> affectedBlocks;
        @NotNull
        private final List<DocumentTracker.Block> afterBlocks;
        @NotNull
        private final DocumentTracker.Block newAffectedBlock;
        @NotNull
        private final List<DocumentTracker.Block> newAfterBlocks;

        @NotNull
        public final List<DocumentTracker.Block> getBeforeBlocks() {
            return this.beforeBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getAffectedBlocks() {
            return this.affectedBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getAfterBlocks() {
            return this.afterBlocks;
        }

        @NotNull
        public final DocumentTracker.Block getNewAffectedBlock() {
            return this.newAffectedBlock;
        }

        @NotNull
        public final List<DocumentTracker.Block> getNewAfterBlocks() {
            return this.newAfterBlocks;
        }

        public BlockChangeData(@NotNull List<DocumentTracker.Block> beforeBlocks, @NotNull List<DocumentTracker.Block> affectedBlocks, @NotNull List<DocumentTracker.Block> afterBlocks, @NotNull DocumentTracker.Block newAffectedBlock, @NotNull List<DocumentTracker.Block> newAfterBlocks) {
            Intrinsics.checkParameterIsNotNull(beforeBlocks, (String)"beforeBlocks");
            Intrinsics.checkParameterIsNotNull(affectedBlocks, (String)"affectedBlocks");
            Intrinsics.checkParameterIsNotNull(afterBlocks, (String)"afterBlocks");
            Intrinsics.checkParameterIsNotNull((Object)newAffectedBlock, (String)"newAffectedBlock");
            Intrinsics.checkParameterIsNotNull(newAfterBlocks, (String)"newAfterBlocks");
            this.beforeBlocks = beforeBlocks;
            this.affectedBlocks = affectedBlocks;
            this.afterBlocks = afterBlocks;
            this.newAffectedBlock = newAffectedBlock;
            this.newAfterBlocks = newAfterBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component1() {
            return this.beforeBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component2() {
            return this.affectedBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component3() {
            return this.afterBlocks;
        }

        @NotNull
        public final DocumentTracker.Block component4() {
            return this.newAffectedBlock;
        }

        @NotNull
        public final List<DocumentTracker.Block> component5() {
            return this.newAfterBlocks;
        }

        @NotNull
        public final BlockChangeData copy(@NotNull List<DocumentTracker.Block> beforeBlocks, @NotNull List<DocumentTracker.Block> affectedBlocks, @NotNull List<DocumentTracker.Block> afterBlocks, @NotNull DocumentTracker.Block newAffectedBlock, @NotNull List<DocumentTracker.Block> newAfterBlocks) {
            Intrinsics.checkParameterIsNotNull(beforeBlocks, (String)"beforeBlocks");
            Intrinsics.checkParameterIsNotNull(affectedBlocks, (String)"affectedBlocks");
            Intrinsics.checkParameterIsNotNull(afterBlocks, (String)"afterBlocks");
            Intrinsics.checkParameterIsNotNull((Object)newAffectedBlock, (String)"newAffectedBlock");
            Intrinsics.checkParameterIsNotNull(newAfterBlocks, (String)"newAfterBlocks");
            return new BlockChangeData(beforeBlocks, affectedBlocks, afterBlocks, newAffectedBlock, newAfterBlocks);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ BlockChangeData copy$default(BlockChangeData blockChangeData, List list2, List list3, List list4, DocumentTracker.Block block, List list5, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = blockChangeData.beforeBlocks;
            }
            if ((n & 2) != 0) {
                list3 = blockChangeData.affectedBlocks;
            }
            if ((n & 4) != 0) {
                list4 = blockChangeData.afterBlocks;
            }
            if ((n & 8) != 0) {
                block = blockChangeData.newAffectedBlock;
            }
            if ((n & 0x10) != 0) {
                list5 = blockChangeData.newAfterBlocks;
            }
            return blockChangeData.copy(list2, list3, list4, block, list5);
        }

        public String toString() {
            return "BlockChangeData(beforeBlocks=" + this.beforeBlocks + ", affectedBlocks=" + this.affectedBlocks + ", afterBlocks=" + this.afterBlocks + ", newAffectedBlock=" + this.newAffectedBlock + ", newAfterBlocks=" + this.newAfterBlocks + ")";
        }

        public int hashCode() {
            List<DocumentTracker.Block> list2 = this.beforeBlocks;
            List<DocumentTracker.Block> list3 = this.affectedBlocks;
            List<DocumentTracker.Block> list4 = this.afterBlocks;
            DocumentTracker.Block block = this.newAffectedBlock;
            List<DocumentTracker.Block> list5 = this.newAfterBlocks;
            return ((((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0)) * 31 + (block != null ? block.hashCode() : 0)) * 31 + (list5 != null ? ((Object)list5).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BlockChangeData)) break block3;
                    BlockChangeData blockChangeData = (BlockChangeData)object;
                    if (!Intrinsics.areEqual(this.beforeBlocks, blockChangeData.beforeBlocks) || !Intrinsics.areEqual(this.affectedBlocks, blockChangeData.affectedBlocks) || !Intrinsics.areEqual(this.afterBlocks, blockChangeData.afterBlocks) || !Intrinsics.areEqual((Object)this.newAffectedBlock, (Object)blockChangeData.newAffectedBlock) || !Intrinsics.areEqual(this.newAfterBlocks, blockChangeData.newAfterBlocks)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J>\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J6\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002J}\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0005\u001a\u00020\u00062K\u0010 \u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u001c0!J \u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\bH\u0002J \u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0002JR\u0010+\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00130,2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\bH\u0002J\u001c\u0010%\u001a\u00020\r*\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\bH\u0002\u00a8\u00060"}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker$Companion;", "", "()V", "createRange", "Lcom/intellij/diff/util/Range;", "side", "Lcom/intellij/diff/util/Side;", "start", "", "end", "otherStart", "otherEnd", "getNewAffectedBlock", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "startLine", "endLine", "rangeSizeDelta", "ourToOtherShift", "affectedBlocks", "", "getOurToOtherShift", "beforeBlocks", "handleRangeChange", "Lcom/intellij/openapi/vcs/ex/LineTracker$BlockChangeData;", "blocks", "beforeLength", "afterLength", "processAppliedRanges", "", "condition", "Lkotlin/Function1;", "", "handler", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "block", "shift", "isApplied", "shiftRange", "range", "shift1", "shift2", "sortRanges", "Lkotlin/Triple;", "line1", "line2", "delta", "intellij.platform.diff.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final BlockChangeData handleRangeChange(List<DocumentTracker.Block> blocks, Side side, int startLine, int beforeLength, int afterLength) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            void affectedBlocks;
            void beforeBlocks;
            int endLine = startLine + beforeLength;
            int rangeSizeDelta = afterLength - beforeLength;
            Triple<List<DocumentTracker.Block>, List<DocumentTracker.Block>, List<DocumentTracker.Block>> triple = this.sortRanges(blocks, side, startLine, endLine);
            List list2 = (List)triple.component1();
            List list3 = (List)triple.component2();
            List afterBlocks = (List)triple.component3();
            int ourToOtherShift = this.getOurToOtherShift(side, (List<DocumentTracker.Block>)beforeBlocks);
            DocumentTracker.Block newAffectedBlock = this.getNewAffectedBlock(side, startLine, endLine, rangeSizeDelta, ourToOtherShift, (List<DocumentTracker.Block>)affectedBlocks);
            Iterable iterable = $receiver$iv = (Iterable)afterBlocks;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                DocumentTracker.Block block = (DocumentTracker.Block)item$iv$iv;
                Collection collection = destination$iv$iv;
                DocumentTracker.Block block2 = Companion.shift((DocumentTracker.Block)it, side, rangeSizeDelta);
                collection.add(block2);
            }
            List newAfterBlocks = (List)destination$iv$iv;
            return new BlockChangeData((List<DocumentTracker.Block>)beforeBlocks, (List<DocumentTracker.Block>)affectedBlocks, afterBlocks, newAffectedBlock, newAfterBlocks);
        }

        private final Triple<List<DocumentTracker.Block>, List<DocumentTracker.Block>, List<DocumentTracker.Block>> sortRanges(List<DocumentTracker.Block> blocks, Side side, int line1, int line2) {
            ArrayList<DocumentTracker.Block> beforeChange = new ArrayList<DocumentTracker.Block>();
            ArrayList<DocumentTracker.Block> affected = new ArrayList<DocumentTracker.Block>();
            ArrayList<DocumentTracker.Block> afterChange = new ArrayList<DocumentTracker.Block>();
            for (DocumentTracker.Block block : blocks) {
                if (RangesBuilder.end(block.getRange(), side) < line1) {
                    beforeChange.add(block);
                    continue;
                }
                if (RangesBuilder.start(block.getRange(), side) > line2) {
                    afterChange.add(block);
                    continue;
                }
                affected.add(block);
            }
            return new Triple(beforeChange, affected, afterChange);
        }

        private final int getOurToOtherShift(Side side, List<DocumentTracker.Block> beforeBlocks) {
            int otherShift;
            Range lastBefore;
            DocumentTracker.Block block = (DocumentTracker.Block)CollectionsKt.lastOrNull(beforeBlocks);
            Object object = lastBefore = block != null ? block.getRange() : null;
            if (lastBefore == null) {
                otherShift = 0;
            } else {
                Side side2 = side.other();
                Intrinsics.checkExpressionValueIsNotNull((Object)side2, (String)"side.other()");
                otherShift = RangesBuilder.end(lastBefore, side2) - RangesBuilder.end(lastBefore, side);
            }
            return otherShift;
        }

        private final DocumentTracker.Block getNewAffectedBlock(Side side, int startLine, int endLine, int rangeSizeDelta, int ourToOtherShift, List<DocumentTracker.Block> affectedBlocks) {
            boolean bl;
            int rangeEndOther;
            int rangeStartOther;
            int rangeEnd;
            int rangeStart;
            block9: {
                if (affectedBlocks.isEmpty()) {
                    rangeStart = startLine;
                    rangeEnd = endLine + rangeSizeDelta;
                    rangeStartOther = startLine + ourToOtherShift;
                    rangeEndOther = endLine + ourToOtherShift;
                } else {
                    Range firstAffected = ((DocumentTracker.Block)CollectionsKt.first(affectedBlocks)).getRange();
                    Range lastAffected = ((DocumentTracker.Block)CollectionsKt.last(affectedBlocks)).getRange();
                    int affectedStart = RangesBuilder.start(firstAffected, side);
                    Side side2 = side.other();
                    Intrinsics.checkExpressionValueIsNotNull((Object)side2, (String)"side.other()");
                    int affectedStartOther = RangesBuilder.start(firstAffected, side2);
                    int affectedEnd = RangesBuilder.end(lastAffected, side);
                    Side side3 = side.other();
                    Intrinsics.checkExpressionValueIsNotNull((Object)side3, (String)"side.other()");
                    int affectedEndOther = RangesBuilder.end(lastAffected, side3);
                    if (affectedStart <= startLine) {
                        rangeStart = affectedStart;
                        rangeStartOther = affectedStartOther;
                    } else {
                        rangeStart = startLine;
                        rangeStartOther = startLine + (affectedStartOther - affectedStart);
                    }
                    if (affectedEnd >= endLine) {
                        rangeEnd = affectedEnd + rangeSizeDelta;
                        rangeEndOther = affectedEndOther;
                    } else {
                        rangeEnd = endLine + rangeSizeDelta;
                        rangeEndOther = endLine + (affectedEndOther - affectedEnd);
                    }
                }
                Iterable $receiver$iv = affectedBlocks;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                        if (!it.isTooBig$intellij_platform_diff_impl()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            boolean isTooBig = bl;
            Range range2 = this.createRange(side, rangeStart, rangeEnd, rangeStartOther, rangeEndOther);
            return new DocumentTracker.Block(range2, true, isTooBig);
        }

        public final void processAppliedRanges(@NotNull List<DocumentTracker.Block> blocks, @NotNull Function1<? super DocumentTracker.Block, Boolean> condition, @NotNull Side side, @NotNull Function3<? super DocumentTracker.Block, ? super Integer, ? super Boolean, Unit> handler2) {
            Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
            Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
            Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
            Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
            Side otherSide = side.other();
            int shift = 0;
            for (DocumentTracker.Block block : blocks) {
                if (((Boolean)condition.invoke((Object)block)).booleanValue()) {
                    handler2.invoke((Object)block, (Object)shift, (Object)true);
                    int deleted = RangesBuilder.end(block.getRange(), side) - RangesBuilder.start(block.getRange(), side);
                    Range range2 = block.getRange();
                    Side side2 = otherSide;
                    Intrinsics.checkExpressionValueIsNotNull((Object)side2, (String)"otherSide");
                    int inserted = RangesBuilder.end(range2, side2) - RangesBuilder.start(block.getRange(), otherSide);
                    shift += inserted - deleted;
                    continue;
                }
                handler2.invoke((Object)block, (Object)shift, (Object)false);
            }
        }

        private final DocumentTracker.Block shift(@NotNull DocumentTracker.Block $receiver, Side side, int delta) {
            return new DocumentTracker.Block(this.shiftRange($receiver.getRange(), side, delta), $receiver.isDirty$intellij_platform_diff_impl(), $receiver.isTooBig$intellij_platform_diff_impl());
        }

        private final Range createRange(Side side, int start, int end, int otherStart, int otherEnd) {
            return new Range(((Number)RangesBuilder.get(side, start, otherStart)).intValue(), ((Number)RangesBuilder.get(side, end, otherEnd)).intValue(), ((Number)RangesBuilder.get(side, otherStart, start)).intValue(), ((Number)RangesBuilder.get(side, otherEnd, end)).intValue());
        }

        private final Range shiftRange(Range range2, Side side, int shift) {
            return this.shiftRange(range2, ((Number)RangesBuilder.get(side, shift, 0)).intValue(), ((Number)RangesBuilder.get(side, 0, shift)).intValue());
        }

        private final Range shiftRange(Range range2, int shift1, int shift2) {
            return new Range(range2.start1 + shift1, range2.end1 + shift1, range2.start2 + shift2, range2.end2 + shift2);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ DocumentTracker.Block access$shift(Companion $this, @NotNull DocumentTracker.Block $receiver, @NotNull Side side, int delta) {
            return $this.shift($receiver, side, delta);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

