/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.WaitForProgressToShow;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryUtil {
    @Deprecated
    public static final Key<Pair<FilePath, VcsRevisionNumber>> REVISION_INFO_KEY = DiffUserDataKeysEx.REVISION_INFO;
    private static final Logger LOG = Logger.getInstance(VcsHistoryUtil.class);

    private VcsHistoryUtil() {
    }

    public static int compare(VcsFileRevision first, VcsFileRevision second) {
        if (first instanceof CurrentRevision && second instanceof CurrentRevision) {
            return VcsHistoryUtil.compareNumbers(first, second);
        }
        if (second instanceof CurrentRevision) {
            return -1 * VcsHistoryUtil.compare(second, first);
        }
        if (first instanceof CurrentRevision) {
            int result2 = VcsHistoryUtil.compareNumbers(first, second);
            if (result2 == 0) {
                return 1;
            }
            return result2;
        }
        return VcsHistoryUtil.compareNumbers(first, second);
    }

    public static int compareNumbers(VcsFileRevision first, VcsFileRevision second) {
        return first.getRevisionNumber().compareTo((Object)second.getRevisionNumber());
    }

    public static void showDiff(@NotNull Project project, @NotNull FilePath path, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2, @NotNull String title1, @NotNull String title2) throws VcsException, IOException {
        if (project == null) {
            VcsHistoryUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VcsHistoryUtil.$$$reportNull$$$0(1);
        }
        if (revision1 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(2);
        }
        if (revision2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(3);
        }
        if (title1 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            VcsHistoryUtil.$$$reportNull$$$0(5);
        }
        byte[] content1 = VcsHistoryUtil.loadRevisionContent(revision1);
        byte[] content2 = VcsHistoryUtil.loadRevisionContent(revision2);
        FilePath path1 = VcsHistoryUtil.getRevisionPath(revision1);
        FilePath path2 = VcsHistoryUtil.getRevisionPath(revision2);
        String title = path1 != null && path2 != null ? DiffRequestFactoryImpl.getTitle(path1, path2, " -> ") : DiffRequestFactoryImpl.getContentTitle(path);
        DiffContent diffContent1 = VcsHistoryUtil.createContent(project, content1, revision1, path);
        DiffContent diffContent2 = VcsHistoryUtil.createContent(project, content2, revision2, path);
        SimpleDiffRequest request = new SimpleDiffRequest(title, diffContent1, diffContent2, title1, title2);
        diffContent1.putUserData(DiffUserDataKeysEx.REVISION_INFO, VcsHistoryUtil.getRevisionInfo(revision1));
        diffContent2.putUserData(DiffUserDataKeysEx.REVISION_INFO, VcsHistoryUtil.getRevisionInfo(revision2));
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> VcsHistoryUtil.lambda$showDiff$0(project, (DiffRequest)request), null, (Project)project);
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getRevisionInfo(@NotNull VcsFileRevision revision) {
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(6);
        }
        if (revision instanceof VcsFileRevisionEx) {
            return Pair.create((Object)((VcsFileRevisionEx)revision).getPath(), (Object)revision.getRevisionNumber());
        }
        return null;
    }

    @Nullable
    private static FilePath getRevisionPath(@NotNull VcsFileRevision revision) {
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(7);
        }
        if (revision instanceof VcsFileRevisionEx) {
            return ((VcsFileRevisionEx)revision).getPath();
        }
        return null;
    }

    @NotNull
    public static byte[] loadRevisionContent(@NotNull VcsFileRevision revision) throws VcsException, IOException {
        byte[] content;
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(8);
        }
        if ((content = revision.getContent()) == null) {
            revision.loadContent();
            content = revision.getContent();
        }
        if (content == null) {
            throw new VcsException("Failed to load content for revision " + revision.getRevisionNumber().asString());
        }
        if (content == null) {
            VcsHistoryUtil.$$$reportNull$$$0(9);
        }
        return content;
    }

    public static String loadRevisionContentGuessEncoding(@NotNull VcsFileRevision revision, @Nullable VirtualFile file2, @Nullable Project project) throws VcsException, IOException {
        EncodingProjectManager e;
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(10);
        }
        byte[] bytes = VcsHistoryUtil.loadRevisionContent(revision);
        if (file2 != null) {
            return new String(bytes, file2.getCharset());
        }
        EncodingProjectManager encodingProjectManager = e = project != null ? EncodingProjectManager.getInstance((Project)project) : null;
        if (e == null) {
            e = EncodingManager.getInstance();
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)e.getDefaultCharset());
    }

    @NotNull
    private static DiffContent createContent(@NotNull Project project, @NotNull byte[] content, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) throws IOException {
        VirtualFile file2;
        if (project == null) {
            VcsHistoryUtil.$$$reportNull$$$0(11);
        }
        if (content == null) {
            VcsHistoryUtil.$$$reportNull$$$0(12);
        }
        if (revision == null) {
            VcsHistoryUtil.$$$reportNull$$$0(13);
        }
        if (filePath == null) {
            VcsHistoryUtil.$$$reportNull$$$0(14);
        }
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        if (VcsHistoryUtil.isCurrent(revision) && (file2 = filePath.getVirtualFile()) != null) {
            DiffContent diffContent = contentFactory.create(project, file2);
            if (diffContent == null) {
                VcsHistoryUtil.$$$reportNull$$$0(15);
            }
            return diffContent;
        }
        if (VcsHistoryUtil.isEmpty(revision)) {
            EmptyContent emptyContent = contentFactory.createEmpty();
            if (emptyContent == null) {
                VcsHistoryUtil.$$$reportNull$$$0(16);
            }
            return emptyContent;
        }
        DiffContent diffContent = contentFactory.createFromBytes(project, content, filePath);
        if (diffContent == null) {
            VcsHistoryUtil.$$$reportNull$$$0(17);
        }
        return diffContent;
    }

    private static boolean isCurrent(VcsFileRevision revision) {
        return revision instanceof CurrentRevision;
    }

    public static boolean isEmpty(VcsFileRevision revision) {
        return revision == null || VcsFileRevision.NULL.equals(revision);
    }

    public static void showDifferencesInBackground(final @NotNull Project project, final @NotNull FilePath filePath, final @NotNull VcsFileRevision older, final @NotNull VcsFileRevision newer) {
        if (project == null) {
            VcsHistoryUtil.$$$reportNull$$$0(18);
        }
        if (filePath == null) {
            VcsHistoryUtil.$$$reportNull$$$0(19);
        }
        if (older == null) {
            VcsHistoryUtil.$$$reportNull$$$0(20);
        }
        if (newer == null) {
            VcsHistoryUtil.$$$reportNull$$$0(21);
        }
        new Task.Backgroundable(project, "Comparing Revisions..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    VcsHistoryUtil.showDiff(project, filePath, older, newer, this.makeTitle(older), this.makeTitle(newer));
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.show.differences", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.show.differences", (Object[])new Object[0])), null, (Project)project);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }

            @NotNull
            private String makeTitle(@NotNull VcsFileRevision revision) {
                if (revision == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = revision.getRevisionNumber().asString() + (revision instanceof CurrentRevision ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "revision";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/history/VcsHistoryUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/history/VcsHistoryUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "makeTitle";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.queue();
    }

    private static /* synthetic */ void lambda$showDiff$0(@NotNull Project project, DiffRequest request) {
        if (project == null) {
            VcsHistoryUtil.$$$reportNull$$$0(22);
        }
        DiffManager.getInstance().showDiff(project, request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title2";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsHistoryUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "older";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsHistoryUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisionContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionContent";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionContentGuessEncoding";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showDifferencesInBackground";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDiff$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

