/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsPresentationUtil {
    @NotNull
    public static String getPresentableNameForAction(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            VfsPresentationUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VfsPresentationUtil.$$$reportNull$$$0(1);
        }
        String string = StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)VfsPresentationUtil.getPresentableNameForUI(project, file2), (int)20));
        if (string == null) {
            VfsPresentationUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getPresentableNameForUI(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            VfsPresentationUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            VfsPresentationUtil.$$$reportNull$$$0(4);
        }
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness(Extensions.getExtensions(EditorTabTitleProvider.EP_NAME));
        for (EditorTabTitleProvider provider : providers) {
            String result2 = provider.getEditorTabTitle(project, file2);
            if (result2 == null) continue;
            String string = result2;
            if (string == null) {
                VfsPresentationUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = file2.getPresentableName();
        if (string == null) {
            VfsPresentationUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getUniquePresentableNameForUI(@NotNull Project project, @NotNull VirtualFile file2) {
        String name;
        if (project == null) {
            VfsPresentationUtil.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            VfsPresentationUtil.$$$reportNull$$$0(8);
        }
        if ((name = VfsPresentationUtil.getPresentableNameForUI(project, file2)).equals(file2.getPresentableName())) {
            String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file2);
            if (string == null) {
                VfsPresentationUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            VfsPresentationUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static Color getFileTabBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            VfsPresentationUtil.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            VfsPresentationUtil.$$$reportNull$$$0(12);
        }
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness(Extensions.getExtensions(EditorTabColorProvider.EP_NAME));
        for (EditorTabColorProvider provider : providers) {
            Color result2 = provider.getEditorTabColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Color getFileBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            VfsPresentationUtil.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            VfsPresentationUtil.$$$reportNull$$$0(14);
        }
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness(Extensions.getExtensions(EditorTabColorProvider.EP_NAME));
        for (EditorTabColorProvider provider : providers) {
            Color result2 = provider.getProjectViewColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/VfsPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/VfsPresentationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameForAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameForUI";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniquePresentableNameForUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameForAction";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameForUI";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUniquePresentableNameForUI";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileTabBackgroundColor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileBackgroundColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

