/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.status.EncodingPanel;
import com.intellij.openapi.wm.impl.status.InsertOverwritePanel;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Field;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.PowerSupplyKit;

public class IdeFrameImpl
extends JFrame
implements IdeFrameEx,
AccessibleContextAccessor,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeFrameImpl");
    public static final Key<Boolean> SHOULD_OPEN_IN_FULL_SCREEN = Key.create((String)"should.open.in.full.screen");
    private static boolean ourUpdatingTitle;
    private String myTitle;
    private String myFileTitle;
    private File myCurrentFile;
    private Project myProject;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;
    private IdeFrameDecorator myFrameDecorator;
    private boolean myRestoreFullScreen;
    private final LafManagerListener myLafListener;
    private static final ShadowPainter ourShadowPainter;

    public IdeFrameImpl(ActionManagerEx actionManager, DataManager dataManager, Application application) {
        super(ApplicationNamesInfo.getInstance().getFullProductName());
        this.myRootPane = this.createRootPane(actionManager, dataManager, application);
        this.setRootPane(this.myRootPane);
        this.setBackground(UIUtil.getPanelBackground());
        this.myLafListener = src -> this.setBackground(UIUtil.getPanelBackground());
        LafManager.getInstance().addLafManagerListener(this.myLafListener);
        AppUIUtil.updateWindowIcon(this);
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = Math.min(1400, size.width - 20);
        size.height = Math.min(1000, size.height - 40);
        this.setSize(size);
        this.setLocationRelativeTo(null);
        if (Registry.is((String)"suppress.focus.stealing") && !ApplicationManagerEx.getApplicationEx().isActive()) {
            this.setAutoRequestFocus(false);
        }
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                JComponent component;
                EditorWithProviderComposite editor;
                EditorWindow window;
                FileEditorManagerEx fileEditorManagerEx;
                if (IdeFrameImpl.this.myProject != null && (fileEditorManagerEx = FileEditorManagerEx.getInstanceEx(IdeFrameImpl.this.myProject)) != null && (window = fileEditorManagerEx.getCurrentWindow()) != null && (editor = window.getSelectedEditor()) != null && (component = editor.getPreferredFocusedComponent()) != null) {
                    return component;
                }
                return super.getComponentAfter(focusCycleRoot, aComponent);
            }
        });
        this.setupCloseAction();
        MnemonicHelper.init((Component)this);
        this.myBalloonLayout = new BalloonLayoutImpl(this.myRootPane, (Insets)JBUI.insets((int)8));
        if (SystemInfo.isMac) {
            this.setIconImage(null);
        }
        MouseGestureManager.getInstance().add(this);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this);
        IdeMenuBar.installAppMenuIfNeeded(this);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

            @Override
            protected Component getDefaultComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getDefaultComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getFirstComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getFirstComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getLastComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getLastComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getComponentAfterImpl(Container focusCycleRoot, Component aComponent) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getComponentAfterImpl(focusCycleRoot, aComponent) : component;
            }

            @Override
            public Component getInitialComponent(Window window) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getInitialComponent(window) : component;
            }

            @Override
            protected Component getComponentBeforeImpl(Container focusCycleRoot, Component aComponent) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getComponentBeforeImpl(focusCycleRoot, aComponent) : component;
            }
        });
    }

    private Component findNextFocusComponent() {
        if (this.myProject != null) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
            if (focusOwner instanceof EditorComponentImpl) {
                String toolWindowId = toolWindowManagerEx.getLastActiveToolWindowId();
                ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(toolWindowId);
                if (toolWindow != null) {
                    return toolWindow.getComponent().getFocusTraversalPolicy().getDefaultComponent(toolWindow.getComponent());
                }
            } else {
                JComponent preferredFocusedComponent;
                EditorWithProviderComposite selectedEditor;
                EditorWindow currentWindow = FileEditorManagerEx.getInstanceEx(this.myProject).getSplitters().getCurrentWindow();
                if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && (preferredFocusedComponent = selectedEditor.getPreferredFocusedComponent()) != null) {
                    return preferredFocusedComponent;
                }
            }
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        PowerSupplyKit.checkPowerSupply();
    }

    protected IdeRootPane createRootPane(ActionManagerEx actionManager, DataManager dataManager, Application application) {
        return new IdeRootPane(actionManager, dataManager, application, this);
    }

    @Override
    @NotNull
    public Insets getInsets() {
        Insets insets = SystemInfo.isMac && this.isInFullScreen() ? JBUI.emptyInsets() : super.getInsets();
        if (insets == null) {
            IdeFrameImpl.$$$reportNull$$$0(0);
        }
        return insets;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    @Nullable
    public static Window getActiveFrame() {
        for (Frame frame : IdeFrameImpl.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(() -> this.setFocusableWindowState(true));
    }

    @Override
    public synchronized void setMaximizedBounds(Rectangle bounds) {
        super.setMaximizedBounds(null);
    }

    private void setupCloseAction() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (IdeFrameImpl.this.isTemporaryDisposed()) {
                    return;
                }
                Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                if (openProjects.length > 1 || openProjects.length == 1 && SystemInfo.isMacSystemMenu) {
                    if (IdeFrameImpl.this.myProject != null && IdeFrameImpl.this.myProject.isOpen()) {
                        ProjectUtil.closeAndDispose(IdeFrameImpl.this.myProject);
                    }
                    ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectFrameClosed();
                    WelcomeFrame.showIfNoProjectOpened();
                } else {
                    ApplicationManagerEx.getApplicationEx().exit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/IdeFrameImpl$3", "windowClosing"));
            }
        });
    }

    public StatusBar getStatusBar() {
        return this.myRootPane == null ? null : this.myRootPane.getStatusBar();
    }

    @Override
    public void setTitle(String title) {
        if (ourUpdatingTitle) {
            super.setTitle(title);
        } else {
            this.myTitle = title;
        }
        this.updateTitle();
    }

    public void setFrameTitle(String text) {
        super.setTitle(text);
    }

    public void setFileTitle(@Nullable String fileTitle, @Nullable File file2) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file2;
        this.updateTitle();
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return this.myRootPane.findByName(key);
    }

    private void updateTitle() {
        IdeFrameImpl.updateTitle(this, this.myTitle, this.myFileTitle, this.myCurrentFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTitle(@NotNull JFrame frame, @Nullable String title, @Nullable String fileTitle, @Nullable File currentFile) {
        if (frame == null) {
            IdeFrameImpl.$$$reportNull$$$0(1);
        }
        if (ourUpdatingTitle) {
            return;
        }
        try {
            ourUpdatingTitle = true;
            frame.getRootPane().putClientProperty("Window.documentFile", currentFile);
            Builder builder = new Builder().append(title).append(fileTitle);
            if (Boolean.getBoolean("ide.ui.version.in.title")) {
                builder = builder.append(ApplicationNamesInfo.getInstance().getFullProductName() + ' ' + ApplicationInfo.getInstance().getFullVersion());
            } else if (!SystemInfo.isMac || builder.isEmpty()) {
                builder = builder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            }
            frame.setTitle(builder.toString());
        }
        finally {
            ourUpdatingTitle = false;
        }
    }

    public void updateView() {
        ((IdeRootPane)this.getRootPane()).updateToolbar();
        ((IdeRootPane)this.getRootPane()).updateMainMenuActions();
        ((IdeRootPane)this.getRootPane()).updateNorthComponents();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        if (IdeFrame.KEY.getName().equals(dataId)) {
            return this;
        }
        return null;
    }

    public void setProject(@Nullable Project project) {
        if (this.myProject == project) {
            return;
        }
        this.myProject = project;
        if (project != null) {
            if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS()) {
                boolean bl = this.myRestoreFullScreen = SHOULD_OPEN_IN_FULL_SCREEN.get((UserDataHolder)project) == Boolean.TRUE || ProjectFrameBounds.getInstance(project).isInFullScreen();
                if (!this.myRestoreFullScreen && PropertiesComponent.getInstance((Project)project).getBoolean("FullScreen")) {
                    this.myRestoreFullScreen = true;
                    PropertiesComponent.getInstance((Project)project).unsetValue("FullScreen");
                }
            }
            if (this.myRootPane != null) {
                this.myRootPane.installNorthComponents(project);
                StatusBar statusBar = this.myRootPane.getStatusBar();
                if (statusBar != null) {
                    project.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)statusBar);
                }
            }
            this.installDefaultProjectStatusBarWidgets(this.myProject);
        } else if (this.myRootPane != null) {
            this.myRootPane.deinstallNorthComponents();
        }
        if (this.myRestoreFullScreen && this.isVisible()) {
            this.toggleFullScreen(true);
            this.myRestoreFullScreen = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.myRestoreFullScreen) {
            SwingUtilities.invokeLater(() -> {
                this.toggleFullScreen(true);
                if (SystemInfo.isMacOSLion) {
                    this.setBounds(ScreenUtil.getScreenRectangle((Point)this.getLocationOnScreen()));
                }
                this.myRestoreFullScreen = false;
            });
        }
    }

    private void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            IdeFrameImpl.$$$reportNull$$$0(2);
        }
        StatusBar statusBar = this.getStatusBar();
        PositionPanel positionPanel = new PositionPanel(project);
        statusBar.addWidget((StatusBarWidget)positionPanel, "before FatalError");
        IdeNotificationArea notificationArea = new IdeNotificationArea();
        statusBar.addWidget((StatusBarWidget)notificationArea, "before FatalError");
        EncodingPanel encodingPanel = new EncodingPanel(project);
        statusBar.addWidget((StatusBarWidget)encodingPanel, "after Position");
        LineSeparatorPanel lineSeparatorPanel = new LineSeparatorPanel(project);
        statusBar.addWidget((StatusBarWidget)lineSeparatorPanel, "before " + encodingPanel.ID());
        ToggleReadOnlyAttributePanel readOnlyAttributePanel = new ToggleReadOnlyAttributePanel(project);
        InsertOverwritePanel insertOverwritePanel = new InsertOverwritePanel(project);
        statusBar.addWidget((StatusBarWidget)insertOverwritePanel, "after Encoding");
        statusBar.addWidget((StatusBarWidget)readOnlyAttributePanel, "after InsertOverwrite");
        Disposer.register((Disposable)project, () -> {
            statusBar.removeWidget(encodingPanel.ID());
            statusBar.removeWidget(lineSeparatorPanel.ID());
            statusBar.removeWidget(positionPanel.ID());
            statusBar.removeWidget(notificationArea.ID());
            statusBar.removeWidget(readOnlyAttributePanel.ID());
            statusBar.removeWidget(insertOverwritePanel.ID());
            ((StatusBarEx)statusBar).removeCustomIndicationComponents();
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void dispose() {
        if (SystemInfo.isMac && this.isInFullScreen()) {
            ((MacMainFrameDecorator)this.myFrameDecorator).toggleFullScreenNow();
        }
        if (this.isTemporaryDisposed()) {
            super.dispose();
            return;
        }
        MouseGestureManager.getInstance().remove(this);
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        if (this.myRootPane != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myRootPane.removeNotify();
            }
            this.setRootPane(new JRootPane());
            Disposer.dispose((Disposable)this.myRootPane);
            this.myRootPane = null;
        }
        if (this.myFrameDecorator != null) {
            Disposer.dispose((Disposable)this.myFrameDecorator);
            this.myFrameDecorator = null;
        }
        if (this.myLafListener != null) {
            LafManager.getInstance().removeLafManagerListener(this.myLafListener);
        }
        super.dispose();
    }

    private boolean isTemporaryDisposed() {
        return this.myRootPane != null && this.myRootPane.getClientProperty("dispose.temporary") != null;
    }

    public void storeFullScreenStateIfNeeded() {
        if (this.myProject != null) {
            this.doLayout();
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            IdeFrameImpl.$$$reportNull$$$0(3);
        }
        UISettings.setupAntialiasing((Graphics)g);
        super.paint(g);
        if (IdeRootPane.isFrameDecorated() && !this.isInFullScreen()) {
            BufferedImage shadow = ourShadowPainter.createShadow(this.getRootPane(), this.getWidth(), this.getHeight());
            g.drawImage(shadow, 0, 0, null);
        }
    }

    @Override
    public Color getBackground() {
        return IdeRootPane.isFrameDecorated() ? Gray.x00.withAlpha(0) : super.getBackground();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.isInFullScreen() && IdeRootPane.isFrameDecorated()) {
            int leftSide = AllIcons.Windows.Shadow.Left.getIconWidth();
            int rightSide = AllIcons.Windows.Shadow.Right.getIconWidth();
            int top = AllIcons.Windows.Shadow.Top.getIconHeight();
            int bottom = AllIcons.Windows.Shadow.Bottom.getIconHeight();
            this.getRootPane().setBounds(leftSide, top, this.getWidth() - leftSide - rightSide, this.getHeight() - top - bottom);
        }
    }

    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        return b;
    }

    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @Override
    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    @NotNull
    public ActionCallback toggleFullScreen(boolean state) {
        if (this.temporaryFixForIdea156004(state)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                IdeFrameImpl.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }
        if (this.myFrameDecorator != null) {
            ActionCallback actionCallback = this.myFrameDecorator.toggleFullScreen(state);
            if (actionCallback == null) {
                IdeFrameImpl.$$$reportNull$$$0(5);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            IdeFrameImpl.$$$reportNull$$$0(6);
        }
        return actionCallback;
    }

    private boolean temporaryFixForIdea156004(boolean state) {
        if (SystemInfo.isMac) {
            try {
                Field modalBlockerField = Window.class.getDeclaredField("modalBlocker");
                modalBlockerField.setAccessible(true);
                Window modalBlocker = (Window)modalBlockerField.get(this);
                if (modalBlocker != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.toggleFullScreen(state), ModalityState.NON_MODAL);
                    return true;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeFrameImpl();
        }
        return this.accessibleContext;
    }

    static {
        ourShadowPainter = new ShadowPainter(AllIcons.Windows.Shadow.Top, AllIcons.Windows.Shadow.TopRight, AllIcons.Windows.Shadow.Right, AllIcons.Windows.Shadow.BottomRight, AllIcons.Windows.Shadow.Bottom, AllIcons.Windows.Shadow.BottomLeft, AllIcons.Windows.Shadow.Left, AllIcons.Windows.Shadow.TopLeft);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsets";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultProjectStatusBarWidgets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleIdeFrameImpl
    extends JFrame.AccessibleJFrame {
        protected AccessibleIdeFrameImpl() {
            super(IdeFrameImpl.this);
        }

        @Override
        public String getAccessibleName() {
            StringBuilder builder = new StringBuilder();
            if (IdeFrameImpl.this.myProject != null) {
                builder.append(IdeFrameImpl.this.myProject.getName());
                builder.append(" - ");
            }
            builder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            return builder.toString();
        }
    }

    private static final class Builder {
        private final StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        public Builder append(@Nullable String s) {
            if (!StringUtil.isEmptyOrSpaces((String)s)) {
                if (this.sb.length() > 0) {
                    this.sb.append(" - ");
                }
                this.sb.append(s);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.sb.length() == 0;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

