/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class RequestFocusInToolWindowCmd
extends FinalizableCommand {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd");
    private final ToolWindowImpl myToolWindow;
    private final FocusWatcher myFocusWatcher;
    private final Project myProject;

    public RequestFocusInToolWindowCmd(IdeFocusManager focusManager, ToolWindowImpl toolWindow, FocusWatcher focusWatcher, Runnable finishCallBack, Project project) {
        super(finishCallBack);
        this.myToolWindow = toolWindow;
        this.myFocusWatcher = focusWatcher;
        this.myProject = project;
    }

    @Override
    public final void run() {
        this.myToolWindow.getActivation().doWhenDone(() -> this.processRequestFocus());
    }

    private void processRequestFocus() {
        try {
            Component preferredFocusedComponent;
            Component component = preferredFocusedComponent = this.myToolWindow.isUseLastFocusedOnActivation() ? this.myFocusWatcher.getFocusedComponent() : null;
            if (preferredFocusedComponent == null && this.myToolWindow.getContentManager().getSelectedContent() != null && (preferredFocusedComponent = this.myToolWindow.getContentManager().getSelectedContent().getPreferredFocusableComponent()) != null) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent == null && (preferredFocusedComponent = this.myFocusWatcher.getNearestFocusableComponent()) instanceof JComponent) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent != null && !preferredFocusedComponent.isShowing()) {
                preferredFocusedComponent = null;
            }
            if (preferredFocusedComponent == null) {
                JComponent component2 = this.myToolWindow.getComponent();
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2);
            }
            if (preferredFocusedComponent != null) {
                this.requestFocus(preferredFocusedComponent).doWhenDone(() -> this.bringOwnerToFront());
            } else {
                JComponent componentToFocus = this.myToolWindow.getComponent();
                this.requestFocus(componentToFocus).doWhenDone(() -> this.bringOwnerToFront());
            }
        }
        finally {
            this.finish();
        }
    }

    private void bringOwnerToFront() {
        Window activeWindow;
        Window owner = SwingUtilities.getWindowAncestor(this.myToolWindow.getComponent());
        Window activeFrame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeFrame != null && activeFrame != owner) {
            return;
        }
        if (owner != null && owner.getFocusOwner() == null && ((activeWindow = RequestFocusInToolWindowCmd.getActiveWindow(owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
            LOG.debug("owner.toFront()");
            owner.toFront();
        }
    }

    @NotNull
    private ActionCallback requestFocus(final @NotNull Component c) {
        if (c == null) {
            RequestFocusInToolWindowCmd.$$$reportNull$$$0(0);
        }
        final ActionCallback result2 = new ActionCallback();
        final Alarm checkerAlarm = new Alarm();
        Runnable checker = new Runnable(){
            final long startTime = System.currentTimeMillis();

            @Override
            public void run() {
                if (System.currentTimeMillis() - this.startTime > 10000L) {
                    result2.setRejected();
                    return;
                }
                if (c.isShowing()) {
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                    if (owner == null || owner != c) {
                        Component defaultComponent = RequestFocusInToolWindowCmd.this.myToolWindow.getComponent().getFocusTraversalPolicy().getDefaultComponent(RequestFocusInToolWindowCmd.this.myToolWindow.getComponent());
                        if (defaultComponent != null) {
                            RequestFocusInToolWindowCmd.this.myManager.getFocusManager().requestFocusInProject(defaultComponent, RequestFocusInToolWindowCmd.this.myProject);
                            result2.setDone();
                        } else {
                            result2.setRejected();
                        }
                    }
                    RequestFocusInToolWindowCmd.this.myManager.getFocusManager().doWhenFocusSettlesDown(() -> {
                        if (c == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RequestFocusInToolWindowCmd.this.updateToolWindow(c);
                    });
                } else {
                    checkerAlarm.addRequest((Runnable)this, 100);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd$1", "lambda$run$0"));
            }
        };
        checkerAlarm.addRequest(checker, 0);
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            RequestFocusInToolWindowCmd.$$$reportNull$$$0(1);
        }
        return actionCallback;
    }

    private void updateToolWindow(Component c) {
        if (c.isFocusOwner()) {
            this.myFocusWatcher.setFocusedComponentImpl(c);
            if (this.myToolWindow.isAvailable() && !this.myToolWindow.isActive()) {
                this.myToolWindow.activate(null, true, false);
            }
        }
        RequestFocusInToolWindowCmd.updateFocusedComponentForWatcher(c);
    }

    private static void updateFocusedComponentForWatcher(Component c) {
        WindowWatcher watcher = ((WindowManagerImpl)WindowManager.getInstance()).getWindowWatcher();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c);
        if (focusWatcher != null && c.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c);
        }
    }

    private static Window getActiveWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = RequestFocusInToolWindowCmd.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

