/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemanticEditorPosition {
    private final EditorEx myEditor;
    private final HighlighterIterator myIterator;
    private final CharSequence myChars;
    private final Function<IElementType, SyntaxElement> myTypeMapper;
    private final BiFunction<EditorEx, Integer, HighlighterIterator> myCreateHighlighterIteratorAtOffset;

    private SemanticEditorPosition(@NotNull EditorEx editor, int offset, @NotNull BiFunction<EditorEx, Integer, HighlighterIterator> createHighlighterIteratorAtOffset, @NotNull Function<IElementType, SyntaxElement> typeMapper) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(0);
        }
        if (createHighlighterIteratorAtOffset == null) {
            SemanticEditorPosition.$$$reportNull$$$0(1);
        }
        if (typeMapper == null) {
            SemanticEditorPosition.$$$reportNull$$$0(2);
        }
        this.myCreateHighlighterIteratorAtOffset = createHighlighterIteratorAtOffset;
        this.myEditor = editor;
        this.myChars = this.myEditor.getDocument().getCharsSequence();
        this.myIterator = createHighlighterIteratorAtOffset.apply(editor, offset);
        this.myTypeMapper = typeMapper;
    }

    public void moveBeforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(3);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(4);
        }
        return this.copyAnd(position -> {
            if (syntaxElement == null) {
                SemanticEditorPosition.$$$reportNull$$$0(48);
            }
            position.moveBeforeOptional(syntaxElement);
        });
    }

    public void moveBeforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(5);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(6);
        }
        return this.copyAnd(position -> {
            if (elements == null) {
                SemanticEditorPosition.$$$reportNull$$$0(47);
            }
            position.moveBeforeOptionalMix(elements);
        });
    }

    public void moveAfterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(7);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(8);
        }
        return this.copyAnd(position -> {
            if (elements == null) {
                SemanticEditorPosition.$$$reportNull$$$0(46);
            }
            position.moveAfterOptionalMix(elements);
        });
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean isAtMultiline(SyntaxElement ... elements) {
        return this.isAtAnyOf(elements) && CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
    }

    public void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition before() {
        return this.copyAnd(position -> position.moveBefore());
    }

    public void moveAfterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(9);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(10);
        }
        return this.copyAnd(position -> {
            if (syntaxElement == null) {
                SemanticEditorPosition.$$$reportNull$$$0(45);
            }
            position.moveAfterOptional(syntaxElement);
        });
    }

    public void moveAfter() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition after() {
        return this.copyAnd(position -> position.moveAfter());
    }

    public void moveBeforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(11);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(12);
        }
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            this.myIterator.retreat();
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(13);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(14);
        }
        return this.copyAnd(position -> {
            if (leftParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(43);
            }
            if (rightParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(44);
            }
            position.moveBeforeParentheses(leftParenthesis, rightParenthesis);
        });
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(15);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(16);
        }
        this.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis, (Condition<SyntaxElement>)Conditions.alwaysFalse());
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(17);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(18);
        }
        return this.copyAnd(position -> {
            if (leftParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(41);
            }
            if (rightParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(42);
            }
            position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis);
        });
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Condition<SyntaxElement> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(19);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(20);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(21);
        }
        while (!this.myIterator.atEnd() && !terminationCondition.value((Object)this.map(this.myIterator.getTokenType()))) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.moveBeforeParentheses(leftParenthesis, rightParenthesis);
            } else if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Condition<SyntaxElement> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(22);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(23);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(24);
        }
        return this.copyAnd(position -> {
            if (leftParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(38);
            }
            if (rightParenthesis == null) {
                SemanticEditorPosition.$$$reportNull$$$0(39);
            }
            if (terminationCondition == null) {
                SemanticEditorPosition.$$$reportNull$$$0(40);
            }
            position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis, terminationCondition);
        });
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(25);
        }
        return this.elementAfterOnSameLine(syntaxElements) != null;
    }

    @Nullable
    public SyntaxElement elementAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(26);
        }
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return element;
            }
            this.myIterator.retreat();
        }
        return null;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(27);
        }
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(28);
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(29);
        }
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element) {
        if (element == null) {
            SemanticEditorPosition.$$$reportNull$$$0(30);
        }
        while (!this.myIterator.atEnd()) {
            if (element.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i = offset + 1; i < this.myIterator.getEnd(); ++i) {
            if (this.myChars.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Nullable
    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        if (language != null && !this.myIterator.atEnd()) {
            return language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language);
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        if (rule == null) {
            SemanticEditorPosition.$$$reportNull$$$0(31);
        }
        return rule.check(this);
    }

    public SyntaxElement map(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(32);
        }
        return this.myTypeMapper.apply(elementType);
    }

    public String toString() {
        return this.myIterator.getTokenType().toString();
    }

    public SemanticEditorPosition copy() {
        return SemanticEditorPosition.createEditorPosition(this.myEditor, this.isAtEnd() ? -1 : this.myIterator.getStart(), (editor, offset) -> !this.isAtEnd() ? this.myCreateHighlighterIteratorAtOffset.apply((EditorEx)editor, (Integer)offset) : new HighlighterIteratorWrapper(this.myIterator){

            @Override
            public void advance() {
            }

            @Override
            public void retreat() {
            }
        }, this.myTypeMapper);
    }

    public SemanticEditorPosition copyAnd(@NotNull Consumer<SemanticEditorPosition> modifier) {
        if (modifier == null) {
            SemanticEditorPosition.$$$reportNull$$$0(33);
        }
        SemanticEditorPosition position = this.copy();
        modifier.accept(position);
        return position;
    }

    @NotNull
    public static SemanticEditorPosition createEditorPosition(@NotNull EditorEx editor, int offset, @NotNull BiFunction<EditorEx, Integer, HighlighterIterator> createHighlighterIteratorAtOffset, @NotNull Function<IElementType, SyntaxElement> typeMapper) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(34);
        }
        if (createHighlighterIteratorAtOffset == null) {
            SemanticEditorPosition.$$$reportNull$$$0(35);
        }
        if (typeMapper == null) {
            SemanticEditorPosition.$$$reportNull$$$0(36);
        }
        SemanticEditorPosition semanticEditorPosition = new SemanticEditorPosition(editor, offset, createHighlighterIteratorAtOffset, typeMapper);
        if (semanticEditorPosition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(37);
        }
        return semanticEditorPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createHighlighterIteratorAtOffset";
                break;
            }
            case 2: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 27: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 38: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenthesis";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightParenthesis";
                break;
            }
            case 21: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCondition";
                break;
            }
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveBeforeOptional";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeOptional";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveBeforeOptionalMix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeOptionalMix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveAfterOptionalMix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "afterOptionalMix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveAfterOptional";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "afterOptional";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "moveBeforeParentheses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "beforeParentheses";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveToLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAfterOnSameLine";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "elementAfterOnSameLine";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAt";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAtAnyOf";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findStartOf";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "matchesRule";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copyAnd";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createEditorPosition";
                break;
            }
            case 37: {
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findLeftParenthesisBackwardsSkippingNested$8";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findLeftParenthesisBackwardsSkippingNested$7";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$beforeParentheses$6";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$afterOptional$4";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$afterOptionalMix$2";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$beforeOptionalMix$1";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$beforeOptional$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }

    public static interface SyntaxElement {
    }
}

