/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.debugger.UiDebuggerExtension;
import com.intellij.ui.debugger.extensions.UiScriptFileType;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaybackDebugger
implements UiDebuggerExtension,
PlaybackRunner.StatusCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.debugger.extensions.PlaybackDebugger");
    private static final Color ERROR_COLOR = JBColor.RED;
    private static final Color MESSAGE_COLOR = Color.BLACK;
    private static final Color CODE_COLOR = PlatformColors.BLUE;
    private static final Color TEST_COLOR = JBColor.GREEN.darker();
    private JPanel myComponent;
    private PlaybackRunner myRunner;
    private JEditorPane myLog;
    private final JTextField myScriptsPath = new JTextField();
    private static final String EXT = "ijs";
    private static final String DOT_EXT = ".ijs";
    private final JTextField myCurrentScript = new JTextField();
    private VirtualFileListener myVfsListener;
    private boolean myChanged;
    private PlaybackDebuggerState myState;
    private static final FileChooserDescriptor FILE_DESCRIPTOR = new ScriptFileChooserDescriptor();
    private JTextArea myCodeEditor;

    private void initUi() {
        this.myComponent = new JPanel(new BorderLayout());
        this.myLog = new JEditorPane();
        this.myLog.setEditorKit(new StyledEditorKit());
        this.myLog.setEditable(false);
        this.myState = (PlaybackDebuggerState)ServiceManager.getService(PlaybackDebuggerState.class);
        DefaultActionGroup controlGroup = new DefaultActionGroup();
        controlGroup.add((AnAction)new RunOnFameActivationAction());
        controlGroup.add((AnAction)new ActivateFrameAndRun());
        controlGroup.add((AnAction)new StopAction());
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)ActionManager.getInstance().createActionToolbar("PlaybackDbg", (ActionGroup)controlGroup, true).getComponent(), "West");
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)this.myCurrentScript, "Center");
        this.myCurrentScript.setText(this.myState.currentScript);
        this.myCurrentScript.setEditable(false);
        DefaultActionGroup fsGroup = new DefaultActionGroup();
        SaveAction saveAction = new SaveAction();
        saveAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("control S")), this.myComponent);
        fsGroup.add((AnAction)saveAction);
        SetScriptFileAction setScriptFileAction = new SetScriptFileAction();
        setScriptFileAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("control O")), this.myComponent);
        fsGroup.add((AnAction)setScriptFileAction);
        NewScriptAction newScriptAction = new NewScriptAction();
        newScriptAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("control N")), this.myComponent);
        fsGroup.add((AnAction)newScriptAction);
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("PlaybackDbgExtra", (ActionGroup)fsGroup, true);
        tb.setLayoutPolicy(0);
        right.add((Component)tb.getComponent(), "East");
        north.add((Component)right, "Center");
        this.myComponent.add((Component)north, "North");
        this.myCodeEditor = new JTextArea();
        this.myCodeEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }
        });
        if (this.pathToFile() != null) {
            this.loadFrom(this.pathToFile());
        }
        Splitter script2Log = new Splitter(true);
        script2Log.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myCodeEditor));
        script2Log.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLog));
        this.myComponent.add((Component)script2Log, "Center");
        this.myVfsListener = new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                VirtualFile file2;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((file2 = PlaybackDebugger.this.pathToFile()) != null && file2.equals(event.getFile())) {
                    PlaybackDebugger.this.loadFrom(event.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/debugger/extensions/PlaybackDebugger$2", "contentsChanged"));
            }
        };
        LocalFileSystem.getInstance().addVirtualFileListener(this.myVfsListener);
    }

    private void fillDocument(String text) {
        ApplicationManager.getApplication().runWriteAction(() -> this.myCodeEditor.setText(text == null ? "" : text));
    }

    @Nullable
    private VirtualFile pathToFile() {
        if (this.myState.currentScript.length() == 0) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(this.myState.currentScript);
    }

    private void save() {
        try {
            VirtualFile file2 = this.pathToFile();
            String toWrite = this.myCodeEditor.getText();
            String text = toWrite != null ? toWrite : "";
            VfsUtil.saveText((VirtualFile)file2, (String)text);
            this.myChanged = false;
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Cannot save script");
        }
    }

    private void loadFrom(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PlaybackDebugger.$$$reportNull$$$0(0);
        }
        String text = LoadTextUtil.loadText(file2).toString();
        this.fillDocument(text);
        this.myChanged = false;
    }

    private File getScriptsFile() {
        String text = this.myScriptsPath.getText();
        if (text == null) {
            return null;
        }
        File file2 = new File(text);
        return file2.exists() ? file2 : null;
    }

    private void activateAndRun() {
        assert (this.myRunner == null);
        this.myLog.setText(null);
        IdeFrameImpl frame = PlaybackDebugger.getFrame();
        Component c = ((WindowManagerEx)WindowManager.getInstance()).getFocusedComponent(frame);
        if (c != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(c, true));
        } else {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)frame, true));
        }
        SwingUtilities.invokeLater(() -> this.startWhenFrameActive());
    }

    private static IdeFrameImpl getFrame() {
        Frame[] all;
        for (Frame each : all = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            return (IdeFrameImpl)each;
        }
        throw new IllegalStateException("Cannot find IdeFrame to run on");
    }

    private void runOnFrame() {
        assert (this.myRunner == null);
        this.startWhenFrameActive();
    }

    private void startWhenFrameActive() {
        VirtualFile scriptDir;
        this.myLog.setText(null);
        this.addInfo("Waiting for IDE frame activation", -1, MESSAGE_COLOR, 0);
        this.myRunner = new PlaybackRunner(this.myCodeEditor.getText(), this, false, true, false);
        VirtualFile file2 = this.pathToFile();
        if (file2 != null && (scriptDir = file2.getParent()) != null) {
            this.myRunner.setScriptDir(new File(scriptDir.getPresentableUrl()));
        }
        new Thread("playback debugger"){

            @Override
            public void run() {
                new WaitFor(60000){

                    protected boolean condition() {
                        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof IdeFrame || PlaybackDebugger.this.myRunner == null;
                    }
                };
                if (PlaybackDebugger.this.myRunner == null) {
                    PlaybackDebugger.this.message(null, "Script stopped", -1, PlaybackRunner.StatusCallback.Type.message, true);
                    return;
                }
                PlaybackDebugger.this.message(null, "Starting script...", -1, PlaybackRunner.StatusCallback.Type.message, true);
                TimeoutUtil.sleep((long)1000L);
                if (PlaybackDebugger.this.myRunner == null) {
                    PlaybackDebugger.this.message(null, "Script stopped", -1, PlaybackRunner.StatusCallback.Type.message, true);
                    return;
                }
                PlaybackRunner runner = PlaybackDebugger.this.myRunner;
                PlaybackDebugger.this.myRunner.run().doWhenProcessed(() -> {
                    if (runner == PlaybackDebugger.this.myRunner) {
                        SwingUtilities.invokeLater(() -> PlaybackDebugger.this.myRunner = null);
                    }
                });
            }
        }.start();
    }

    @Override
    public void message(@Nullable PlaybackContext context, String text, PlaybackRunner.StatusCallback.Type type) {
        this.message(context, text, context != null ? context.getCurrentLine() : -1, type, false);
    }

    private void message(@Nullable PlaybackContext context, String text, int currentLine, PlaybackRunner.StatusCallback.Type type, boolean forced) {
        int depth = context != null ? context.getCurrentStageDepth() : 0;
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!forced && context != null && context.isDisposed()) {
                return;
            }
            switch (type) {
                case message: {
                    this.addInfo(text, currentLine, MESSAGE_COLOR, depth);
                    break;
                }
                case error: {
                    this.addInfo(text, currentLine, ERROR_COLOR, depth);
                    break;
                }
                case code: {
                    this.addInfo(text, currentLine, CODE_COLOR, depth);
                    break;
                }
                case test: {
                    this.addInfo(text, currentLine, TEST_COLOR, depth);
                }
            }
        });
    }

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.initUi();
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Playback";
    }

    public void dispose() {
        this.disposeUiResources();
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myVfsListener);
        this.myCurrentScript.setText("");
        this.myLog.setText(null);
    }

    private void addInfo(String text, int line, Color fg, int depth) {
        if (text == null || text.length() == 0) {
            return;
        }
        String inset = StringUtil.repeat((String)"   ", (int)depth);
        Document doc = this.myLog.getDocument();
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, UIManager.getFont("Label.font").getFontName());
        StyleConstants.setFontSize(attr, UIManager.getFont("Label.font").getSize());
        StyleConstants.setForeground(attr, fg);
        try {
            doc.insertString(doc.getLength(), inset + text + "\n", attr);
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
        }
        this.scrollToLast();
    }

    private void scrollToLast() {
        SwingUtilities.invokeLater(() -> {
            if (this.myLog.getDocument().getLength() == 0) {
                return;
            }
            Rectangle bounds = this.myLog.getBounds();
            this.myLog.scrollRectToVisible(new Rectangle(0, (int)bounds.getMaxY() - 1, (int)bounds.getWidth(), 1));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/debugger/extensions/PlaybackDebugger", "loadFrom"));
    }

    @State(name="PlaybackDebugger", storages={@Storage(value="playbackDebugger.xml", roamingType=RoamingType.PER_OS)})
    public static class PlaybackDebuggerState
    implements PersistentStateComponent<PlaybackDebuggerState> {
        @Attribute
        public String currentScript = "";

        public PlaybackDebuggerState getState() {
            return this;
        }

        public void loadState(@NotNull PlaybackDebuggerState state) {
            if (state == null) {
                PlaybackDebuggerState.$$$reportNull$$$0(0);
            }
            XmlSerializerUtil.copyBean((Object)state, (Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ui/debugger/extensions/PlaybackDebugger$PlaybackDebuggerState", "loadState"));
        }
    }

    private class RunOnFameActivationAction
    extends AnAction {
        private RunOnFameActivationAction() {
            super("Run On Frame Activation", "", AllIcons.General.Run);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myRunner == null);
        }

        public void actionPerformed(AnActionEvent e) {
            PlaybackDebugger.this.runOnFrame();
        }
    }

    private class ActivateFrameAndRun
    extends AnAction {
        private ActivateFrameAndRun() {
            super("Activate Frame And Run", "", AllIcons.Nodes.Deploy);
        }

        public void actionPerformed(AnActionEvent e) {
            PlaybackDebugger.this.activateAndRun();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myRunner == null);
        }
    }

    private class StopAction
    extends AnAction {
        private StopAction() {
            super("Stop", null, AllIcons.Actions.Suspend);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myRunner != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (PlaybackDebugger.this.myRunner != null) {
                PlaybackDebugger.this.myRunner.stop();
                SwingUtilities.invokeLater(() -> PlaybackDebugger.this.myRunner = null);
            }
        }
    }

    private class NewScriptAction
    extends AnAction {
        private NewScriptAction() {
            super("New Script", "", AllIcons.Actions.New);
        }

        public void actionPerformed(AnActionEvent e) {
            ((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript = "";
            PlaybackDebugger.this.myCurrentScript.setText(((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript);
            PlaybackDebugger.this.fillDocument("");
        }
    }

    private class SetScriptFileAction
    extends AnAction {
        private SetScriptFileAction() {
            super("Set Script File", "", AllIcons.Actions.Menu_open);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)FILE_DESCRIPTOR, (Component)PlaybackDebugger.this.myComponent, (Project)SetScriptFileAction.getEventProject((AnActionEvent)e), (VirtualFile)PlaybackDebugger.this.pathToFile());
            if (selectedFile != null) {
                ((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript = selectedFile.getPresentableUrl();
                PlaybackDebugger.this.loadFrom(selectedFile);
                PlaybackDebugger.this.myCurrentScript.setText(((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript);
            }
        }
    }

    private static class ScriptFileChooserDescriptor
    extends FileChooserDescriptor {
        public ScriptFileChooserDescriptor() {
            super(true, false, false, false, false, false);
            this.putUserData(FileChooserKeys.NEW_FILE_TYPE, UiScriptFileType.getInstance());
            this.putUserData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT, "");
        }

        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            if (!showHiddenFiles && FileElement.isFileHidden((VirtualFile)file2)) {
                return false;
            }
            return file2.getExtension() != null && file2.getExtension().equalsIgnoreCase(PlaybackDebugger.EXT) || super.isFileVisible(file2, showHiddenFiles) && file2.isDirectory();
        }
    }

    private class SaveAction
    extends AnAction {
        private SaveAction() {
            super("Save", "", AllIcons.Actions.Menu_saveall);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myChanged);
        }

        public void actionPerformed(AnActionEvent e) {
            if (PlaybackDebugger.this.pathToFile() == null) {
                VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)FILE_DESCRIPTOR, (Component)PlaybackDebugger.this.myComponent, (Project)SaveAction.getEventProject((AnActionEvent)e), null);
                if (selectedFile != null) {
                    ((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript = selectedFile.getPresentableUrl();
                    PlaybackDebugger.this.myCurrentScript.setText(((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript);
                } else {
                    Messages.showErrorDialog((String)"File to save is not selected.", (String)"Cannot save script");
                    return;
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> PlaybackDebugger.this.save());
        }
    }
}

