/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;

public final class ImageEditorImpl
implements ImageEditor {
    private final Project project;
    private final VirtualFile file;
    private final ImageEditorUI editorUI;
    private boolean disposed;

    public ImageEditorImpl(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ImageEditorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ImageEditorImpl.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.file = file2;
        this.editorUI = new ImageEditorUI(this);
        Disposer.register((Disposable)this, (Disposable)this.editorUI);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ImageEditorImpl.this.propertyChanged(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ImageEditorImpl.this.contentsChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/intellij/images/editor/impl/ImageEditorImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.setValue(file2);
    }

    private void setValue(VirtualFile file2) {
        try {
            this.editorUI.setImageProvider(IfsUtil.getImageProvider(file2), IfsUtil.getFormat(file2));
        }
        catch (Exception e) {
            this.editorUI.setImageProvider(null, null);
        }
    }

    @Override
    public boolean isValid() {
        ImageDocument document = this.editorUI.getImageComponent().getDocument();
        return document.getValue() != null;
    }

    @Override
    public ImageEditorUI getComponent() {
        return this.editorUI;
    }

    @Override
    public JComponent getContentComponent() {
        return this.editorUI.getImageComponent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            ImageEditorImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            ImageEditorImpl.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    public ImageDocument getDocument() {
        return this.editorUI.getImageComponent().getDocument();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.editorUI.getImageComponent().setTransparencyChessboardVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.editorUI.getImageComponent().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.editorUI.getImageComponent().setGridVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isGridVisible() {
        return this.editorUI.getImageComponent().isGridVisible();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.editorUI.getZoomModel();
    }

    public void dispose() {
        this.disposed = true;
    }

    void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            ImageEditorImpl.$$$reportNull$$$0(4);
        }
        if (this.file.equals(event.getFile())) {
            this.file.refresh(true, false, () -> {
                if (ImageFileTypeManager.getInstance().isImage(this.file)) {
                    this.setValue(this.file);
                } else {
                    this.setValue(null);
                    FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.project);
                    editorManager.closeFile(this.file);
                }
            });
        }
    }

    void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ImageEditorImpl.$$$reportNull$$$0(5);
        }
        if (this.file.equals(event.getFile())) {
            Runnable postRunnable = () -> this.setValue(this.file);
            RefreshQueue.getInstance().refresh(true, false, postRunnable, ModalityState.current(), new VirtualFile[]{this.file});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/editor/impl/ImageEditorImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/editor/impl/ImageEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

