/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.Archive;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class ZipArtifact
implements Archive {
    private final Path artifact;
    private final Path contents;

    private ZipArtifact(Path artifact, FileSystem zipFileSystem) throws IOException {
        this.artifact = artifact;
        this.contents = Files.createTempDirectory(artifact.getFileName().toString(), new FileAttribute[0]);
        Files.walkFileTree(zipFileSystem.getPath("/", new String[0]), new CopyPathFileVisitor(this.contents, zipFileSystem));
    }

    public static ZipArtifact fromZippedBundle(Path artifact) throws IOException {
        try (FileSystem fileSystem = FileUtils.createZipFilesystem((Path)artifact);){
            ZipArtifact zipArtifact = new ZipArtifact(artifact, fileSystem);
            return zipArtifact;
        }
    }

    @Override
    public Path getPath() {
        return this.artifact;
    }

    @Override
    public Path getContentRoot() {
        return this.contents;
    }

    @Override
    public void close() throws IOException {
        FileUtils.deletePath((File)this.contents.toFile());
    }

    @Override
    public boolean isBinaryXml(Path p, byte[] content) {
        return false;
    }

    private static class CopyPathFileVisitor
    implements FileVisitor<Path> {
        private final Path source;
        private final Path destination;

        public CopyPathFileVisitor(Path destination, FileSystem source) {
            this.source = source.getPath("/", new String[0]);
            this.destination = destination;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(this.destination.resolve(this.source.relativize(dir).toString()), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.destination.resolve(this.source.relativize(file).toString()), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

