/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.console.BaseJdbcSessionView;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.SessionHolder;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.audit.JdbcConsoleAuditor;
import com.intellij.database.run.session.BaseJdbcSession;
import com.intellij.database.run.session.JdbcScriptingSessionView;
import com.intellij.database.run.session.Session;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vendors.oracle.OracleCompilationErrorsObtainer;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlImportForeignSchemaStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.ui.content.Content;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcConsole
extends AbstractQueryLanguageConsole<LocalDataSource, JdbcScriptingSessionView>
implements DataRequest.TxIsolationOwner,
BaseJdbcSession<JdbcScriptingSessionView> {
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private static final Key<Boolean> SCHEDULE_REFRESH = Key.create((String)"SCHEDULE_REFRESH");
    private static final Key<IntrospectionScopeUpdater> SCOPE_UPDATER = Key.create((String)"SCOPE_UPDATER");
    private static final String TOGGLE_CONSOLE_TOOLBAR_PROP = "Database.Console";
    private final AtomicReference<SearchPath> mySearchPath;
    private final AtomicReference<Boolean> myScheduleRefresh;
    private Content myPlanContent;
    private final EventDispatcher<SearchPathReceiver> myPathDispatcher;
    private final TraceableDisposable myTraceableDisposable;
    private volatile int myIsolation;

    @NotNull
    public static Builder newConsole(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(0);
        }
        Builder builder = new Builder(project);
        if (builder == null) {
            JdbcConsole.$$$reportNull$$$0(1);
        }
        return builder;
    }

    @NotNull
    public static ToggleToolbarAction createToggleConsoleToolbarAction(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(2);
        }
        ToggleToolbarAction action = ToggleToolbarAction.createAction((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)project), () -> {
            if (project == null) {
                JdbcConsole.$$$reportNull$$$0(41);
            }
            return JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).filter(o -> {
                if (project == null) {
                    JdbcConsole.$$$reportNull$$$0(42);
                }
                Editor editor = o instanceof TextEditor ? ((TextEditor)o).getEditor() : null;
                EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
                return editorEx != null && editorEx.getPermanentHeaderComponent() != null && JdbcConsole.findConsole(project, editorEx.getVirtualFile()) != null;
            }).map(o -> o.getComponent());
        });
        action.getTemplatePresentation().setText("Show Toolbar in Console");
        ToggleToolbarAction toggleToolbarAction = action;
        if (toggleToolbarAction == null) {
            JdbcConsole.$$$reportNull$$$0(3);
        }
        return toggleToolbarAction;
    }

    @Deprecated
    public static boolean beforeExecuteRange(@NotNull JdbcConsole console, TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(4);
        }
        if (range.isEmpty()) {
            return false;
        }
        ScriptModel subModel = console.getScriptModel().subModel(range);
        return console.beforeExecuteQueries(subModel);
    }

    @Deprecated
    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(5);
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, DatabaseSettings.getDefaultExecOption());
        return JdbcConsole.getQueryText(console, range);
    }

    @Deprecated
    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JdbcConsole.$$$reportNull$$$0(7);
        }
        if (range.isEmpty()) {
            return null;
        }
        String selected = range.subSequence((CharSequence)console.getLanguageConsole().getEditorDocument().getText()).toString();
        JBIterable parameters = console.getScriptModel().subModel(range).parameters();
        return ScriptModelUtil.statementText(((JdbcScriptingSessionView)console.getView()).getParametersHolder().getPStorage(), parameters, selected, 0);
    }

    @Nullable
    public static DataAuditor createAdvancedErrorsObtainer(@NotNull DatabaseSystem info, @NotNull DataAuditor sink) {
        DatabaseFamilyId dbFamilyId;
        if (info == null) {
            JdbcConsole.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            JdbcConsole.$$$reportNull$$$0(9);
        }
        if ((dbFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)info)).isOracle()) {
            return new OracleCompilationErrorsObtainer(sink);
        }
        return null;
    }

    private JdbcConsole(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull LocalDataSource dataSource, @Nullable String query) {
        if (languageConsole == null) {
            JdbcConsole.$$$reportNull$$$0(10);
        }
        if (messageBus == null) {
            JdbcConsole.$$$reportNull$$$0(11);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(12);
        }
        super(languageConsole, messageBus, dataSource);
        this.mySearchPath = new AtomicReference();
        this.myScheduleRefresh = new AtomicReference<Boolean>(false);
        this.myPathDispatcher = EventDispatcher.create(SearchPathReceiver.class);
        this.myTraceableDisposable = new TraceableDisposable(true);
        this.setCurrentTx(DataRequest.getInitialTxMarker(DbImplUtil.getLocalDataSource(dataSource).isAutoCommit()));
        MyConsoleHistoryController controller = new MyConsoleHistoryController(dataSource);
        JdbcDriverManager.getDriverManager(this.getProject()).addModificationTrackerListener(new FilePresentationUpdater(), this);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console");
        controller.setMultiline(true).install();
        if (StringUtil.isNotEmpty((String)query) && StringUtil.isEmpty((String)this.getLanguageConsole().getEditorDocument().getText())) {
            this.getLanguageConsole().setInputText(query);
        }
        this.getMessageBus().addAuditor(new JdbcConsoleAuditor(this));
        this.myIsolation = -1;
    }

    @Override
    public int getTxIsolation() {
        return this.myIsolation;
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.myIsolation = isolation;
    }

    public void addReceiver(@NotNull Disposable parent, @NotNull SearchPathReceiver receiver) {
        if (parent == null) {
            JdbcConsole.$$$reportNull$$$0(13);
        }
        if (receiver == null) {
            JdbcConsole.$$$reportNull$$$0(14);
        }
        this.myPathDispatcher.addListener((EventListener)receiver, parent);
    }

    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(15);
        }
        if (this.mySearchPath.get() == null) {
            this.updateSearchPath(context.getSearchPath());
        }
    }

    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        IntrospectionScopeUpdater scopeUpdater;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(16);
        }
        ConsoleDataRequest consoleRequest = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
        boolean updateSearchPath = this.mySearchPath.get() == null || consoleRequest == null || consoleRequest.isExecutionStopper();
        boolean requestAutoSync = consoleRequest != null && consoleRequest.isExecutionStopper() && Boolean.TRUE.equals(consoleRequest.getSharedDataHolder().getUserData(SCHEDULE_REFRESH));
        boolean inTransaction2 = context.txMarker.getOwner() != null;
        IntrospectionScopeUpdater introspectionScopeUpdater = scopeUpdater = consoleRequest == null ? null : (IntrospectionScopeUpdater)consoleRequest.getSharedDataHolder().getUserData(SCOPE_UPDATER);
        if (this.isValid() && updateSearchPath) {
            this.updateSearchPath(context.getSearchPath());
        }
        if (this.isTargetValid() && requestAutoSync) {
            LoaderContext loaderContext = this.prepareContext();
            if (scopeUpdater != null) {
                loaderContext.getScopeUpdater().merge(scopeUpdater);
            }
            DataSourceUiUtil.performAutoSyncTask(loaderContext);
            if (inTransaction2) {
                this.myScheduleRefresh.set(true);
            }
        }
    }

    public void updateConsoleOnTxCompleted(boolean commit) {
        if (this.isTargetValid() && commit && this.myScheduleRefresh.getAndSet(false).booleanValue()) {
            DataSourceUiUtil.performAutoSyncTask(this.prepareContext());
        }
    }

    public void setSearchPath(@Nullable SearchPath schemaPaths) {
        this.updateSearchPath(schemaPaths);
    }

    @NotNull
    public ScriptModel.PStorage getPStorage() {
        ScriptModel.PStorage pStorage = ((JdbcScriptingSessionView)this.getView()).getParametersHolder().getPStorage();
        if (pStorage == null) {
            JdbcConsole.$$$reportNull$$$0(17);
        }
        return pStorage;
    }

    @Override
    @NotNull
    protected ScriptModel<?> createScriptModel(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            JdbcConsole.$$$reportNull$$$0(18);
        }
        ScriptModel scriptModel = SqlPsiFacade.getInstance((Project)consoleView.getProject()).createScriptModel(consoleView.getFile());
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(19);
        }
        return scriptModel;
    }

    @NotNull
    private LoaderContext prepareContext() {
        LoaderContext loaderContext = DataSourceUiUtil.getConnectionContext(this.getProject(), (LocalDataSource)this.getTarget(), SearchPath.getCurrent((SearchPath)this.mySearchPath.get()));
        if (loaderContext == null) {
            JdbcConsole.$$$reportNull$$$0(20);
        }
        return loaderContext;
    }

    private void updateSearchPath(@Nullable SearchPath schemaPaths) {
        if (Comparing.equal((Object)schemaPaths, (Object)this.mySearchPath.get())) {
            return;
        }
        this.mySearchPath.set(schemaPaths);
        TransactionGuard.submitTransaction((Disposable)this.getProject(), () -> {
            VirtualFile virtualFile = this.getLanguageConsole().getVirtualFile();
            DatabaseEditorHelper.initSearchPath(this.getLanguageConsole().getFile());
            ChooseSchemaAction.setSelectedSearchPath(virtualFile, this.mySearchPath.get());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
            AssignColorAction.updateFileEditors(FileEditorManagerEx.getInstanceEx((Project)this.getProject()), virtualFile);
        });
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        SearchPath path = this.getSearchPath();
        return path == null ? null : path.getCurrent();
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath.get();
    }

    @NotNull
    public static List<JdbcConsole> getActiveConsoles(Project project) {
        List<JdbcConsole> list = ScriptingJdbcSessionHolder.INSTANCE.getActiveSessions(project);
        if (list == null) {
            JdbcConsole.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    public static JdbcConsole findConsole(@NotNull AnActionEvent e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(22);
        }
        return ScriptingJdbcSessionHolder.INSTANCE.getMaybeAttachedSession(e);
    }

    @Nullable
    public static JdbcConsole findConsole(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return ScriptingJdbcSessionHolder.INSTANCE.getMaybeAttachedSession(project, virtualFile);
    }

    @Nullable
    public static JdbcConsole getConsole(@NotNull AnActionEvent e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(23);
        }
        return (JdbcConsole)ScriptingJdbcSessionHolder.INSTANCE.getSession(e);
    }

    @Nullable
    public static JdbcConsole getConsole(@Nullable Project project, @Nullable VirtualFile file) {
        return (JdbcConsole)ScriptingJdbcSessionHolder.INSTANCE.getSession(project, file);
    }

    @Override
    protected String getHelpID() {
        return "reference.runToolWindow.jdbcTab";
    }

    public void buildConsoleHeaderComponent(Editor editor) {
        this.checkValid();
        JdbcScriptingSessionView view = (JdbcScriptingSessionView)this.getView();
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        leftGroup.add(view.getRunAction());
        leftGroup.addSeparator();
        leftGroup.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        leftGroup.add(view.getToggleAction());
        leftGroup.add(actionManager.getAction("Database.Settings"));
        leftGroup.addSeparator();
        leftGroup.add(actionManager.getAction("Console.Transaction"));
        leftGroup.addSeparator();
        leftGroup.add(view.getTerminateAction());
        rightGroup.add(actionManager.getAction("Console.Jdbc.ChooseSchema"));
        rightGroup.add(actionManager.getAction("Console.Jdbc.ChooseConsole"));
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        ActionToolbar leftToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)leftGroup, true);
        ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)rightGroup, true);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        leftToolbar.setTargetComponent(editor.getContentComponent());
        rightToolbar.setTargetComponent(editor.getContentComponent());
        headerComponent.add((Component)leftToolbar.getComponent(), "Center");
        headerComponent.add((Component)rightToolbar.getComponent(), "East");
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
        ToggleToolbarAction.setToolbarVisible((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)this.getProject()), (Iterable)JBIterable.of((Object)headerComponent), null);
        DatabaseEditorHelper.updateToolbarColor(this.getProject(), this.getLanguageConsole().getVirtualFile(), (JComponent)headerComponent);
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model, @NotNull DatabaseSettings.ExecOption execOption) {
        boolean scheduleRefresh;
        if (sourceEditor == null) {
            JdbcConsole.$$$reportNull$$$0(24);
        }
        if (model == null) {
            JdbcConsole.$$$reportNull$$$0(25);
        }
        if (execOption == null) {
            JdbcConsole.$$$reportNull$$$0(26);
        }
        IntrospectionScopeUpdater scopeUpdater = null;
        if (((LocalDataSource)this.getTarget()).isAutoSynchronize()) {
            SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)model.statements().transform(ScriptModelUtil.TO_OBJECT).filter(PsiElement.class).toList());
            boolean bl = scheduleRefresh = !((SyntaxTraverser)s.filter(e -> JdbcConsole.triggersIntrospection(e))).traverse().isEmpty();
            if (scheduleRefresh) {
                scopeUpdater = DbSqlUtil.getScopeUpdater((SyntaxTraverser<PsiElement>)s, this.getCurrentNamespace(), ((LocalDataSource)this.getTarget()).getModel());
            }
        } else {
            scheduleRefresh = false;
        }
        ConsoleDataRequest request = ConsoleDataRequest.newConsoleRequest(this, sourceEditor, model, execOption.newTab);
        request.getSharedDataHolder().putUserData(SCHEDULE_REFRESH, (Object)scheduleRefresh);
        request.getSharedDataHolder().putUserData(SCOPE_UPDATER, scopeUpdater);
        this.getMessageBus().getDataProducer().processRequest(request);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.run.intention");
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = (LocalDataSource)this.getTarget();
        if (localDataSource == null) {
            JdbcConsole.$$$reportNull$$$0(27);
        }
        return localDataSource;
    }

    @Override
    public void beforeTreeDispose() {
        this.myTraceableDisposable.kill(null);
        super.beforeTreeDispose();
    }

    private void checkValid() {
        if (this.myDisposed) {
            this.myTraceableDisposable.throwDisposalError("Console already disposed");
        }
        if (!this.isValid()) {
            throw new AssertionError();
        }
    }

    public void switchSchema(@NotNull SearchPath to, boolean force) {
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(28);
        }
        if (force && this.getCurrentTx().getOwner() == this && JdbcUrlParserUtil.outOfBounds(this.getDataSource(), SearchPath.getCurrent((SearchPath)this.getSearchPath()), to.getCurrent())) {
            int res = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)"Current connection will be closed.\nCommit current transaction?", (String)"Current Transaction", (Icon)Messages.getWarningIcon());
            if (res == 0) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxCommit(this));
            } else if (res == 1) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxRollback(this.getCurrentTx()));
            } else {
                return;
            }
        }
        ((SearchPathReceiver)this.myPathDispatcher.getMulticaster()).receive(to);
        this.updateSearchPath(to);
        this.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this, to, force));
    }

    @NotNull
    public Content createPlanContent() {
        PlanView view = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view.getComponent(), "Plan", DatabaseIcons.Table, view.getPreferredFocusedComponent());
        content.setCloseable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                JdbcConsole.this.myPlanContent = null;
            }
        });
        Content content2 = content;
        if (content2 == null) {
            JdbcConsole.$$$reportNull$$$0(29);
        }
        return content2;
    }

    public void showPlan(@Nullable PlanModel plan) {
        if (plan != null) {
            ((JdbcScriptingSessionView)this.getView()).ensureContentInitialized(true);
            if (this.myPlanContent == null) {
                this.myPlanContent = this.createPlanContent();
                this.getUi().addContent(this.myPlanContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(this.myPlanContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)this.myPlanContent)).setModel(plan);
            this.getUi().selectAndFocus(this.myPlanContent, true, false);
        } else if (this.myPlanContent != null) {
            this.getUi().removeContent(this.myPlanContent, true);
            this.myPlanContent = null;
        }
    }

    @Override
    @NotNull
    protected JdbcScriptingSessionView createSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull ScriptModel<?> scriptModel) {
        if (languageConsole == null) {
            JdbcConsole.$$$reportNull$$$0(30);
        }
        if (messageBus == null) {
            JdbcConsole.$$$reportNull$$$0(31);
        }
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(32);
        }
        JdbcScriptingSessionView jdbcScriptingSessionView = new JdbcScriptingSessionView(this, messageBus, languageConsole, scriptModel);
        if (jdbcScriptingSessionView == null) {
            JdbcConsole.$$$reportNull$$$0(33);
        }
        return jdbcScriptingSessionView;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = ((JdbcScriptingSessionView)this.getView()).getConsoleView().getVirtualFile();
        if (virtualFile == null) {
            JdbcConsole.$$$reportNull$$$0(34);
        }
        return virtualFile;
    }

    @Override
    public boolean isTargetValid() {
        return JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), this.getDataSource());
    }

    @Override
    public void dispose() {
        try {
            JdbcConsole.getActiveConsoles(this.getProject()).remove(this);
        }
        finally {
            super.dispose();
        }
    }

    public void updateTitle() {
        String title = JdbcConsole.getTitle(this.getProject(), this.getLanguageConsole().getVirtualFile());
        this.getLanguageConsole().setTitle(title);
        this.getContent().setDisplayName(title);
    }

    public static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DatabaseSystem dataSource) {
        if (dbFacade == null) {
            JdbcConsole.$$$reportNull$$$0(35);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(36);
        }
        return dbFacade.findDataSource(dataSource.getUniqueId()) != null;
    }

    @NotNull
    private static String getTitle(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(37);
        }
        if (file == null) {
            JdbcConsole.$$$reportNull$$$0(38);
        }
        String string = VfsPresentationUtil.getPresentableNameForUI((Project)project, (VirtualFile)file);
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static boolean triggersIntrospection(@NotNull PsiElement e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(40);
        }
        if (e instanceof SqlTableDefinition || e instanceof SqlImportForeignSchemaStatement) {
            return true;
        }
        if (e instanceof SqlAlterStatement) {
            ObjectKind kind;
            SqlReferenceExpression ref = ((SqlAlterStatement)e).getAlterTargetReference();
            ObjectKind objectKind = kind = ref == null ? null : ref.getReferenceElementType().getTargetKind();
            if (kind == null) {
                return false;
            }
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
                return true;
            }
            return PsiTreeUtil.getChildOfType((PsiElement)e, SqlRenameToClause.class) != null;
        }
        return e instanceof SqlDdlStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 22: 
            case 23: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleConsoleToolbarAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPStorage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createScriptModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareContext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveConsoles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlanContent";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionView";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 39: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToggleConsoleToolbarAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAdvancedErrorsObtainer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addReceiver";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestStarted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestFinished";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createScriptModel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findConsole";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "switchSchema";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSessionView";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceValid";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createToggleConsoleToolbarAction$2";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyConsoleHistoryController
    extends ConsoleHistoryController {
        MyConsoleHistoryController(LocalDataSource dataSource) {
            if (JdbcConsole.this == null) {
                MyConsoleHistoryController.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                MyConsoleHistoryController.$$$reportNull$$$0(1);
            }
            super((ConsoleRootType)DbConsoleRootType.getInstance(), dataSource.getUniqueId(), JdbcConsole.this.getLanguageConsole());
        }

        protected int insertTextMultiline(String text, Editor editor, Document document) {
            TextRange range = ScriptModelUtil.getSelectedStatementsRange(JdbcConsole.this, DatabaseSettings.getDefaultExecOption());
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getStartOffset() + text.length());
            return range.getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "0";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/JdbcConsole$MyConsoleHistoryController";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    private class FilePresentationUpdater
    implements ModificationTrackerListener<JdbcDriverManager> {
        private FilePresentationUpdater() {
        }

        public void modificationCountChanged(JdbcDriverManager source) {
            ((JdbcScriptingSessionView)JdbcConsole.this.getView()).updateFilePresentation();
        }
    }

    public static class ScriptingJdbcSessionHolder
    extends SessionHolder<JdbcConsole, Parameters> {
        public static final ScriptingJdbcSessionHolder INSTANCE = new ScriptingJdbcSessionHolder();
        private static final Key<List<JdbcConsole>> DATABASE_CONSOLE_LIST = Key.create((String)"DATABASE_CONSOLE_LIST");

        protected ScriptingJdbcSessionHolder() {
            super(JdbcConsole.class);
        }

        @Nullable
        public JdbcConsole getMaybeAttachedSession(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(0);
            }
            JdbcConsole console = (JdbcConsole)this.getSession(e);
            return e.getData(Session.SESSION_KEY) == null && console == null ? JdbcConsoleProvider.getAttachedConsole(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) : console;
        }

        @Nullable
        public JdbcConsole getMaybeAttachedSession(@Nullable Project project, @Nullable VirtualFile file) {
            JdbcConsole console = (JdbcConsole)this.getSession(project, file);
            return console != null ? console : JdbcConsoleProvider.getAttachedConsole(project, file);
        }

        @Override
        @NotNull
        protected JdbcConsole getSessionInner(@NotNull Parameters parameters) {
            if (parameters == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(1);
            }
            JdbcConsole jdbcConsole = new JdbcConsole(parameters.consoleView, parameters.messageBus, parameters.dataSource, parameters.query);
            if (jdbcConsole == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(2);
            }
            return jdbcConsole;
        }

        @Override
        @NotNull
        protected List<JdbcConsole> getActiveSessions(@NotNull Project project) {
            Key<List<JdbcConsole>> key2;
            List data;
            if (project == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(3);
            }
            if ((data = (List)project.getUserData(key2 = DATABASE_CONSOLE_LIST)) == null) {
                data = ContainerUtil.createLockFreeCopyOnWriteList();
                project.putUserData(key2, (Object)data);
                DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                    public void modificationCountChanged(DbPsiFacade dbFacade) {
                        Project project = dbFacade.getProject();
                        List validAndInvalidConsoles = ContainerUtil.notNullize((List)((List)project.getUserData(DATABASE_CONSOLE_LIST)));
                        for (JdbcConsole console : validAndInvalidConsoles) {
                            if (!JdbcConsole.isDataSourceValid(dbFacade, (DatabaseSystem)console.getTarget())) continue;
                            console.updateTitle();
                        }
                    }
                }, (Disposable)project);
            }
            Iterator it = data.iterator();
            while (it.hasNext()) {
                JdbcConsole console = (JdbcConsole)it.next();
                if (console.isValid()) continue;
                it.remove();
                TransactionGuard.submitTransaction((Disposable)project, () -> Disposer.dispose((Disposable)console));
            }
            List list = data;
            if (list == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        protected void register(@NotNull Project project, @NotNull JdbcConsole session) {
            if (project == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(5);
            }
            if (session == null) {
                ScriptingJdbcSessionHolder.$$$reportNull$$$0(6);
            }
            this.getActiveSessions(project).add(session);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$ScriptingJdbcSessionHolder";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$ScriptingJdbcSessionHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSessionInner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveSessions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaybeAttachedSession";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSessionInner";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getActiveSessions";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class Parameters
        extends SessionHolder.Parameters {
            final LanguageConsoleView consoleView;
            final LocalDataSource dataSource;
            final String query;

            Parameters(@NotNull Project project, @NotNull LanguageConsoleView consoleView, @NotNull DataBus.Consuming messageBus, @NotNull LocalDataSource dataSource, @Nullable String query) {
                if (project == null) {
                    Parameters.$$$reportNull$$$0(0);
                }
                if (consoleView == null) {
                    Parameters.$$$reportNull$$$0(1);
                }
                if (messageBus == null) {
                    Parameters.$$$reportNull$$$0(2);
                }
                if (dataSource == null) {
                    Parameters.$$$reportNull$$$0(3);
                }
                super(project, messageBus);
                this.consoleView = consoleView;
                this.dataSource = dataSource;
                this.query = query;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consoleView";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "messageBus";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/JdbcConsole$ScriptingJdbcSessionHolder$Parameters";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface SearchPathReceiver
    extends EventListener,
    Disposable {
        public void receive(@Nullable SearchPath var1);
    }

    public static interface SearchPathSender {
        public void subscribe(@NotNull SearchPathReceiver var1);
    }

    public static interface RawErrorsObtainer
    extends DataAuditor,
    Disposable {
        public boolean obtainErrors(@NotNull DataRequest.Context var1, @NotNull String var2);
    }

    public static class Builder {
        Project myProject;
        private String myQuery;
        private VirtualFile myVirtualFile;
        private DatabaseSystem myInfo;

        public Builder(Project project) {
            this.myProject = project;
        }

        public Builder withQuery(CharSequence query) {
            this.myQuery = query == null ? null : query.toString();
            return this;
        }

        public Builder forFile(VirtualFile file) {
            this.myVirtualFile = file;
            return this;
        }

        public Builder fromDataSource(DatabaseSystem info) {
            this.myInfo = info;
            return this;
        }

        @NotNull
        public JdbcConsole buildAndShow(boolean focused) {
            JdbcConsole console = this.build();
            console.showConsole(focused);
            ValueLookupManager instance = ValueLookupManager.getInstance((Project)this.myProject);
            if (instance != null) {
                instance.startListening();
            }
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(0);
            }
            return jdbcConsole;
        }

        @NotNull
        public JdbcConsole build() {
            LocalDataSource dataSource = DbImplUtil.getLocalDataSource(this.myInfo);
            VirtualFile file = this.myVirtualFile != null ? this.myVirtualFile : DatabaseEditorHelper.getConsoleVirtualFile(this.myInfo);
            LOG.assertTrue(file != null, (Object)"Console file is not available");
            BaseJdbcSession existing = (BaseJdbcSession)JBIterable.from(AbstractQueryLanguageConsole.getActiveSessions(this.myProject, BaseJdbcSessionView.SESSION_TOOLWINDOW_ID)).find(s -> s.getVirtualFile().equals(file));
            LOG.assertTrue(existing == null, (Object)("Console already created for " + file.getName()));
            String title = JdbcConsole.getTitle(this.myProject, file);
            SimpleRequestBroker broker = SimpleRequestBroker.newInstance(this.myProject, title);
            LanguageConsoleImpl consoleView = new LanguageConsoleImpl(this.myProject, title, file);
            ScriptingJdbcSessionHolder.Parameters parameters = new ScriptingJdbcSessionHolder.Parameters(this.myProject, (LanguageConsoleView)consoleView, broker, dataSource, this.myQuery);
            JdbcConsole console = (JdbcConsole)ScriptingJdbcSessionHolder.INSTANCE.openSession(parameters);
            JdbcEngine engine = new JdbcEngine(this.myProject, broker, dataSource, null);
            Disposer.register((Disposable)console, (Disposable)engine);
            DataAuditor obtainer = JdbcConsole.createAdvancedErrorsObtainer(dataSource, console.getHistoryLogger());
            if (obtainer != null) {
                if (obtainer instanceof Disposable) {
                    Disposer.register((Disposable)console, (Disposable)((Disposable)obtainer));
                }
                console.getMessageBus().addAuditor(obtainer);
            }
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return jdbcConsole;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/console/JdbcConsole$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildAndShow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

