/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.JdbcTemplateLexer;
import com.intellij.database.dataSource.url.template.TemplateToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcTemplateParser {
    private static final Set<IElementType> SEQUENCE_END = ContainerUtil.set((Object[])new IElementType[]{TemplateToken.GROUP_END, TemplateToken.OPT_GROUP_END, TemplateToken.LIST_END, TemplateToken.SEPARATOR});
    private final EventProcessor myProcessor;
    private final JdbcTemplateLexer myLexer;
    private final StringBuffer myBuffer;

    public static boolean parse(@NotNull String text, EventProcessor processor) {
        if (text == null) {
            JdbcTemplateParser.$$$reportNull$$$0(0);
        }
        return new JdbcTemplateParser(text, processor).parse();
    }

    private JdbcTemplateParser(@NotNull String text, @Nullable EventProcessor processor) {
        if (text == null) {
            JdbcTemplateParser.$$$reportNull$$$0(1);
        }
        this.myLexer = new JdbcTemplateLexer();
        this.myLexer.start(text);
        this.myProcessor = processor;
        this.myBuffer = new StringBuffer();
    }

    private boolean parse() {
        if (!this.parseSequence()) {
            return false;
        }
        if (this.myLexer.getTokenType() != null) {
            return this.unexpectedToken("EOF");
        }
        return true;
    }

    private static IElementType group(boolean begin, boolean opt) {
        if (opt) {
            return begin ? TemplateToken.OPT_GROUP_BEGIN : TemplateToken.OPT_GROUP_END;
        }
        return begin ? TemplateToken.GROUP_BEGIN : TemplateToken.GROUP_END;
    }

    private boolean parseGroup(boolean opt) {
        if (!this.consumeToken(JdbcTemplateParser.group(true, opt), opt ? "[" : "(")) {
            return false;
        }
        if (this.myLexer.getTokenType() == JdbcTemplateParser.group(false, opt)) {
            this.myLexer.advance();
            return true;
        }
        this.processString();
        if (this.myProcessor != null) {
            this.myProcessor.processGroupStart();
        }
        if (!this.parseSequence()) {
            return false;
        }
        if (!this.consumeToken(JdbcTemplateParser.group(false, opt), opt ? "]" : ")")) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processGroupFinish();
            if (opt) {
                this.myProcessor.processOptionality();
            }
        }
        return true;
    }

    private boolean parseSequence() {
        IElementType elementType = this.myLexer.getTokenType();
        while (elementType != null && !SEQUENCE_END.contains(elementType)) {
            if (!this.parseSingle()) {
                return false;
            }
            elementType = this.myLexer.getTokenType();
        }
        this.processString();
        return true;
    }

    private boolean parseSingle() {
        IElementType elementType = this.myLexer.getTokenType();
        if (elementType == TemplateToken.CHAR) {
            if (!this.appendCharacter()) {
                return false;
            }
        } else if (elementType == TemplateToken.NEGATION) {
            if (!this.parseNegation()) {
                return false;
            }
        } else if (elementType == TemplateToken.LIST_BEGIN) {
            if (!this.parseList()) {
                return false;
            }
        } else if (elementType == TemplateToken.GROUP_BEGIN) {
            if (!this.parseGroup(false)) {
                return false;
            }
        } else if (elementType == TemplateToken.OPT_GROUP_BEGIN) {
            if (!this.parseGroup(true)) {
                return false;
            }
        } else if (elementType == TemplateToken.PARAM_BEGIN) {
            if (!this.parseParameter()) {
                return false;
            }
        } else if (elementType == TemplateToken.OPTIONALITY) {
            if (!this.parseOptionality()) {
                return false;
            }
        } else {
            return this.unexpectedToken(null);
        }
        return true;
    }

    private boolean parseNegation() {
        if (!this.consumeToken(TemplateToken.NEGATION, "!")) {
            return false;
        }
        this.processString();
        if (!this.parseSingle()) {
            return false;
        }
        this.processString();
        if (this.myProcessor != null) {
            this.myProcessor.processNegation();
        }
        return true;
    }

    private boolean parseList() {
        this.processString();
        if (!this.consumeToken(TemplateToken.LIST_BEGIN, "<")) {
            return false;
        }
        if (!this.parseListSeparator()) {
            return false;
        }
        if (!this.parseListBodies()) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processListFinish();
        }
        return this.consumeToken(TemplateToken.LIST_END, ">");
    }

    private boolean parseListBodies() {
        while (this.myLexer.getTokenType() != TemplateToken.LIST_END) {
            if (!this.consumeToken(TemplateToken.SEPARATOR, ",")) {
                return false;
            }
            if (!this.parseSequence()) {
                return false;
            }
            if (this.myProcessor == null) continue;
            this.myProcessor.processListBranch();
        }
        return true;
    }

    private boolean parseListSeparator() {
        while (this.myLexer.getTokenType() == TemplateToken.CHAR) {
            if (this.appendCharacter()) continue;
            return false;
        }
        if (this.myBuffer.length() == 0) {
            return this.parsingError("Expected list separator as first item");
        }
        if (this.myProcessor != null) {
            this.myProcessor.processListStart(this.myBuffer.toString());
        }
        this.myBuffer.setLength(0);
        return true;
    }

    private boolean parseOptionality() {
        if (!this.consumeToken(TemplateToken.OPTIONALITY, "?")) {
            return false;
        }
        if (this.myProcessor != null) {
            if (this.myBuffer.length() != 0) {
                if (this.myBuffer.length() != 1) {
                    this.myProcessor.processString(this.myBuffer.substring(0, this.myBuffer.length() - 1));
                }
                this.myProcessor.processString(this.myBuffer.substring(this.myBuffer.length() - 1, this.myBuffer.length()));
                this.myBuffer.setLength(0);
            }
            this.myProcessor.processOptionality();
        }
        return true;
    }

    private boolean parseParameter() {
        this.processString();
        if (!this.consumeToken(TemplateToken.PARAM_BEGIN, "{")) {
            return false;
        }
        String name = null;
        String type = null;
        String defValue = null;
        String configuration = null;
        if (this.myLexer.getTokenType() == TemplateToken.IDENTIFIER) {
            name = JdbcTemplateParser.unescape(this.myLexer.getTokenText());
            this.myLexer.advance();
        }
        if (this.myLexer.getTokenType() == TemplateToken.SEPARATOR) {
            this.myLexer.advance();
            if (this.myLexer.getTokenType() == TemplateToken.IDENTIFIER) {
                type = JdbcTemplateParser.unescape(this.myLexer.getTokenText());
                this.myLexer.advance();
            }
            if (name == null && type == null) {
                return this.parsingError("Name or type should be specified");
            }
            if (this.myLexer.getTokenType() == TemplateToken.SEPARATOR) {
                this.myLexer.advance();
                if (this.myLexer.getTokenType() == TemplateToken.IDENTIFIER) {
                    defValue = JdbcTemplateParser.unescape(this.myLexer.getTokenText());
                    this.myLexer.advance();
                } else {
                    defValue = "";
                }
                if (this.myLexer.getTokenType() == TemplateToken.SEPARATOR) {
                    this.myLexer.advance();
                    if (this.myLexer.getTokenType() == TemplateToken.IDENTIFIER) {
                        configuration = JdbcTemplateParser.unescape(this.myLexer.getTokenText());
                        this.myLexer.advance();
                    }
                }
            }
        } else if (name == null) {
            this.unexpectedToken("identifier or :");
            return false;
        }
        if (!this.consumeToken(TemplateToken.PARAM_END, "}")) {
            return false;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processParameter(name, type, defValue, configuration);
        }
        return true;
    }

    @NotNull
    private static String unescape(@NotNull String text) {
        if (text == null) {
            JdbcTemplateParser.$$$reportNull$$$0(2);
        }
        String string = StringUtil.unescapeStringCharacters((String)text);
        if (string == null) {
            JdbcTemplateParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean appendCharacter() {
        String text = this.myLexer.getTokenText();
        if (text.length() == 1) {
            this.myBuffer.append(text);
        } else if (text.length() == 2 && text.charAt(0) == '\\') {
            this.myBuffer.append(text.charAt(1));
        } else {
            return this.parsingError("Invalid character token `" + text + "`");
        }
        this.myLexer.advance();
        return true;
    }

    private void processString() {
        if (this.myBuffer.length() == 0) {
            return;
        }
        if (this.myProcessor != null) {
            this.myProcessor.processString(this.myBuffer.toString());
        }
        this.myBuffer.setLength(0);
    }

    private boolean consumeToken(@NotNull IElementType elementType, @NotNull String replacement) {
        IElementType current;
        if (elementType == null) {
            JdbcTemplateParser.$$$reportNull$$$0(4);
        }
        if (replacement == null) {
            JdbcTemplateParser.$$$reportNull$$$0(5);
        }
        if ((current = this.myLexer.getTokenType()) != elementType) {
            return this.unexpectedToken(replacement);
        }
        this.myLexer.advance();
        return true;
    }

    private boolean unexpectedToken(@Nullable String expected) {
        return this.parsingError("Unexpected token `" + this.myLexer.getTokenText() + (expected == null ? "`" : "` expected `" + expected + "`"));
    }

    private boolean parsingError(@NotNull String error2) {
        if (error2 == null) {
            JdbcTemplateParser.$$$reportNull$$$0(6);
        }
        if (this.myProcessor != null) {
            this.myProcessor.processError(error2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/JdbcTemplateParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/JdbcTemplateParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "consumeToken";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsingError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface EventProcessor {
        public void processString(@NotNull String var1);

        public void processGroupStart();

        public void processGroupFinish();

        public void processOptionality();

        public void processNegation();

        @Contract(value="null,null,_,_->fail")
        public void processParameter(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4);

        public void processError(@NotNull String var1);

        public void processListBranch();

        public void processListStart(@NotNull String var1);

        public void processListFinish();
    }
}

