/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfoCache;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpHostParamEditor
extends CompletionParamEditor<SsrpInfo.SsrpServer> {
    private static final Logger LOG = Logger.getInstance(SsrpHostParamEditor.class);
    public static final Key<SsrpInfo> SSRP_INFO = Key.create((String)"SSRP_INFO");
    public static final String SQLSERVER_DISCOVERY = "SQLSERVER_DISCOVERY";
    public static final Condition<SsrpInfo.SsrpServer> NO_ERROR = server -> server.getError() == null;
    public final Ref<String> myHost;

    public SsrpHostParamEditor(@NotNull String label, final @NotNull DataInterchange interchange) {
        if (label == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(1);
        }
        super(label, interchange);
        this.myHost = SsrpInfoCache.addHost();
        this.setUpdateTitle("Discovering reachable servers");
        this.setForceRefresh("Rediscover instances");
        this.setReportErrorOnAutoPopup(true);
        this.addUpdateOnShow();
        interchange.addUserDataListener(new DataInterchange.UserDataListener(){

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changed != SSRP_INFO) {
                    return;
                }
                SsrpInfo info = (SsrpInfo)SSRP_INFO.get((UserDataHolder)interchange);
                SsrpHostParamEditor.this.setVariantsAndCompletionVariants(info == null ? Collections.emptyList() : ContainerUtil.newArrayList(info.getServers()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor$1", "userDataChanged"));
            }
        }, this);
        SSRP_INFO.set((UserDataHolder)interchange, (Object)SsrpInfoCache.get());
        SsrpInfoCache.addListener(new SsrpInfoCache.Listener(){

            public void consume(SsrpConstants.SsrpException e) {
                if (e == null) {
                    SsrpInfo info = SsrpInfoCache.get();
                    GuiUtils.invokeLaterIfNeeded(() -> {
                        if (interchange == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        SSRP_INFO.set((UserDataHolder)interchange, (Object)info);
                    }, (ModalityState)ModalityState.defaultModalityState());
                } else {
                    LOG.warn((Throwable)e);
                    GuiUtils.invokeLaterIfNeeded(() -> {
                        if (interchange == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        interchange.showError(e.getMessage(), SsrpHostParamEditor.SQLSERVER_DISCOVERY);
                    }, (ModalityState)ModalityState.defaultModalityState());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "interchange";
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$consume$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$consume$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        ((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(editor -> {
            this.updateHighlighting((Editor)editor);
            editor.addFocusListener(new FocusChangeListener(){

                public void focusGained(Editor editor) {
                }

                public void focusLost(Editor editor) {
                    SsrpHostParamEditor.this.updateServerIfNotPresented();
                }
            });
        });
    }

    protected void updateHighlighting(@Nullable Editor editor) {
        String error2;
        if (editor == null) {
            return;
        }
        editor.getComponent().putClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING, Boolean.TRUE);
        DataSourceSshTunnelConfiguration sshConfiguration = this.getInterchange().getDataSource().getSshConfiguration();
        boolean unsupportedBrowsing = sshConfiguration != null && sshConfiguration.isEnabled();
        editor.getMarkupModel().removeAllHighlighters();
        SsrpInfo.SsrpServer item = this.getItemByText(this.getText());
        String string = error2 = item == null ? null : item.getError();
        if (unsupportedBrowsing || !"UnknownHost".equals(error2)) {
            editor.getContentComponent().setToolTipText("");
            return;
        }
        TextAttributesKey key2 = CodeInsightColors.ERRORS_ATTRIBUTES;
        editor.getContentComponent().setToolTipText("Error: Unknown host");
        TextAttributes attributes = editor.getColorsScheme().getAttributes(key2);
        editor.getMarkupModel().addRangeHighlighter(0, editor.getDocument().getTextLength(), 4000, attributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @Override
    protected void updateModelAtShow() {
        if (!SSRP_INFO.isIn((UserDataHolder)this.getInterchange())) {
            this.updateModelAsync();
        }
    }

    @Override
    @NotNull
    protected String getText(@NotNull SsrpInfo.SsrpServer item) {
        if (item == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(2);
        }
        String string = item.getName();
        if (string == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public SsrpInfo.SsrpServer getItemByText(@NotNull String text) {
        SsrpInfo info;
        if (text == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(4);
        }
        return (info = SsrpInfoCache.get()) == null ? null : info.getServer(text);
    }

    @Override
    protected void fireChanged() {
        this.myHost.set((Object)this.getText());
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
        super.fireChanged();
    }

    @Override
    @NotNull
    protected CompletionStage<List<SsrpInfo.SsrpServer>> getVariants(@NotNull Map<Key, ?> options, @NotNull ErrorHandler errorHandler) {
        if (options == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(5);
        }
        if (errorHandler == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(6);
        }
        SsrpInfoCache.update(false);
        SsrpInfo info = SsrpInfoCache.get();
        CompletableFuture<List<SsrpInfo.SsrpServer>> completableFuture = CompletableFuture.completedFuture(info == null ? Collections.emptyList() : ContainerUtil.newArrayList(info.getServers()));
        if (completableFuture == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    protected void updateServerIfNotPresented() {
        SsrpInfo.SsrpServer server = this.getItemByText(this.getText());
        if (server == null) {
            SsrpInfoCache.updateHost(true, this.getText());
        }
    }

    @Override
    protected void setVariants(@NotNull List<SsrpInfo.SsrpServer> variants) {
        if (variants == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(8);
        }
        super.setVariants(variants);
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }

    @Override
    protected void setCompletionVariants(@NotNull List<SsrpInfo.SsrpServer> variants) {
        if (variants == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(9);
        }
        super.setCompletionVariants(JBIterable.from(variants).filter(NO_ERROR).toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemByText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

