/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransactSqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected AbstractTransactSqlDialect(MetaModel metaModel, TypeHelper typeHelper, KeywordHelper keywordHelper, Casing casing) {
        super(metaModel, typeHelper, keywordHelper, casing);
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    protected String quoteIdentifierUnconditionally(@NotNull String name) {
        if (name == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(0);
        }
        return StringUtil.containsAnyChar((String)name, (String)"[]") ? super.quoteIdentifierUnconditionally(name) : '[' + name + ']';
    }

    @NotNull
    public abstract DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder var1, @NotNull DasColumn var2, boolean var3);

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        boolean typeChanged;
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(1);
        }
        if (from == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(2);
        }
        if (to == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(3);
        }
        int before = builder.getStatements().size();
        if (!AbstractTransactSqlDialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!AbstractTransactSqlDialect.isSameDefault(from, to)) {
            this.sqlAlterColumnDefault(builder, to).newStatement();
        }
        boolean bl = typeChanged = !this.isSameType(from, to);
        if (typeChanged || !AbstractTransactSqlDialect.isSameNullability(from, to)) {
            this.sqlAlterColumnTypeAndNullable(builder, to, typeChanged).newStatement();
        }
        if (!AbstractTransactSqlDialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!AbstractTransactSqlDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(5);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(6);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '_' && c0 != '#') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.comment.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(9);
        }
        if (from == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(10);
        }
        if (toName == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(11);
        }
        DasTable table = from.getTable();
        builder.keyword("EXEC").space().ref(null, "sp_rename").space();
        String ref = builder.copied().qualifiedRef((DasObject)table).symbol(".").columnRef((DasObject)from).getStatement();
        builder.literal(DbSqlUtil.getSqlDialect(this).asStringLiteral(ref));
        builder.symbol(",").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(13);
        }
        if (column2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(15);
        }
        if (pk == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, true, false);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(18);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 2, false);
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"UNIQUE", "NON-UNIQUE"};
    }

    public String[] getIndexStorageOptions() {
        return new String[]{"NONCLUSTERED", "CLUSTERED"};
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(19);
        }
        if (column2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(21);
        }
        if (keyInfo == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(22);
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, false, this).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(24);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(26);
        }
        super.sqlDefineColumn(builder, column2, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoGenerated((DasColumn)column2) ? builder.space().keyword("IDENTITY") : builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsCreateDatabase() {
        return true;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(28);
        }
        if (table == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(29);
        }
        if (constraintName == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(30);
        }
        if (columns2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(31);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(constraint, constraintName).space();
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns2);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(33);
        }
        if (sequence == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(34);
        }
        if (increment == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(35);
        }
        if (minimum == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(36);
        }
        if (maximum == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(37);
        }
        if (restart == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(38);
        }
        if (cache2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(39);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(40);
        }
        if (index == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(41);
        }
        if (accessMethod == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(42);
        }
        if (tablespace == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(43);
        }
        if (constraints == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(44);
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, "");
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(46);
        }
        if (sequence == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(47);
        }
        if (increment == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(48);
        }
        if (minimum == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(49);
        }
        if (maximum == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(50);
        }
        if (start == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(51);
        }
        if (cache2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(52);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(53);
        }
        if (view == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(54);
        }
        if (definition == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(55);
        }
        if (checkOption == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(56);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view, definition, checkOption);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(57);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(58);
        }
        if (table == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(59);
        }
        if (constraintName == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(60);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(61);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(62);
        }
        if (table == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(63);
        }
        if (indexName == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(64);
        }
        builder.keywords("DROP", "INDEX").space();
        DasObject schema = DasUtil.getSchemaObject((DasObject)table);
        builder.qualifiedRef((DasObject)table, table.getName(), schema, DasUtil.getName((DasObject)schema), null, null, null, null).symbol(".").identifier((DasObject)index, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(65);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(66);
        }
        if (sequence == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(67);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(68);
        }
        if (view == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(69);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(71);
        }
        if (table == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(72);
        }
        if (newName == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(73);
        }
        builder.keyword("EXEC").space().ref(null, "sp_rename").space();
        String tableRef = builder.copied().qualifiedRef((DasObject)table).getStatement();
        builder.literal(DbSqlUtil.getSqlDialect(this).asStringLiteral(tableRef)).symbol(",").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(75);
        }
        if (view == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(76);
        }
        if (newName == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(77);
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view, newName);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(78);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(79);
        }
        if (sequence == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(80);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.DATABASE;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        Map<String, Object> map;
        Object db;
        if (system == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(81);
        }
        if (connection == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(82);
        }
        return (db = (map = DbImplUtil.resultRowAsMap(connection, "select db_name() as a", new String[0])).get("a")) == null ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)db.toString(), (ObjectKind)ObjectKind.DATABASE));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(83);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.DATABASE) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(84);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(85);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNullColumnString() {
        if (" NULL" == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(86);
        }
        return " NULL";
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(87);
        }
        if (column2 == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(88);
        }
        if (attrs == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(89);
        }
        DialectUtils.getAddColumnSQL(builder, column2, true, true, true);
        DdlBuilder ddlBuilder = DasUtil.isAutoGenerated((DasColumn)column2) ? builder.space().keyword("IDENTITY") : builder;
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(90);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DatabaseSystem system) {
        AbstractDatabaseDialect.LimitPlace limitPlace = AbstractDatabaseDialect.LimitPlace.BEGIN;
        if (limitPlace == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(91);
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(92);
        }
        DdlBuilder ddlBuilder = AbstractTransactSqlDialect.top(builder, "TOP", rows);
        if (ddlBuilder == null) {
            AbstractTransactSqlDialect.$$$reportNull$$$0(93);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 45: 
            case 57: 
            case 61: 
            case 65: 
            case 70: 
            case 74: 
            case 78: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 45: 
            case 57: 
            case 61: 
            case 65: 
            case 70: 
            case 74: 
            case 78: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 33: 
            case 40: 
            case 46: 
            case 53: 
            case 58: 
            case 62: 
            case 66: 
            case 68: 
            case 71: 
            case 75: 
            case 79: 
            case 87: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 45: 
            case 57: 
            case 61: 
            case 65: 
            case 70: 
            case 74: 
            case 78: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/AbstractTransactSqlDialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: 
            case 14: 
            case 20: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 29: 
            case 59: 
            case 63: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 30: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 34: 
            case 47: 
            case 67: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 35: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 36: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 54: 
            case 69: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/AbstractTransactSqlDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPrimaryKey";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullColumnString";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifierUnconditionally";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 45: 
            case 57: 
            case 61: 
            case 65: 
            case 70: 
            case 74: 
            case 78: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 93: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPrimaryKey";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 45: 
            case 57: 
            case 61: 
            case 65: 
            case 70: 
            case 74: 
            case 78: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

