/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableEditorStructureViewModel
implements StructureViewModel {
    private final Project myProject;
    private final DataGrid myDataGrid;
    private final List<Object> myListeners;
    private final Disposable myDisposable;

    public TableEditorStructureViewModel(@NotNull TableEditorBase editor) {
        if (editor == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(0);
        }
        this(editor.getProject(), editor.getDataGrid());
    }

    public TableEditorStructureViewModel(@NotNull Project project, @NotNull DataGrid dataGrid) {
        if (project == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myDataGrid = dataGrid;
        this.myDataGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                for (Object listener : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener instanceof FileEditorPositionListener)) continue;
                    ((FileEditorPositionListener)listener).onCurrentElementChanged();
                }
            }

            @Override
            public void onContentChanged(DataGrid dataGrid) {
                for (Object listener : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener instanceof ModelListener)) continue;
                    ((ModelListener)listener).onModelChanged();
                }
            }
        }, this.myDisposable);
    }

    @Nullable
    public Object getCurrentEditorElement() {
        ModelIndex<DataConsumer.Column> column2 = this.myDataGrid.getSelectionModel().getSelectedColumn();
        return column2.isValid(this.myDataGrid) ? DataGridPomTarget.wrapColumn(this.myProject, this.myDataGrid, column2) : null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener);
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(5);
        }
        this.myListeners.add(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(6);
        }
        this.myListeners.remove(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        RootElement rootElement = new RootElement();
        if (rootElement == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(7);
        }
        return rootElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(8);
        }
        return Grouper.EMPTY_ARRAY;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(9);
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(10);
        }
        return Filter.EMPTY_ARRAY;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/TableEditorStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/TableEditorStructureViewModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEditorPositionListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorPositionListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GenElement
    extends PsiTreeElementBase<DbElement>
    implements LocationPresentation,
    WeighedItem {
        private GenElement(DbElement element) {
            super((PsiElement)element);
        }

        public void navigate(boolean requestFocus) {
            DbElement element = (DbElement)this.getElement();
            if (element == null) {
                return;
            }
            DatabaseView.select((PsiElement)element, requestFocus);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                GenElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            DbElement element = (DbElement)this.getElement();
            return element == null ? null : DbPresentation.getPresentableName((DasObject)element, true);
        }

        public Icon getIcon(boolean open) {
            DbElement element = (DbElement)this.getElement();
            return element == null ? null : DbPresentation.getIcon((DasObject)element);
        }

        public int getWeight() {
            DbElement element = (DbElement)this.getElement();
            return element == null ? 0 : DbPresentation.getWeight(element, true);
        }

        public String getLocationString() {
            DbElement element = (DbElement)this.getElement();
            if (element == null) {
                return null;
            }
            return element instanceof DasTypedObject ? ((DasTypedObject)element).getDataType().getSpecification() : "";
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$GenElement", "getChildrenBase"));
        }
    }

    private static class ColElement
    extends PsiTreeElementBase<PsiElement>
    implements ColoredItemPresentation,
    LocationPresentation {
        private ColElement(PsiElement element) {
            super(element);
        }

        public void navigate(boolean requestFocus) {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return;
            }
            target.navigate(requestFocus);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                ColElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            DataConsumer.Column column2 = target != null ? target.getColumn() : null;
            return column2 != null ? column2.name : null;
        }

        public Icon getIcon(boolean open) {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return DatabaseIcons.Col;
            }
            DasColumn dbColumn = DataGridUtil.getDatabaseColumn(target.dataGrid, target.getColumn());
            return dbColumn == null ? null : DbPresentation.getIcon((DasObject)dbColumn);
        }

        public String getLocationString() {
            char arrow;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return null;
            }
            DataGrid dataGrid = target.dataGrid;
            String sqlType = DataGridUtil.getSqlType(dataGrid, target.getColumn());
            RowSortOrder.Type sortOrder = dataGrid.getSortOrder(target.column);
            int thenBySortOrder = dataGrid.getThenBySortOrder(target.column);
            if (sortOrder == RowSortOrder.Type.UNSORTED || thenBySortOrder == 0) {
                return sqlType;
            }
            boolean isAscending = sortOrder == RowSortOrder.Type.ASC;
            char c = arrow = isAscending ? (char)'\u2191' : '\u2193';
            String ordering = UIUtil.getLabelFont().canDisplay(arrow) ? String.valueOf(arrow) : (isAscending ? "A-" : "D-");
            return (StringUtil.isEmpty((String)sqlType) ? "" : sqlType + " ") + ordering + thenBySortOrder;
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            ModelIndex<DataConsumer.Column> column2 = target != null ? target.column : null;
            return column2 != null && !target.dataGrid.isColumnEnabled(column2) ? DatabaseColors.STRUCTURE_HIDDEN_COLUMN : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$ColElement", "getChildrenBase"));
        }
    }

    private class RootElement
    implements StructureViewTreeElement {
        private RootElement() {
        }

        public Object getValue() {
            return this;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = new PresentationData();
            if (presentationData == null) {
                RootElement.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        @NotNull
        public TreeElement[] getChildren() {
            List columns2;
            GridModel model = TableEditorStructureViewModel.this.myDataGrid.getDataModel(DataAccessType.DATABASE_DATA);
            List columns3 = model.getColumnIndices().asList();
            if (!columns3.isEmpty()) {
                TreeElement[] result2 = new TreeElement[columns3.size()];
                for (int i2 = 0; i2 < result2.length; ++i2) {
                    result2[i2] = new ColElement(DataGridPomTarget.wrapColumn(TableEditorStructureViewModel.this.myProject, TableEditorStructureViewModel.this.myDataGrid, (ModelIndex)columns3.get(i2)));
                }
                if (result2 == null) {
                    RootElement.$$$reportNull$$$0(1);
                }
                return result2;
            }
            DasTable table = DataGridUtil.getDatabaseTable(TableEditorStructureViewModel.this.myDataGrid);
            List list = columns2 = table == null ? Collections.emptyList() : table.getDasChildren(ObjectKind.COLUMN).filter(DbElement.class).toList();
            if (!columns2.isEmpty()) {
                TreeElement[] result3 = new TreeElement[columns2.size()];
                for (int i3 = 0; i3 < result3.length; ++i3) {
                    result3[i3] = new GenElement((DbElement)columns2.get(i3));
                }
                if (result3 == null) {
                    RootElement.$$$reportNull$$$0(2);
                }
                return result3;
            }
            if (EMPTY_ARRAY == null) {
                RootElement.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/editor/TableEditorStructureViewModel$RootElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

