/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresForeignServer
extends BasicScriptable,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SERVER;
        if (objectKind == null) {
            PostgresForeignServer.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public PostgresForeignDataWrapper getForeignDataWrapper();

    @Override
    @Nullable
    default public PostgresForeignDataWrapper getParent() {
        return this.getForeignDataWrapper();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends PostgresForeignServer> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends PostgresUserMapping> getUserMappings();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.USER_MAPPING);
        if (list == null) {
            PostgresForeignServer.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<NamingIdentifyingFamily<? extends PostgresUserMapping>> list = Collections.singletonList(this.getUserMappings());
        if (list == null) {
            PostgresForeignServer.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Nullable
    default public String getType() {
        return null;
    }

    @Nullable
    default public String getVersion() {
        return null;
    }

    @NotNull
    default public List<String> getOptions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PostgresForeignServer.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> options;
        String version;
        String type;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            PostgresForeignServer.$$$reportNull$$$0(4);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((type = this.getType()) != null) {
            consumer.accept("Type", PropertyConverter.export(type));
        }
        if ((version = this.getVersion()) != null) {
            consumer.accept("Version", PropertyConverter.export(version));
        }
        if (!(options = this.getOptions()).isEmpty()) {
            consumer.accept("Options", PropertyConverter.exportListOfString(options));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Type", "Version", "Options");
        if (list == null) {
            PostgresForeignServer.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresForeignServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresForeignServer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

