/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPsiFacadeImpl
extends DbPsiFacade {
    private final Project myProject;
    private final EventDispatcher<ModificationTrackerListener> myDispatcher;
    private final Map<DatabaseSystem, DbDataSource> myDataSourceMap;
    private volatile State myState;
    private final Alarm myAlarm;

    public DbPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
        this.myDataSourceMap = ContainerUtil.createWeakMap();
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
    }

    @NotNull
    public List<DbPsiManager> getDbManagers() {
        List<DbPsiManager> list = this.getState().managers;
        if (list == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void clearCaches(@Nullable DbDataSource selectedElement) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.incModificationCount();
        if (selectedElement == null) {
            State state = this.myState;
            this.myState = null;
            if (state != null) {
                for (DbDataSource source : state.dataSources) {
                    source.clearCaches();
                }
            }
        } else {
            selectedElement.clearCaches();
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this);
            PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)this.getProject());
            String id = selectedElement == null ? null : selectedElement.getUniqueId();
            for (VirtualFile file : fileEditorManagerEx.getOpenFiles()) {
                DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)((Object)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class)));
                if (dbFile == null || id != null && !Comparing.equal((String)dbFile.getDataSourceId(), (String)id) || !dbFile.isValid()) continue;
                fileEditorManagerEx.updateFilePresentation(file);
            }
        }, 300, ModalityState.NON_MODAL);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public List<DbDataSource> getDataSources() {
        List<DbDataSource> list = this.getState().dataSources;
        if (list == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public DbDataSource findDataSource(@Nullable String id) {
        return this.getState().dataSourcesMap.get(id);
    }

    @Nullable
    public DbDataSource findDataSource(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return ((DbElement)o).getDataSource();
        }
        if (o instanceof BasicElement) {
            BasicModel model = ((BasicElement)o).getModel();
            if (model == null) {
                return null;
            }
            return this.getState().rootsMap.get(model.getRoot());
        }
        return this.getState().rootsMap.get(DasUtil.dasParents((DasObject)o).last());
    }

    @Nullable
    public DbElement findElement(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return (DbElement)o;
        }
        DbDataSource dataSource = this.findDataSource(o);
        return dataSource == null ? null : DbImplUtil.findElement(dataSource, o);
    }

    public void addModificationTrackerListener(@NotNull ModificationTrackerListener<DbPsiFacade> listener, @NotNull Disposable parent) {
        if (listener == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener(listener, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DbDataSource createDataSourceWrapperElement(@NotNull DatabaseSystem info, @NotNull DbPsiManagerSpi manager) {
        if (info == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(7);
        }
        Map<DatabaseSystem, DbDataSource> map = this.myDataSourceMap;
        // MONITORENTER : map
        DbDataSource dataSource = this.myDataSourceMap.get(info);
        if (dataSource == null) {
            dataSource = new DbDataSourceImpl(this.getProject(), info, manager);
            this.myDataSourceMap.put(info, dataSource);
        }
        DbDataSource dbDataSource = dataSource;
        // MONITOREXIT : map
        if (dbDataSource != null) return dbDataSource;
        DbPsiFacadeImpl.$$$reportNull$$$0(8);
        return dbDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private State getState() {
        State state;
        State curState = this.myState;
        if (curState != null) {
            State state2 = curState;
            if (state2 == null) {
                DbPsiFacadeImpl.$$$reportNull$$$0(9);
            }
            return state2;
        }
        if (this.myProject.isDefault()) {
            state = new State(Collections.emptyList(), Collections.emptyList());
        } else {
            DbPsiManagerSpi[] managers = (DbPsiManagerSpi[])Extensions.getExtensions(DbPsiManagerSpi.EP_NAME, (AreaInstance)this.myProject);
            ArrayList result2 = ContainerUtil.newArrayList();
            for (DbPsiManagerSpi manager : managers) {
                result2.addAll(manager.getDataSources());
            }
            state = new State((List<DbPsiManagerSpi>)ContainerUtil.immutableList((Object[])managers), (List<DbDataSource>)ContainerUtil.immutableList((List)result2));
        }
        this.myState = state;
        Map<DatabaseSystem, DbDataSource> map = this.myDataSourceMap;
        synchronized (map) {
            this.myDataSourceMap.values().retainAll(state.dataSources);
        }
        State state3 = state;
        if (state3 == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        return state3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPsiFacadeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPsiFacadeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbManagers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceWrapperElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModificationTrackerListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceWrapperElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class State {
        final List<DbPsiManagerSpi> managers;
        final List<DbDataSource> dataSources;
        final Map<String, DbDataSource> dataSourcesMap;
        final Map<DasObject, DbDataSource> rootsMap;

        State(@NotNull List<DbPsiManagerSpi> managers, @NotNull List<DbDataSource> dataSources2) {
            if (managers == null) {
                State.$$$reportNull$$$0(0);
            }
            if (dataSources2 == null) {
                State.$$$reportNull$$$0(1);
            }
            this.managers = managers;
            this.dataSources = dataSources2;
            this.dataSourcesMap = dataSources2.isEmpty() ? Collections.emptyMap() : new THashMap();
            for (DbDataSource dataSource : dataSources2) {
                this.dataSourcesMap.put(dataSource.getUniqueId(), dataSource);
            }
            this.rootsMap = ConcurrentFactoryMap.createMap(key2 -> {
                for (DbDataSource o : this.dataSources) {
                    DasModel model = o.getDelegate().getModel();
                    if (model instanceof BasicModel) {
                        if (((BasicModel)model).getRoot() != key2) continue;
                        return o;
                    }
                    for (DasObject root2 : model.getModelRoots()) {
                        if (root2 != key2 && root2.getDasParent() != key2) continue;
                        return o;
                    }
                }
                return null;
            }, () -> ContainerUtil.createConcurrentWeakKeyWeakValueMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "managers";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSources";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/psi/DbPsiFacadeImpl$State";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

