/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.sql.psi.SqlElement;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    private static final String SEARCH_FOR_STORAGE_OCCURRENCES = "sql.rename.search.for.storage.occurrences";
    private static final Logger LOG = Logger.getInstance(DbRenamePsiElementProcessor.class);
    private static Function<String, CompletionStage<Void>> ourRunStatementsHook = null;

    public static void setRunStatementsHook(Function<String, CompletionStage<Void>> runStatementsHook) {
        ourRunStatementsHook = runStatementsHook;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if (element instanceof DbElement) {
            DbElement dbElement = (DbElement)element;
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
            if (dbElement.getKind() == ObjectKind.VIEW) {
                return dialect.supportsRenameView();
            }
            if (dbElement.getKind() == ObjectKind.ROUTINE && ((DasRoutine)dbElement).getPackageName() == null) {
                return dialect.supportsRenameRoutine();
            }
            if (dbElement.getKind() == ObjectKind.SCHEMA) {
                return dialect.supportsRenameSchema();
            }
            if (dbElement.getKind() == ObjectKind.DATABASE) {
                return dialect.supportsRenameDatabase();
            }
            DatabaseEditorCapabilities.DbEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps();
            DatabaseEditorCapabilities.ObjectEditorCaps modifyCaps = caps.getModifyCaps(dbElement.getKind());
            return modifyCaps != null && modifyCaps.getRename().isAvailable();
        }
        return false;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        if (!(element instanceof DbElement) || DbSqlUtil.isSqlElement((DbElement)element)) {
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
            if (renameDialog == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(3);
            }
            return renameDialog;
        }
        DbRenameDialog dbRenameDialog = new DbRenameDialog(project, element, nameSuggestionContext, editor);
        if (dbRenameDialog == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(4);
        }
        return dbRenameDialog;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        return (PsiElement)ObjectUtils.chooseNotNull((Object)DbSqlUtil.getSqlElement((DbElement)ObjectUtils.tryCast((Object)element, DbElement.class)), (Object)element);
    }

    public static String generateStatement(DdlBuilder baseBuilder, Object delegate, String newName) {
        Object object;
        if (!(delegate instanceof DasObject)) {
            return "";
        }
        DasObject dasObject = (DasObject)delegate;
        DasObject parent = dasObject.getDasParent();
        DatabaseEditorContext context = new DatabaseEditorContext(null, baseBuilder.getDialect(), DasUtil.emptyModel(), null, null, null);
        SchemaEditorHelper helper = new SchemaEditorHelper(context);
        SchemaExportHelper eh = helper.createExportHelper(DasUtil.emptyModel()).chained();
        if (parent instanceof DasTable) {
            eh.exportDeep(DasUtil.emptyModel(), parent, true);
        }
        if ((object = eh.exportDeep(DasUtil.emptyModel(), dasObject, true)) == null) {
            return "";
        }
        ((DeObject)object).name = newName;
        helper.alter(((DeObject)object).model);
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(false).configureFrom(baseBuilder);
        helper.generate(builder, (DeModel)((DeObject)object).model.getModel());
        return DatabaseDialogsHelper.concatQueries(builder);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        final boolean checkStorage = DbRenamePsiElementProcessor.getSearchReferencesInStorage(element.getProject());
        final String prefix = DbRenamePsiElementProcessor.getDbFsPrefix(element);
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(GlobalSearchScope.projectScope((Project)element.getProject())){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbSrcUtils.isDbSrcFile(file)) {
                    if (!checkStorage) {
                        return false;
                    }
                    if (DbSrcUtils.isOriginal(file)) {
                        return false;
                    }
                    if (!file.getPath().startsWith(prefix)) {
                        return false;
                    }
                }
                return super.contains(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbRenamePsiElementProcessor$1", "contains"));
            }
        };
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)scope).findAll();
        if (collection == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static String getDbFsPrefix(PsiElement element) {
        DbElement e = (DbElement)ObjectUtils.tryCast((Object)element, DbElement.class);
        String id = e == null ? null : e.getDataSource().getUniqueId();
        return DbSrcFileSystem.getDataSourcePath(element.getProject(), id) + "/";
    }

    @NotNull
    public static JBIterable<Pair<PsiElement, String>> collectRenameElements(@NotNull DeModel model, @Nullable DbDataSource dataSource) {
        if (model == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = DbRenamePsiElementProcessor.collectRenames(model).filterMap(de -> {
            PsiElement element = DbRenamePsiElementProcessor.getPsiElement(de, dataSource);
            return element == null ? null : Pair.create((Object)element, (Object)de.name);
        });
        if (jBIterable == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    public static boolean getSearchReferencesInStorage(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(SEARCH_FOR_STORAGE_OCCURRENCES, false);
    }

    public static void setSearchReferencesInStorage(Project project, boolean val) {
        PropertiesComponent.getInstance((Project)project).setValue(SEARCH_FOR_STORAGE_OCCURRENCES, val, false);
    }

    @NotNull
    public static JBIterable<DeObject> collectRenames(@NotNull DeModel model) {
        if (model == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        JBIterable jBIterable = model.traverser().filter(DeObject.class).filter(object -> {
            if (model == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(12);
            }
            return object.editedObject != null && !DasUtil.nameEqual((DasObject)object, (String)object.editedObject.getName(), (CasingProvider)model);
        });
        if (jBIterable == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DasObject object, @Nullable DbDataSource dataSource) {
        return (SqlElement)ObjectUtils.tryCast((Object)DbRenamePsiElementProcessor.getPsiElement(object, dataSource), SqlElement.class);
    }

    @Nullable
    public static DasObject unwrapDeElement(@Nullable DasObject object) {
        DasObject tmp = object;
        while (tmp instanceof DeObject) {
            tmp = ((DeObject)tmp).editedObject;
        }
        return tmp;
    }

    @Nullable
    public static PsiElement getPsiElement(@Nullable DasObject object, @Nullable DbDataSource dataSource) {
        DasObject tmp = DbRenamePsiElementProcessor.unwrapDeElement(object);
        if (tmp instanceof BasicElement) {
            if (dataSource == null) {
                return null;
            }
            tmp = ((DbDataSourceImpl)dataSource).findElement(tmp);
        }
        if (tmp instanceof DbElement) {
            DbElement db = (DbElement)tmp;
            SqlElement element = DbSqlUtil.getSqlElement(db);
            return element == null ? db : element;
        }
        if (tmp instanceof PsiElement) {
            return (PsiElement)tmp;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenameElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectRenameElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectRenames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectRenames$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyRenameProcessor
    extends RenameProcessor {
        private final DatabaseRefactoringHandler myHandler;
        private boolean myExecuteSql;
        private VirtualFile myExcludedFile;

        public MyRenameProcessor(@NotNull Project project, @NotNull PsiElement element, DatabaseRefactoringHandler handler, @NotNull String newName, @Nullable Iterable<Pair<PsiElement, String>> secondaryRenames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                MyRenameProcessor.$$$reportNull$$$0(0);
            }
            if (element == null) {
                MyRenameProcessor.$$$reportNull$$$0(1);
            }
            if (newName == null) {
                MyRenameProcessor.$$$reportNull$$$0(2);
            }
            super(project, element, newName, isSearchInComments, isSearchTextOccurrences);
            this.myExecuteSql = true;
            this.myHandler = handler;
            if (secondaryRenames != null) {
                for (Pair<PsiElement, String> rename : secondaryRenames) {
                    this.addElement((PsiElement)rename.first, (String)rename.second);
                    this.trackNamespaceRename((PsiElement)rename.first, (String)rename.second);
                }
            }
            this.trackNamespaceRename(element, newName);
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)element, DasObject.class);
            if (object != null) {
                this.myHandler.getContext().include(object.getDasParent());
            }
        }

        private void trackNamespaceRename(@NotNull PsiElement element, @NotNull String name) {
            if (element == null) {
                MyRenameProcessor.$$$reportNull$$$0(3);
            }
            if (name == null) {
                MyRenameProcessor.$$$reportNull$$$0(4);
            }
            if (!(element instanceof DasObject)) {
                return;
            }
            this.scheduleIntrospectionScopeUpdate((DasObject)element, name);
        }

        private void scheduleIntrospectionScopeUpdate(@NotNull DasObject object, @NotNull String newName) {
            if (object == null) {
                MyRenameProcessor.$$$reportNull$$$0(5);
            }
            if (newName == null) {
                MyRenameProcessor.$$$reportNull$$$0(6);
            }
            if (object.getKind() == ObjectKind.SCHEMA) {
                DasObject p = object.getDasParent();
                if (p != null && p.getKind() != ObjectKind.DATABASE) {
                    p = null;
                }
                ObjectName db = ObjectName.quoted((String)(p == null ? null : p.getName()));
                this.myHandler.getContext().getScopeUpdater().toRemove(db, ObjectName.quoted((String)object.getName()));
                this.myHandler.getContext().getScopeUpdater().toAdd(db, ObjectName.plain((String)newName));
            } else if (object.getKind() == ObjectKind.DATABASE) {
                this.myHandler.getContext().getScopeUpdater().toRemove(ObjectName.quoted((String)object.getName()), null);
                this.myHandler.getContext().getScopeUpdater().toAdd(ObjectName.plain((String)newName), null);
            }
        }

        protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
            if (viewDescriptor == null) {
                MyRenameProcessor.$$$reportNull$$$0(7);
            }
            if (usageView == null) {
                MyRenameProcessor.$$$reportNull$$$0(8);
            }
            super.customizeUsagesView(viewDescriptor, usageView);
            JPanel scriptPanel = new JPanel(new BorderLayout());
            scriptPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
            final JBCheckBox box = new JBCheckBox(UIUtil.replaceMnemonicAmpersand((String)"&Execute SQL Script"), this.myExecuteSql);
            box.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    myExecuteSql = box.isSelected();
                }
            });
            JButton manually = new JButton(new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)"&Open in Console")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (myExcludedFile == null) {
                        myExcludedFile = DbUIUtil.openInConsole(myHandler.getDataSource(), null, myHandler.getStatement(), false);
                    } else {
                        DbUIUtil.openInConsole(myHandler.getDataSource().getProject(), myExcludedFile, myHandler.getStatement(), null);
                    }
                    box.setSelected(false);
                }
            });
            scriptPanel.add((Component)box, "West");
            scriptPanel.add((Component)manually, "East");
            usageView.setAdditionalComponent((JComponent)scriptPanel);
        }

        protected void execute(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                MyRenameProcessor.$$$reportNull$$$0(9);
            }
            if (this.myExecuteSql) {
                this.runStatements(usages);
            } else {
                super.execute(usages);
            }
        }

        @NotNull
        protected CompletionStage<Void> runStatements(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                MyRenameProcessor.$$$reportNull$$$0(10);
            }
            CompletionStage<Void> execResult = null;
            if (ourRunStatementsHook != null) {
                execResult = (CompletionStage<Void>)ourRunStatementsHook.fun((Object)this.myHandler.getStatement());
            }
            if (execResult == null) {
                execResult = this.myHandler.runStatements(true);
            }
            CompletionStage<Void> completionStage = execResult.thenApplyAsync(res -> {
                if (usages == null) {
                    MyRenameProcessor.$$$reportNull$$$0(13);
                }
                super.execute(usages);
                return res;
            }, AsyncUtil.transactionExecutor((Disposable)this.myProject));
            if (completionStage == null) {
                MyRenameProcessor.$$$reportNull$$$0(11);
            }
            return completionStage;
        }

        @NotNull
        public UsageInfo[] findUsages() {
            JBIterable usages = JBIterable.of((Object[])super.findUsages());
            if (this.myExcludedFile != null) {
                usages = usages.filter(info -> !Comparing.equal((Object)info.getVirtualFile(), (Object)this.myExcludedFile));
            }
            List res = usages.toList();
            UsageInfo[] usageInfoArray = res.toArray(UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                MyRenameProcessor.$$$reportNull$$$0(12);
            }
            return usageInfoArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runStatements";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "trackNamespaceRename";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "scheduleIntrospectionScopeUpdate";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeUsagesView";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "runStatements";
                    break;
                }
                case 11: 
                case 12: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$runStatements$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbRenameDialog
    extends RenameDialog {
        private DdlPreview myDdlPreview;
        private DeObject myEdited;
        private DdlPreview.ModelTraverser myTraverser;
        private List<Pair<PsiElement, String>> myRenames;
        private JCheckBox myRenameInStorage;

        public DbRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
            if (project == null) {
                DbRenameDialog.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                DbRenameDialog.$$$reportNull$$$0(1);
            }
            super(project, psiElement, nameSuggestionContext, editor);
            this.myRenames = Collections.emptyList();
        }

        protected boolean areButtonsValid() {
            return true;
        }

        protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
            gbConstraints.insets = JBUI.insetsBottom((int)4);
            gbConstraints.gridwidth = 1;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            this.myRenameInStorage = new NonFocusableCheckBox(UIUtil.replaceMnemonicAmpersand((String)"Search in &loaded sources"));
            this.myRenameInStorage.setSelected(DbRenamePsiElementProcessor.getSearchReferencesInStorage(this.getProject()));
            panel.add((Component)this.myRenameInStorage, gbConstraints);
            super.createCheckboxes(panel, gbConstraints);
        }

        protected void doAction() {
            DbRenamePsiElementProcessor.setSearchReferencesInStorage(this.getProject(), this.myRenameInStorage.isSelected());
            super.doAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            PsiElement myElement = this.getPsiElement();
            if (myElement instanceof DbElement) {
                DbElement dbElement = (DbElement)myElement;
                PsiFile file = myElement.getContainingFile();
                DatabaseEditorContext context = new DatabaseEditorContext(dbElement, file == null ? null : file.getVirtualFile());
                SchemaEditor editor = context.getDialect().getSchemaEditor();
                SchemaExportHelper eh = editor.createExportHelper(context, context.getModel()).chained();
                if (!eh.canExport((DasObject)dbElement)) {
                    LOG.warn("Can't export " + dbElement.getClass().getName());
                    return null;
                }
                this.myEdited = eh.exportDeep(context.getModel(), (DasObject)dbElement, true);
                this.myTraverser = new DdlPreview.ModelTraverser(this.myEdited.model);
                JPanel panel = new JPanel(new BorderLayout());
                this.myDdlPreview = new DdlPreview(context, DatabaseDialogsHelper.createAsyncProcessor(this.getProject(), "Fetching DDL", () -> this.myDdlPreview.updatePreview(this.myTraverser)));
                this.myDdlPreview.updatePreview(this.myTraverser);
                panel.add((Component)SeparatorFactory.createSeparator((String)UIUtil.replaceMnemonicAmpersand((String)"SQL &Script"), (JComponent)this.myDdlPreview.getComponent()), "North");
                panel.add((Component)this.myDdlPreview.getComponent(), "Center");
                return panel;
            }
            return null;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        protected void processNewNameChanged() {
            this.updateName(this.getNewName(), true);
            super.processNewNameChanged();
        }

        private void updateName(String name, boolean later) {
            if (this.myEdited == null || Comparing.equal((String)this.myEdited.name, (String)name)) {
                return;
            }
            this.myEdited.name = name;
            DbElement element = (DbElement)ObjectUtils.tryCast((Object)this.getPsiElement(), DbElement.class);
            this.myRenames = DbRenamePsiElementProcessor.collectRenameElements(this.myEdited.model, element == null ? null : element.getDataSource()).toList();
            if (later) {
                ApplicationManager.getApplication().invokeLater(() -> this.myDdlPreview.updatePreview(this.myTraverser));
            } else {
                this.myDdlPreview.updatePreview(this.myTraverser);
            }
        }

        protected void canRun() throws ConfigurationException {
            if (this.myRenames == null || this.myRenames.isEmpty()) {
                throw new ConfigurationException("Nothing to rename");
            }
            super.canRun();
        }

        protected RenameProcessor createRenameProcessor(String newName) {
            this.updateName(newName, false);
            DatabaseRefactoringHandler handler = this.createHandler();
            Pair<PsiElement, String> r = this.myRenames.get(0);
            return new MyRenameProcessor(this.getProject(), (PsiElement)r.first, handler, (String)r.second, this.myRenames.subList(1, this.myRenames.size()), this.isSearchInComments(), this.isSearchInNonJavaFiles());
        }

        private DatabaseRefactoringHandler createHandler() {
            DbElement element = (DbElement)this.getPsiElement();
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(element.getDataSource(), this.myDdlPreview.getContext().getSearchPath()).setStatement(this.myDdlPreview.getPreviewText());
            handler.getContext().include(element);
            return handler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

