/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.session.SessionView;
import com.intellij.database.run.ui.ParametersPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ParametersHolder
implements Disposable {
    protected static final String ID_PARAMETERS = "Parameters";
    private final ScriptModel.PStorage myPStorage;
    private final Project myProject;
    private final SessionView<?> myView;
    private final Alarm myUpdateAlarm;
    private final ParametersPanel myParamPanel;
    private final Content myParamPanelContent;
    private boolean myState;

    public ParametersHolder(@NotNull Project project, @NotNull SessionView<?> view, @NotNull ScriptModel<?> scriptModel) {
        if (project == null) {
            ParametersHolder.$$$reportNull$$$0(0);
        }
        if (view == null) {
            ParametersHolder.$$$reportNull$$$0(1);
        }
        if (scriptModel == null) {
            ParametersHolder.$$$reportNull$$$0(2);
        }
        this.myPStorage = ScriptModel.PStorage.newStorage();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myState = false;
        this.myProject = project;
        this.myView = view;
        this.myParamPanel = new MyParametersPanel(this, scriptModel, this.myPStorage, view.getConsoleView());
        this.myUpdateAlarm.setActivationComponent((JComponent)this.myParamPanel);
        String title = DatabaseMessages.message((String)"jdbc.console.tab.title.parameters", (Object[])new Object[0]);
        JComponent toFocus = this.myParamPanel.getPreferredFocusedComponent();
        this.myParamPanelContent = this.myView.getUi().createContent(ID_PARAMETERS, (JComponent)this.myParamPanel, title, PlatformIcons.PARAMETER_ICON, toFocus);
        this.myParamPanelContent.setCloseable(false);
        Disposer.register((Disposable)this, (Disposable)this.myParamPanelContent);
        Disposer.register(view, (Disposable)this);
    }

    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> model) {
        boolean forceShowParams;
        if (model == null) {
            ParametersHolder.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.myParamPanel.commit();
        if (model.statements().isEmpty()) {
            return false;
        }
        boolean bl = forceShowParams = !model.getVirtualFile().equals(this.myView.getConsoleView().getVirtualFile()) || DatabaseSettings.getSettings().alwaysReviewParameters;
        if ((forceShowParams && !model.parameters().isEmpty() || ParametersPanel.hasUnassignedParameters(model, this.myPStorage)) && !ParametersPanel.ensureAllParametersAreSet(this.myProject, ID_PARAMETERS, model, this.myPStorage)) {
            return false;
        }
        this.myView.beforeExecution();
        return true;
    }

    public ParametersPanel getParamPanel() {
        return this.myParamPanel;
    }

    public ScriptModel.PStorage getPStorage() {
        return this.myPStorage;
    }

    public void dispose() {
    }

    @NotNull
    public AnAction initParameterView() {
        final LanguageConsoleView view = this.myView.getConsoleView();
        view.getEditorDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                ParametersHolder.this.myUpdateAlarm.cancelAllRequests();
                ParametersHolder.this.myUpdateAlarm.addComponentRequest(() -> {
                    ParametersHolder.this.myParamPanel.onModelUpdated();
                    ParametersHolder.this.myParamPanel.caretPositionChanged(view.getCurrentEditor().getCaretModel().getOffset());
                }, 300);
            }
        }, (Disposable)this);
        EditParameterAction editParameterAction = new EditParameterAction(view);
        JComponent shortcutTarget = view.getConsoleEditor().getComponent();
        editParameterAction.getTemplatePresentation().setVisible(false);
        editParameterAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), shortcutTarget);
        editParameterAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this.myParamPanel);
        this.myView.getUi().getOptions().setTabPopupActions(ParametersHolder.buildTabPopupGroup());
        ToggleParametersPanelAction toggleParametersPanelAction = new ToggleParametersPanelAction();
        if (toggleParametersPanelAction == null) {
            ParametersHolder.$$$reportNull$$$0(4);
        }
        return toggleParametersPanelAction;
    }

    private static ActionGroup buildTabPopupGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TabPopupGroup");
    }

    private void toggleParamContent(boolean state) {
        if (state == this.myState) {
            return;
        }
        this.myState = state;
        if (state) {
            this.myParamPanel.onModelUpdated();
            this.myView.getUi().addContent(this.myParamPanelContent, 0, PlaceInGrid.right, false);
            if (!this.myView.isShowing()) {
                this.myView.show(true, false);
            }
            return;
        }
        RunnerContentUi contentUi = (RunnerContentUi)RunnerContentUi.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myView.getUi().getComponent()));
        if (contentUi != null) {
            contentUi.saveUiState();
        }
        ContentManager manager = this.myView.getUi().getContentManager();
        manager.removeContent(this.myParamPanelContent, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ParametersHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ParametersHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initParameterView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyParametersPanel
    extends ParametersPanel {
        private final List<RangeHighlighter> myHighlighters;
        private final LanguageConsoleView myView;
        private final Project myProject;

        MyParametersPanel(@NotNull ParametersHolder holder, @NotNull ScriptModel<?> model, @NotNull ScriptModel.PStorage storage, @NotNull LanguageConsoleView view) {
            if (holder == null) {
                MyParametersPanel.$$$reportNull$$$0(0);
            }
            if (model == null) {
                MyParametersPanel.$$$reportNull$$$0(1);
            }
            if (storage == null) {
                MyParametersPanel.$$$reportNull$$$0(2);
            }
            if (view == null) {
                MyParametersPanel.$$$reportNull$$$0(3);
            }
            super(view.getProject(), model, storage, holder);
            this.myView = view;
            this.myProject = view.getProject();
            this.myHighlighters = ContainerUtil.newArrayList();
        }

        @Override
        protected void selectRanges(Iterable<TextRange> ranges) {
            Editor[] editors;
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            for (Editor editor : editors = EditorFactory.getInstance().getEditors(this.myView.getEditorDocument(), this.myProject)) {
                editor.getSelectionModel().removeSelection();
                for (RangeHighlighter highlighter : this.myHighlighters) {
                    highlightManager.removeSegmentHighlighter(editor, highlighter);
                }
            }
            this.myHighlighters.clear();
            TextRange first = (TextRange)Iterables.getFirst(ranges, null);
            if (first == null) {
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myView.getVirtualFile(), first.getStartOffset());
            EditorColorsScheme colorScheme = this.myView.getCurrentEditor().getColorsScheme();
            TextAttributes attributes = colorScheme.getAttributes(DatabaseColors.CONSOLE_SELECTED_PARAMETER);
            for (Editor editor : editors) {
                for (TextRange range : ranges) {
                    highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, true, this.myHighlighters);
                }
                descriptor.navigateIn(editor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ParametersHolder$MyParametersPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ToggleParametersPanelAction
    extends ToggleAction {
        ToggleParametersPanelAction() {
            super("View Parameters", null, ParametersHolder.this.myParamPanelContent.getIcon());
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(AnActionEvent e) {
            return ParametersHolder.this.myState;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ParametersHolder.this.toggleParamContent(state);
        }
    }

    private class EditParameterAction
    extends DumbAwareAction {
        private final LanguageConsoleView myConsoleView;

        EditParameterAction(LanguageConsoleView view) {
            if (ParametersHolder.this == null) {
                EditParameterAction.$$$reportNull$$$0(0);
            }
            if (view == null) {
                EditParameterAction.$$$reportNull$$$0(1);
            }
            this.myConsoleView = view;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditParameterAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditParameterAction.$$$reportNull$$$0(3);
            }
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            EditorEx currentEditor = this.myConsoleView.getCurrentEditor();
            if (owner != null && SwingUtilities.isDescendingFrom(owner, currentEditor.getComponent())) {
                int offset = currentEditor.getCaretModel().getOffset();
                ParametersHolder.this.myView.show(true, true).done(aVoid -> {
                    ParametersHolder.this.toggleParamContent(true);
                    ParametersHolder.this.myParamPanel.tryEditParameterValue(offset);
                });
                return;
            }
            if (currentEditor.getContentComponent().isShowing()) {
                IdeFocusManager.getInstance((Project)ParametersHolder.this.myProject).requestFocus((Component)currentEditor.getContentComponent(), true);
                return;
            }
            if (this.myConsoleView.isConsoleEditorEnabled()) {
                return;
            }
            int offset = currentEditor.getCaretModel().getOffset();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(ParametersHolder.this.myProject, this.myConsoleView.getVirtualFile(), offset);
            FileEditorManager.getInstance((Project)ParametersHolder.this.myProject).openTextEditor(descriptor, true);
        }

        private boolean isEnabled() {
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            EditorEx currentEditor = this.myConsoleView.getCurrentEditor();
            boolean isEditorIsFocusOwner = owner != null && SwingUtilities.isDescendingFrom(owner, currentEditor.getComponent());
            int caretOffset = currentEditor.getCaretModel().getOffset();
            return !isEditorIsFocusOwner || ParametersHolder.this.myParamPanel.findParameterAtOffset(caretOffset) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ParametersHolder$EditParameterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }
}

