/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountRowsAction
extends IconWithTextAction
implements CustomComponentAction,
GridAction {
    public void actionPerformed(AnActionEvent e) {
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (grid != null) {
            CountRowsAction.countRows(grid);
        }
    }

    public void update(AnActionEvent e) {
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (grid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MyActionState state = CountRowsAction.getActionState(grid);
        CountRowsAction.updatePresentation(state, e.getPresentation());
        super.update(e);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ActionButtonWithText c = new ActionButtonWithText((AnAction)this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Color getInactiveTextColor() {
                return this.getForeground();
            }
        };
        return AlignedIconWithTextAction.align((JComponent)c);
    }

    public static AsyncFutureResult<Integer> countRows(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            CountRowsAction.$$$reportNull$$$0(0);
        }
        return CountRowsAction.countRows(hookUp, null);
    }

    public static AsyncFutureResult<Integer> countRows(@NotNull DataGrid grid) {
        if (grid == null) {
            CountRowsAction.$$$reportNull$$$0(1);
        }
        return CountRowsAction.countRows(grid.getDataHookup(), grid);
    }

    private static AsyncFutureResult<Integer> countRows(final @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp, @Nullable DataGrid grid) {
        if (hookUp == null) {
            CountRowsAction.$$$reportNull$$$0(2);
        }
        final AsyncFutureResult result2 = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource = new GridRequestSource<DataConsumer.Row, DataConsumer.Column>(grid, CountRowsAction.class.getName());
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)grid, (Object)hookUp.getProject())), (Disposable)disposable);
        hookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message, @Nullable Throwable th) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount) {
                if (source == null) {
                    2.$$$reportNull$$$0(1);
                }
                throw new AssertionError((Object)"Row count query should not modify data");
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (source != requestSource) {
                    return;
                }
                if (success) {
                    int rowCount = hookUp.getPageModel().getTotalRowCount();
                    result2.set((Object)rowCount);
                } else {
                    result2.setException((Throwable)new Exception("Row count update failed"));
                }
                Disposer.dispose((Disposable)disposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "source";
                objectArray2[1] = "com/intellij/database/run/actions/CountRowsAction$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
        hookUp.getLoader().updateTotalRowCount(requestSource);
        return result2;
    }

    private static void updatePresentation(MyActionState state, Presentation presentation) {
        MyActionState oldState = CountRowsAction.getActionState(presentation);
        if (oldState.equals(state)) {
            return;
        }
        presentation.setText(state.text);
        presentation.setDescription(state.description);
        presentation.setEnabled(state.enabled);
        presentation.setVisible(true);
        JComponent component = (JComponent)ObjectUtils.tryCast((Object)presentation.getClientProperty("customComponent"), JComponent.class);
        if (component != null) {
            component.setToolTipText(state.tooltip);
            component.repaint();
        }
    }

    @NotNull
    private static MyActionState getActionState(@NotNull Presentation presentation) {
        if (presentation == null) {
            CountRowsAction.$$$reportNull$$$0(3);
        }
        JComponent component = (JComponent)ObjectUtils.tryCast((Object)presentation.getClientProperty("customComponent"), JComponent.class);
        String text = presentation.getText();
        String description = presentation.getDescription();
        String tooltip = component != null ? component.getToolTipText() : null;
        boolean loading = presentation.isEnabled();
        MyActionState myActionState = new MyActionState(text, description, tooltip, loading);
        if (myActionState == null) {
            CountRowsAction.$$$reportNull$$$0(4);
        }
        return myActionState;
    }

    @NotNull
    private static MyActionState getActionState(@NotNull DataGrid grid) {
        boolean rowsWereDeleted;
        if (grid == null) {
            CountRowsAction.$$$reportNull$$$0(5);
        }
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        int pageStartIdx = pageModel.getPageStart();
        int pageEndIdx = pageModel.getPageEnd();
        int totalRowCount = pageModel.getTotalRowCount();
        boolean totalRowCountIsPrecise = pageModel.isTotalRowCountPrecise();
        boolean canUpdateTotalRowCount = pageModel.isTotalRowCountUpdateable();
        boolean bl = rowsWereDeleted = totalRowCount < pageEndIdx;
        String text = pageModel.isFirstPage() && pageModel.isLastPage() && !rowsWereDeleted ? totalRowCount + " row" + (totalRowCount == 1 ? "" : "s") : pageStartIdx + "-" + pageEndIdx + " of " + totalRowCount + (totalRowCountIsPrecise ? "" : "+");
        boolean querying = grid.getDataHookup().getBusyCount() > 0;
        boolean enabled = canUpdateTotalRowCount && !querying && grid.isReady();
        String description = "Click to update (runs SELECT COUNT(*) FROM ...)";
        String tooltip = "Click to count(*)";
        if (!enabled) {
            String unavailableText;
            description = unavailableText = canUpdateTotalRowCount && querying ? "Querying..." : "";
            tooltip = unavailableText;
        }
        MyActionState myActionState = new MyActionState(text, description, tooltip, enabled);
        if (myActionState == null) {
            CountRowsAction.$$$reportNull$$$0(6);
        }
        return myActionState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CountRowsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CountRowsAction";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "countRows";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionState";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyActionState {
        final String text;
        final String description;
        final String tooltip;
        final boolean enabled;

        private MyActionState(String text, String description, String tooltip, boolean enabled) {
            this.text = text;
            this.description = description;
            this.tooltip = tooltip;
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyActionState)) {
                return false;
            }
            MyActionState state = (MyActionState)o;
            if (this.enabled != state.enabled) {
                return false;
            }
            if (this.text != null ? !this.text.equals(state.text) : state.text != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(state.description) : state.description != null) {
                return false;
            }
            return !(this.tooltip != null ? !this.tooltip.equals(state.tooltip) : state.tooltip != null);
        }

        public int hashCode() {
            int result2 = this.text != null ? this.text.hashCode() : 0;
            result2 = 31 * result2 + (this.description != null ? this.description.hashCode() : 0);
            result2 = 31 * result2 + (this.tooltip != null ? this.tooltip.hashCode() : 0);
            result2 = 31 * result2 + (this.enabled ? 1 : 0);
            return result2;
        }
    }
}

