/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.scripting.ScriptGeneratorTool;
import com.intellij.database.scripting.ScriptGeneratorUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorTool;", "", "()V", "toolWindowId", "", "toolWindows", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/wm/ToolWindow;", "forgetProjectToolWindow", "", "project", "forgetProjectToolWindow$intellij_database_impl", "obtainDefaultContext", "Lcom/intellij/database/scripting/ScriptGeneratorUI;", "activate", "", "obtainToolWindow", "show", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "intellij.database.impl"})
public final class ScriptGeneratorTool {
    @NotNull
    public static final String toolWindowId = "SQL Generator";
    private static final ConcurrentMap<Project, ToolWindow> toolWindows;
    public static final ScriptGeneratorTool INSTANCE;

    public final void show(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        ScriptGeneratorUI context = this.obtainDefaultContext(project, true);
        context.getMainPanel$intellij_database_impl().setVisible(true);
        context.generate(model, nodes2);
    }

    private final ScriptGeneratorUI obtainDefaultContext(Project project, boolean activate) {
        ScriptGeneratorUI context;
        ToolWindow toolWindow = this.obtainToolWindow(project);
        if (activate) {
            toolWindow.activate((Runnable)obtainDefaultContext.1.INSTANCE);
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
        Content content = contentManager.getSelectedContent();
        if (content == null) {
            String string = "Database Scripting UI: no default content";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Content content2 = content;
        ScriptGeneratorUI scriptGeneratorUI = (ScriptGeneratorUI)content2.getUserData(ScriptGeneratorUI.Companion.getContextKey());
        if (scriptGeneratorUI == null) {
            String string = "Database Scripting UI: the default content is not assigned with a context";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ScriptGeneratorUI scriptGeneratorUI2 = context = scriptGeneratorUI;
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptGeneratorUI2, (String)"context");
        return scriptGeneratorUI2;
    }

    private final ToolWindow obtainToolWindow(Project project) {
        ToolWindow toolWindow = toolWindows.computeIfAbsent(project, new Function<Project, ToolWindow>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ToolWindow apply(Project it) {
                void var3_3;
                Content content;
                ContentManager contentManager;
                ToolWindow toolWindow;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.$project);
                ToolWindow toolWindow2 = toolWindow = toolWindowManager.registerToolWindow("SQL Generator", false, ToolWindowAnchor.BOTTOM, (Disposable)this.$project);
                if (toolWindow2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowImpl");
                }
                ((ToolWindowImpl)toolWindow2).setUseLastFocusedOnActivation(false);
                ScriptGeneratorUI defaultContext = new ScriptGeneratorUI(this.$project);
                ContentManager contentManager2 = contentManager = ((ToolWindowImpl)toolWindow).getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager2, (String)"contentManager");
                Content content2 = content = contentManager2.getFactory().createContent((JComponent)defaultContext.getMainPanel$intellij_database_impl(), "", false);
                Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"content");
                content2.setPreferredFocusableComponent((JComponent)defaultContext.getViewer$intellij_database_impl());
                content.putUserData(ScriptGeneratorUI.Companion.getContextKey(), (Object)defaultContext);
                contentManager.addContent(content);
                defaultContext.setContent$intellij_database_impl(content);
                Disposer.register((Disposable)((Disposable)this.$project), (Disposable)defaultContext);
                return var3_3;
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)toolWindow, (String)"toolWindows.computeIfAbs\u2026t)\n      toolWindow\n    }");
        return toolWindow;
    }

    public final void forgetProjectToolWindow$intellij_database_impl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        toolWindows.remove(project);
    }

    private ScriptGeneratorTool() {
    }

    static {
        ScriptGeneratorTool scriptGeneratorTool;
        INSTANCE = scriptGeneratorTool = new ScriptGeneratorTool();
        toolWindows = new ConcurrentHashMap();
    }
}

