/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilderUtils {
    private static final Logger LOG = Logger.getInstance(SqlModelBuilderUtils.class);

    public static void hardWarning(@NotNull String message) {
        Application app;
        if (message == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()) == null || app.isUnitTestMode()) {
            throw new AssertionError((Object)message);
        }
        LOG.warn(message);
    }

    @Nullable
    public static BasicModElement createObject(@NotNull BasicModElement parent, @NotNull String name, @Nullable String identity, @NotNull ObjectKind kind) {
        Object obj;
        Family family;
        if (parent == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(3);
        }
        if ((family = parent.familyOf(kind)) == null) {
            return null;
        }
        if (family instanceof ModSingletonFamily) {
            obj = ((ModSingletonFamily)family).createOrGet();
        } else {
            obj = family.find(o -> {
                if (name == null) {
                    SqlModelBuilderUtils.$$$reportNull$$$0(4);
                }
                return name.equals(o.getName()) && (identity == null || identity.equals(o.identity()));
            });
            if (obj != null && !obj.isSyncPending() && StringUtil.isEmpty((String)name) && !(obj instanceof BasicNamespace)) {
                obj = null;
            }
            if (obj instanceof BasicOverloadable) {
                obj = null;
            }
            if (obj == null) {
                obj = family.createNewOne();
                if (obj instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)obj).setName(name);
                }
            } else {
                obj.resetSyncPending();
            }
        }
        return obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/scripting/SqlModelBuilderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hardWarning";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createObject$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

