/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DatabaseStructure
extends BaseTreeModel<Object>
implements InvokerSupplier,
Searchable {
    private static final Key<Map<DasObject, ConcurrentMap<ObjectKind, FamilyGroup>>> FAMILY_GROUPS = KeyWithDefaultValue.create((String)"FAMILY_GROUPS", () -> ConcurrentFactoryMap.createMap(o -> ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()), () -> ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy())));
    private static final Key<Map<DbGroup, Map<String, DbGroup>>> DATABASE_GROUPS = KeyWithDefaultValue.create((String)"DATABASE_GROUPS", () -> ConcurrentFactoryMap.createWeakMap(group2 -> ConcurrentFactoryMap.createMap(name -> new DbGroup((String)name, (DbGroup)((Object)((Object)group2))), () -> ContainerUtil.createConcurrentWeakValueMap())));
    private final Invoker myInvoker = new Invoker.BackgroundThread((Disposable)this);
    private final DbRootGroup myRootGroup;

    DatabaseStructure(DbPsiFacade facade, DatabaseViewOptions viewOptions) {
        this.myRootGroup = new DbRootGroup(facade, viewOptions);
    }

    public void refreshAll() {
        this.treeStructureChanged(null, null, null);
    }

    public Object getRoot() {
        return this.myRootGroup;
    }

    public boolean isLeaf(Object node) {
        return DatabaseStructure.isAlwaysLeafImpl(node);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DatabaseStructure.$$$reportNull$$$0(0);
        }
        return invoker;
    }

    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        LinkedList result2 = ContainerUtil.newLinkedList();
        Object cur = object;
        while (cur != null) {
            result2.addFirst(cur);
            cur = DatabaseStructure.getParentImpl(cur, this.myRootGroup.viewOptions, this.myRootGroup.facade);
        }
        Promise promise = Promise.resolve((Object)new TreePath(ArrayUtil.toObjectArray((Collection)result2)));
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(1);
        }
        return promise;
    }

    private int compareNodes(@NotNull Object o1, @NotNull Object o2) {
        boolean isGroup2;
        boolean isGroup1;
        if (o1 == null) {
            DatabaseStructure.$$$reportNull$$$0(2);
        }
        if (o2 == null) {
            DatabaseStructure.$$$reportNull$$$0(3);
        }
        if ((isGroup1 = o1 instanceof Group) != (isGroup2 = o2 instanceof Group)) {
            return isGroup1 ? -1 : 1;
        }
        int weightDiff = DbPresentation.getWeight(o1, this.myRootGroup.viewOptions.SORT_POSITIONED) - DbPresentation.getWeight(o2, this.myRootGroup.viewOptions.SORT_POSITIONED);
        return weightDiff != 0 ? weightDiff : StringUtil.compare((String)DatabaseStructure.getName(o1), (String)DatabaseStructure.getName(o2), (boolean)false);
    }

    @NotNull
    public List<Object> getChildren(Object parent) {
        List children = (List)this.getChildElements(parent).addAllTo((Collection)ContainerUtil.newArrayList());
        Collections.sort(children, this::compareNodes);
        List list = children;
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static String getName(@NotNull Object o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(5);
        }
        return o instanceof DasObject ? DbPresentation.getPresentableName((DasObject)o, true) : (o instanceof PsiNamedElement ? ((PsiNamedElement)o).getName() : null);
    }

    @NotNull
    private JBIterable<?> getChildElements(Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        JBIterable<?> jBIterable = DatabaseStructure.getChildrenImpl(element, this.myRootGroup.viewOptions, this.myRootGroup.facade);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        BasicElement basic = o instanceof DasObject ? DbImplUtil.getMaybeBasicElement((DasObject)o) : null;
        return basic != null && basic.getFamilyKinds().isEmpty() || o instanceof DasObject && (((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasTableChild || o instanceof DasRoutine || o instanceof DasSynonym);
    }

    public static boolean isDatabaseObject(Object element) {
        return element instanceof DbDataSource || element instanceof DasObject || element instanceof Group;
    }

    @NotNull
    public static JBIterable<?> getChildrenImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        boolean groupOption;
        DasObject root0;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(8);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(9);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(10);
        }
        if (o instanceof DbGroup) {
            JBIterable<? extends PsiElement> jBIterable = DatabaseStructure.getDbGroupChildrenImpl((DbGroup)((Object)o), viewOptions);
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        Object object = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).dasParent : (o instanceof DbDataSource && !viewOptions.SHOW_INTERMEDIATE ? DatabaseStructure.getTopSingleRoot((DbDataSource)o, viewOptions) : (o instanceof DasNamespace && !viewOptions.SHOW_INTERMEDIATE ? DatabaseStructure.getTopSingleRoot((DasObject)o, viewOptions) : (root0 = o instanceof DasObject ? (DasObject)o : null)));
        if (root0 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        DasObject root2 = root0;
        DbDataSource dataSource = facade.findDataSource(root2);
        if (dataSource == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        ObjectKind kidKind = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).kidKind : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        MetaModel metaModel = dialect.getMetaModel();
        boolean isNamespace = rootKind == ObjectKind.ROOT || metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind == ObjectKind.NONE) {
            List groups = ContainerUtil.newSmartList();
            int count2 = 0;
            for (ObjectKind childKind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DbPresentation.getWeight(childKind, ++count2);
                JBIterable<? extends DasObject> kids = DatabaseStructure.getChildObjects(dataSource, root2, childKind);
                if (viewOptions.HIDDEN_KINDS.contains(childKind.code()) || !viewOptions.SHOW_EMPTY_GROUPS && kids.isEmpty()) continue;
                Group group2 = DatabaseStructure.getGroup(root2, childKind, weight, dialect, dataSource);
                group2.size = kids.size();
                groups.add(group2);
            }
            if (groups.size() > 1) {
                JBIterable jBIterable = JBIterable.from((Iterable)groups);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(14);
                }
                return jBIterable;
            }
        }
        JBIterable children = DatabaseStructure.getChildObjects(dataSource, root2, kidKind);
        if (!viewOptions.HIDDEN_KINDS.isEmpty()) {
            children = children.filter(oo -> {
                if (viewOptions == null) {
                    DatabaseStructure.$$$reportNull$$$0(46);
                }
                return !viewOptions.HIDDEN_KINDS.contains(oo.getKind().code());
            });
        }
        JBIterable jBIterable = children;
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<? extends PsiElement> getDbGroupChildrenImpl(@NotNull DbGroup group2, @NotNull DatabaseViewOptions viewOptions) {
        if (group2 == null) {
            DatabaseStructure.$$$reportNull$$$0(16);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(17);
        }
        JBIterable parentGroups = JBIterable.generate((Object)((Object)group2), o -> o.parent);
        DbRootGroup root2 = (DbRootGroup)((Object)ObjectUtils.notNull((Object)parentGroups.filter(DbRootGroup.class).first()));
        JBIterable dataSources2 = JBIterable.from((Iterable)root2.facade.getDataSources());
        if (!viewOptions.GROUP_DATA_SOURCES) {
            JBIterable jBIterable = group2 instanceof DbRootGroup ? dataSources2 : JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        String fullName = group2.getQualifiedName();
        Map groups = (Map)((Map)DATABASE_GROUPS.getRequired((UserDataHolder)root2)).get((Object)group2);
        HashSet<String> subNames = new HashSet<String>();
        ArrayList result2 = ContainerUtil.newArrayList();
        for (DbDataSource dataSource : dataSources2) {
            String subName;
            String groupName = StringUtil.notNullize((String)DatabaseStructure.sanitizeGroupName(((AbstractDataSource)dataSource.getDelegate()).getGroupName()));
            if (!groupName.startsWith(fullName)) continue;
            if (groupName.equals(fullName)) {
                result2.add(dataSource);
                continue;
            }
            if (fullName.length() != 0 && groupName.charAt(fullName.length()) != '/') continue;
            String substring = StringUtil.trimStart((String)groupName.substring(fullName.length()), (String)"/");
            int idx = substring.indexOf("/");
            String string = subName = idx < 0 ? substring : substring.substring(0, idx);
            if (subName.isEmpty()) continue;
            DbGroup subGroup = (DbGroup)((Object)groups.get(subName));
            if (!subNames.add(subName)) {
                ++subGroup.size;
                continue;
            }
            result2.add(subGroup);
            subGroup.size = 1;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)result2);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<? extends DasObject> getChildObjects(DbDataSource ds, DasObject element, ObjectKind kidKind) {
        DasModel model = element instanceof DbDataSource ? ((DbDataSource)element).getModel() : null;
        Condition<DasObject> condition = null;
        if (element instanceof DasNamespace || element instanceof DbDataSource) {
            condition = DatabaseStructure.buildFilter(ds);
        }
        JBIterable res = model instanceof BasicModel ? ((BasicModel)model).getRoot().getDasChildren(kidKind) : (model != null ? model.getModelRoots().filter(DasUtil.byKind((ObjectKind)kidKind)) : element.getDasChildren(kidKind));
        JBIterable jBIterable = condition == null ? res : res.filter(condition);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    private static Condition<DasObject> buildFilter(DbDataSource ds) {
        LocalDataSource source = DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)ds);
        if (source != null) {
            try {
                Condition<DasObject> c = DataSourceUiUtil.buildObjectFilter(source);
                if (c == Condition.TRUE) {
                    return null;
                }
                return o -> o instanceof DasNamespace || c.value(o);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private static Iterable<ObjectKind> getChildKinds(@NotNull Object element, @NotNull MetaModel mm, @NotNull ObjectKind parentKind) {
        Object delegate;
        DasModel model;
        if (element == null) {
            DatabaseStructure.$$$reportNull$$$0(21);
        }
        if (mm == null) {
            DatabaseStructure.$$$reportNull$$$0(22);
        }
        if (parentKind == null) {
            DatabaseStructure.$$$reportNull$$$0(23);
        }
        DasModel dasModel = model = element instanceof DbDataSource ? ((DbDataSource)element).getModel() : null;
        Object object = model instanceof BasicModel ? ((BasicModel)model).getRoot() : (delegate = element instanceof DbElement ? ((DbElement)element).getDelegate() : element);
        if (delegate instanceof BasicElement) {
            List<ObjectKind> list = ((BasicElement)delegate).getFamilyKinds();
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(24);
            }
            return list;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)mm.getKindCouples()).filter(c -> {
            if (parentKind == null) {
                DatabaseStructure.$$$reportNull$$$0(45);
            }
            return c.first == parentKind;
        }).map(c -> (ObjectKind)c.second);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    @Nullable
    public static <T extends DasModel> T getModel(DatabaseSystem ds, Class<T> clazz) {
        LocalDataSource local = DbImplUtil.getMaybeLocalDataSource(ds);
        return (T)(local == null ? null : (DasModel)ObjectUtils.tryCast((Object)local.getModel(), clazz));
    }

    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        PsiElement delegate;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(26);
        }
        if (!o.isValid()) {
            return null;
        }
        Project project = o.getProject();
        Object object = o instanceof DbDataSource ? o : (o instanceof DbElement ? ((DbElement)o).getDelegate() : (delegate = o instanceof Group ? o : null));
        if (delegate == null) {
            return null;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        Object parent = DatabaseStructure.getParentImpl(delegate, viewOptions, facade);
        if (parent instanceof DasObject && !(parent instanceof DbDataSource)) {
            DbDataSource dataSource = facade.findDataSource((DasObject)parent);
            return dataSource == null ? null : DbImplUtil.findElement(dataSource, (DasObject)parent);
        }
        return parent instanceof PsiElement ? (PsiElement)parent : null;
    }

    @Nullable
    private static Object getParentImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        DasObject grandPa;
        boolean groupOption;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(27);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(28);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(29);
        }
        if (o instanceof DbGroup) {
            return ((DbGroup)((Object)o)).parent;
        }
        if (o instanceof DbDataSource) {
            return DatabaseStructure.getDbGroup(facade.getProject(), ((AbstractDataSource)((DbDataSource)o).getDelegate()).getGroupName(), viewOptions);
        }
        Object root0 = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).dasParent : (o instanceof DasObject ? ((DasObject)o).getDasParent() : null);
        DasObject root1 = root0;
        if (root1 == null) {
            return null;
        }
        DbDataSource dataSource = facade.findDataSource(root1);
        if (dataSource == null) {
            return JBIterable.empty();
        }
        DbDataSource root2 = root1.getKind() == ObjectKind.ROOT ? dataSource : root1;
        ObjectKind kidKind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        MetaModel metaModel = dialect.getMetaModel();
        boolean isNamespace = rootKind == ObjectKind.ROOT || metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind != ObjectKind.NONE) {
            Group result2 = null;
            int visible = 0;
            int count2 = 0;
            for (ObjectKind kind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DbPresentation.getWeight(kind, ++count2);
                visible += viewOptions.HIDDEN_KINDS.contains(kind.code()) ? 0 : (viewOptions.SHOW_EMPTY_GROUPS ? 1 : DatabaseStructure.getChildObjects(dataSource, (DasObject)root2, kind).take(1).size());
                if (kind != kidKind) continue;
                result2 = DatabaseStructure.getGroup((DasObject)root2, kidKind, weight, dialect, dataSource);
            }
            if (visible > 1 && result2 != null) {
                return result2;
            }
        }
        while (root1 instanceof DasNamespace && (grandPa = root1.getDasParent()) != null && !viewOptions.SHOW_INTERMEDIATE && DatabaseStructure.getTopSingleRoot(grandPa, viewOptions) != grandPa) {
            root1 = grandPa;
        }
        Object object = root2 = root1.getKind() == ObjectKind.ROOT ? dataSource : root1;
        if (root2 instanceof BasicRoot) {
            return dataSource;
        }
        return root2;
    }

    @NotNull
    static DasObject getTopSingleRoot(@NotNull DbDataSource databaseSystem, DatabaseViewOptions options) {
        DasObject singleRoot;
        BasicRoot root2;
        ObjectKind singleKind;
        DatabaseSystem delegate;
        DasModel model;
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(30);
        }
        DasObject single = (model = (delegate = databaseSystem.getDelegate()).getModel()) instanceof BasicModel ? ((singleKind = (ObjectKind)JBIterable.from((root2 = ((BasicModel)model).getRoot()).getFamilyKinds()).filter(kind -> !options.HIDDEN_KINDS.contains(kind.code()) && root2.getDasChildren((ObjectKind)kind).isNotEmpty()).single()) == null ? null : (DasObject)root2.getDasChildren(singleKind).single()) : ((singleRoot = (DasObject)model.getModelRoots().single()) != null && !options.HIDDEN_KINDS.contains(singleRoot.getKind().code()) ? singleRoot : null);
        Object object = single == null ? databaseSystem : DatabaseStructure.getTopSingleRoot(single, options);
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(31);
        }
        return object;
    }

    static DasObject getTopSingleRoot(@NotNull DasObject element, @NotNull DatabaseViewOptions options) {
        DasNamespace value;
        if (element == null) {
            DatabaseStructure.$$$reportNull$$$0(32);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(33);
        }
        DasObject e = element;
        while ((value = (DasNamespace)e.getDasChildren(null).filter(DasNamespace.class).single()) != null && !options.HIDDEN_KINDS.contains(value.getKind().code())) {
            e = value;
        }
        return e;
    }

    static Group getGroup(@NotNull DasObject parentElement, @NotNull ObjectKind childKind, int weight, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource) {
        ConcurrentMap groupMap;
        FamilyGroup result2;
        if (parentElement == null) {
            DatabaseStructure.$$$reportNull$$$0(34);
        }
        if (childKind == null) {
            DatabaseStructure.$$$reportNull$$$0(35);
        }
        if (dialect == null) {
            DatabaseStructure.$$$reportNull$$$0(36);
        }
        if (dataSource == null) {
            DatabaseStructure.$$$reportNull$$$0(37);
        }
        if ((result2 = (FamilyGroup)((Object)(groupMap = (ConcurrentMap)((Map)FAMILY_GROUPS.getRequired((UserDataHolder)dataSource)).get(parentElement)).get(childKind))) == null || result2.weight != weight) {
            String name = StringUtil.pluralize((String)DbPresentation.getPresentableName(childKind, dialect));
            result2 = (FamilyGroup)((Object)ConcurrencyUtil.cacheOrGet((ConcurrentMap)groupMap, (Object)childKind, (Object)((Object)new FamilyGroup(name, childKind, parentElement, dataSource, weight))));
        }
        return result2;
    }

    @NotNull
    public static PsiElement getDbGroup(@NotNull Project project, @Nullable String groupName, @NotNull DatabaseViewOptions viewOptions) {
        if (project == null) {
            DatabaseStructure.$$$reportNull$$$0(38);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(39);
        }
        DbRootGroup root2 = (DbRootGroup)((Object)DatabaseView.getDatabaseView(project).getTreeRoot());
        if (!viewOptions.GROUP_DATA_SOURCES) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(40);
            }
            return dbRootGroup;
        }
        Map map = (Map)DATABASE_GROUPS.getRequired((UserDataHolder)root2);
        if (StringUtil.isEmpty((String)groupName)) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(41);
            }
            return dbRootGroup;
        }
        PsiElement psiElement = (PsiElement)JBIterable.from((Iterable)StringUtil.split((String)groupName, (String)"/")).reduce((Object)root2, (p, s) -> (DbGroup)((Object)((Object)((Map)map.get(p)).get(s))));
        if (psiElement == null) {
            DatabaseStructure.$$$reportNull$$$0(42);
        }
        return psiElement;
    }

    public static void renameGroup(@NotNull Project project, DbGroup group2, @NotNull String newName) {
        if (project == null) {
            DatabaseStructure.$$$reportNull$$$0(43);
        }
        if (newName == null) {
            DatabaseStructure.$$$reportNull$$$0(44);
        }
        String fullname = group2.getQualifiedName();
        String pathname = StringUtil.trimEnd((String)fullname, (String)group2.name);
        String newFullname = pathname + newName;
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            AbstractDataSource ds = (AbstractDataSource)((Object)ObjectUtils.tryCast((Object)dataSource.getDelegate(), AbstractDataSource.class));
            String cur = ds == null ? null : ds.getGroupName();
            if (cur == null || !cur.startsWith(fullname)) continue;
            ds.setGroupName(newFullname + cur.substring(fullname.length()));
        }
        PsiElement newGroup = DatabaseStructure.getDbGroup(project, newFullname, DatabaseView.getDatabaseView(project).getViewOptions());
        DatabaseView.refreshViewAndSelect(project, Collections.singleton(newGroup));
    }

    @Nullable
    public static String sanitizeGroupName(@Nullable String groupName) {
        return groupName == null ? null : StringUtil.nullize((String)StringUtil.trimStart((String)StringUtil.trimEnd((String)groupName.replaceAll("(?:/\\s*)+", "/"), (String)"/"), (String)"/"));
    }

    @Contract(value="!null->!null")
    public static Object unwrap(@Nullable Object o) {
        return o instanceof DbElement && !(o instanceof DbDataSource) ? ((DbElement)o).getDelegate() : o;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 5: 
            case 8: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: 
            case 17: 
            case 28: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 23: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childKind";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroupChildrenImpl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildObjects";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSingleRoot";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroupChildrenImpl";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTopSingleRoot";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroup";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "renameGroup";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildKinds$10";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildrenImpl$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FamilyGroup
    extends Group
    implements WeighedItem {
        public final DbDataSource dataSource;
        public final DasObject dasParent;
        public final ObjectKind kidKind;
        final int weight;

        FamilyGroup(@NotNull String name, @NotNull ObjectKind kidKind, @NotNull DasObject dasParent, @NotNull DbDataSource dataSource, int weight) {
            if (name == null) {
                FamilyGroup.$$$reportNull$$$0(0);
            }
            if (kidKind == null) {
                FamilyGroup.$$$reportNull$$$0(1);
            }
            if (dasParent == null) {
                FamilyGroup.$$$reportNull$$$0(2);
            }
            if (dataSource == null) {
                FamilyGroup.$$$reportNull$$$0(3);
            }
            super(name);
            this.dataSource = dataSource;
            this.kidKind = kidKind;
            this.dasParent = dasParent;
            this.weight = weight;
        }

        public PsiElement getParent() {
            return DbImplUtil.findElement(this.dataSource, this.dasParent);
        }

        public int getWeight() {
            return this.weight;
        }

        @NotNull
        public JBIterable<? extends DbElement> iterateChildren() {
            DbElement parent = DbImplUtil.findElement(this.dataSource, this.dasParent);
            JBIterable jBIterable = parent == null ? JBIterable.empty() : parent.getDasChildren(this.kidKind);
            if (jBIterable == null) {
                FamilyGroup.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kidKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dasParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbRootGroup
    extends DbGroup {
        public final DbPsiFacade facade;
        public final DatabaseViewOptions viewOptions;

        public DbRootGroup(@NotNull DbPsiFacade facade, @NotNull DatabaseViewOptions options) {
            if (facade == null) {
                DbRootGroup.$$$reportNull$$$0(0);
            }
            if (options == null) {
                DbRootGroup.$$$reportNull$$$0(1);
            }
            super(ToolWindowId.DATABASE_VIEW, null);
            this.facade = facade;
            this.viewOptions = options;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.facade.getProject();
            if (project == null) {
                DbRootGroup.$$$reportNull$$$0(2);
            }
            return project;
        }

        @Override
        public String getQualifiedName() {
            return "";
        }

        public PsiFile getContainingFile() {
            return null;
        }

        @Override
        public PsiElement getParent() {
            return null;
        }

        public boolean isValid() {
            return !this.getProject().isDisposed();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbGroup
    extends Group {
        final DbGroup parent;

        public DbGroup(String name, DbGroup parent) {
            super(name);
            this.parent = parent;
        }

        public PsiElement getParent() {
            return this.parent;
        }

        @NotNull
        public Project getProject() {
            Project project = this.getParent().getProject();
            if (project == null) {
                DbGroup.$$$reportNull$$$0(0);
            }
            return project;
        }

        @Override
        @NotNull
        public JBIterable<? extends PsiElement> iterateChildren() {
            DbRootGroup root2 = (DbRootGroup)((Object)ObjectUtils.notNull((Object)SyntaxTraverser.psiApi().parents((Object)this).filter(DbRootGroup.class).first()));
            JBIterable jBIterable = DatabaseStructure.getDbGroupChildrenImpl(this, root2.viewOptions);
            if (jBIterable == null) {
                DbGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public String getQualifiedName() {
            StringBuilder sb = new StringBuilder(this.name);
            DbGroup cur = this.parent;
            while (cur != null && !(cur instanceof DbRootGroup)) {
                sb.insert(0, cur.name + "/");
                cur = cur.parent;
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/DatabaseStructure$DbGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class Group
    extends FakePsiElement
    implements NavigationItem {
        public final String name;
        final PresentationData presentation;
        int size;

        public Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.presentation = new PresentationData();
            this.name = name;
        }

        @NotNull
        public abstract JBIterable<? extends PsiElement> iterateChildren();

        public ItemPresentation getPresentation() {
            this.presentation.clear();
            this.presentation.setIcon(this.getIcon(false));
            this.presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.size > 0) {
                this.presentation.addText("  " + this.size, DatabaseView.groupCountAttrs(false));
            }
            return this.presentation;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                Group.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DatabaseIcons.ObjectGroup;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

