/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectInDatabaseView
implements SelectInTarget,
DumbAware {
    @NonNls
    public static final String DATABASE = DatabaseMessages.message((String)"select.in.database.view", (Object[])new Object[0]);
    public static final ExtensionPointName<Function<SelectInContext, DbElement>> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.database.selectInProvider");

    public String toString() {
        return DATABASE;
    }

    @Nullable
    public static DbElement askProviders(@NotNull SelectInContext context) {
        if (context == null) {
            SelectInDatabaseView.$$$reportNull$$$0(0);
        }
        DbElement element = null;
        for (Function provider : (Function[])EXTENSION_POINT_NAME.getExtensions()) {
            DbElement cur = (DbElement)provider.fun((Object)context);
            if (cur == null || element != null && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)cur, (boolean)true)) continue;
            element = cur;
        }
        return element;
    }

    public boolean canSelect(SelectInContext context) {
        VirtualFile file = context.getVirtualFile();
        return !file.isDirectory() && SelectInDatabaseView.askProviders(context) != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        DbElement dbElement = SelectInDatabaseView.askProviders(context);
        if (dbElement != null) {
            DatabaseView.select((PsiElement)dbElement, requestFocus);
        }
    }

    public String getToolWindowId() {
        return ToolWindowId.DATABASE_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.5f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/SelectInDatabaseView", "askProviders"));
    }
}

